/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice.binding;

import org.robovm.libimobiledevice.binding.LibIMobileDeviceJNI;

public class ByteArray {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ByteArray(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ByteArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(ByteArray obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LibIMobileDeviceJNI.delete_ByteArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setValue(byte value) {
        LibIMobileDeviceJNI.ByteArray_value_set(this.swigCPtr, this, value);
    }

    public byte getValue() {
        return LibIMobileDeviceJNI.ByteArray_value_get(this.swigCPtr, this);
    }

    public ByteArray(int nelements) {
        this(LibIMobileDeviceJNI.new_ByteArray(nelements), true);
    }

    public byte get(int index) {
        return LibIMobileDeviceJNI.ByteArray_get(this.swigCPtr, this, index);
    }

    public void set(int index, byte value) {
        LibIMobileDeviceJNI.ByteArray_set(this.swigCPtr, this, index, value);
    }
}

