/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice.binding;

import org.robovm.libimobiledevice.binding.IDeviceConnectiontype;
import org.robovm.libimobiledevice.binding.IDeviceEventType;
import org.robovm.libimobiledevice.binding.LibIMobileDeviceJNI;

public class IDeviceEvent {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IDeviceEvent(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IDeviceEvent obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(IDeviceEvent obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LibIMobileDeviceJNI.delete_IDeviceEvent(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setEvent(IDeviceEventType value) {
        LibIMobileDeviceJNI.IDeviceEvent_event_set(this.swigCPtr, this, value.swigValue());
    }

    public IDeviceEventType getEvent() {
        return IDeviceEventType.swigToEnum(LibIMobileDeviceJNI.IDeviceEvent_event_get(this.swigCPtr, this));
    }

    public void setUdid(String value) {
        LibIMobileDeviceJNI.IDeviceEvent_udid_set(this.swigCPtr, this, value);
    }

    public String getUdid() {
        return LibIMobileDeviceJNI.IDeviceEvent_udid_get(this.swigCPtr, this);
    }

    public void setConnectionType(IDeviceConnectiontype value) {
        LibIMobileDeviceJNI.IDeviceEvent_connectionType_set(this.swigCPtr, this, value.swigValue());
    }

    public IDeviceConnectiontype getConnectionType() {
        return IDeviceConnectiontype.swigToEnum(LibIMobileDeviceJNI.IDeviceEvent_connectionType_get(this.swigCPtr, this));
    }

    public IDeviceEvent() {
        this(LibIMobileDeviceJNI.new_IDeviceEvent(), true);
    }
}

