/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice.binding;

import org.robovm.libimobiledevice.binding.LibIMobileDeviceJNI;

public class StringArray {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected StringArray(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(StringArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected static long swigRelease(StringArray obj) {
        long ptr = 0L;
        if (obj != null) {
            if (!obj.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            ptr = obj.swigCPtr;
            obj.swigCMemOwn = false;
            obj.delete();
        }
        return ptr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LibIMobileDeviceJNI.delete_StringArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setValue(String value) {
        LibIMobileDeviceJNI.StringArray_value_set(this.swigCPtr, this, value);
    }

    public String getValue() {
        return LibIMobileDeviceJNI.StringArray_value_get(this.swigCPtr, this);
    }

    public StringArray(int nelements) {
        this(LibIMobileDeviceJNI.new_StringArray(nelements), true);
    }

    public String get(int index) {
        return LibIMobileDeviceJNI.StringArray_get(this.swigCPtr, this, index);
    }

    public void set(int index, String value) {
        LibIMobileDeviceJNI.StringArray_set(this.swigCPtr, this, index, value);
    }
}

