/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robovm.libimobiledevice.util.Version;

public final class DeveloperImageResolver {
    private static String xcodePath;

    static File getXcodePath() throws Exception {
        if (xcodePath != null) {
            return new File(xcodePath);
        }
        File tmpFile = File.createTempFile("DeveloperImageResolver", ".tmp");
        try {
            int ret = new ProcessBuilder("xcode-select", "-print-path").redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.to(tmpFile)).start().waitFor();
            if (ret != 0) {
                throw new IOException("xcode-select failed with error code: " + ret);
            }
            File file = new File(new String(Files.readAllBytes(tmpFile.toPath()), StandardCharsets.UTF_8).trim());
            return file;
        }
        finally {
            tmpFile.delete();
        }
    }

    static File getDeviceSupportPath() throws Exception {
        return new File(DeveloperImageResolver.getXcodePath(), "Platforms/iPhoneOS.platform/DeviceSupport");
    }

    static Response findDeveloperImage(File dsDir, Version deviceVersion) throws FileNotFoundException {
        File[] dirs;
        Pattern pattern = Pattern.compile("(\\d+(?:\\.\\d+)*)(?:\\s*\\((.*)\\))?");
        Version bestMatchVersion = null;
        File bestMatchDmgFile = null;
        File bestMatchSignatureFile = null;
        for (File dir : dirs = dsDir.listFiles()) {
            Version dmgVersion;
            Matcher matcher;
            if (!dir.isDirectory() || !(matcher = pattern.matcher(dir.getName())).matches()) continue;
            File dmg = new File(dir, "DeveloperDiskImage.dmg");
            File sig = new File(dir, dmg.getName() + ".signature");
            if (!dmg.isFile() || !sig.isFile() || (dmgVersion = Version.parse(matcher.group(1))).getMajor() != deviceVersion.getMajor()) continue;
            int diff = dmgVersion.compareTo(deviceVersion);
            if (diff == 0) {
                bestMatchVersion = dmgVersion;
                bestMatchDmgFile = dmg;
                bestMatchSignatureFile = sig;
                break;
            }
            if (diff >= 0 || bestMatchVersion != null && bestMatchVersion.compareTo(dmgVersion) >= 0) continue;
            bestMatchVersion = dmgVersion;
            bestMatchDmgFile = dmg;
            bestMatchSignatureFile = sig;
        }
        if (bestMatchDmgFile == null) {
            throw new FileNotFoundException("No DeveloperDiskImage.dmg found in " + dsDir.getAbsolutePath() + " for iOS version " + deviceVersion);
        }
        return new Response(bestMatchVersion, bestMatchDmgFile, bestMatchSignatureFile);
    }

    static class Response {
        final Version version;
        final File dmg;
        final File signature;

        Response(Version version, File dmg, File signature) {
            this.version = version;
            this.dmg = dmg;
            this.signature = signature;
        }
    }
}

