/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice.util;

import java.util.Arrays;
import java.util.stream.Collectors;

class Version
implements Comparable<Version> {
    public final int[] parts;

    public Version(int ... parts) {
        this.parts = parts;
    }

    @Override
    public int compareTo(Version other) {
        int commonPart = Math.min(this.parts.length, other.parts.length);
        for (int i = 0; i < commonPart; ++i) {
            int diff = this.parts[i] - other.parts[i];
            if (diff == 0) continue;
            return diff;
        }
        return this.parts.length - other.parts.length;
    }

    public int getMajor() {
        return this.parts[0];
    }

    public static Version parse(String v) {
        String[] tokens = v.split("\\.");
        int[] parts = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            parts[i] = Integer.parseInt(tokens[i]);
        }
        return new Version(parts);
    }

    public String toString() {
        return Arrays.stream(this.parts).mapToObj(Integer::toString).collect(Collectors.joining("."));
    }
}

