/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import java.util.ArrayList;
import java.util.List;
import org.robovm.libimobiledevice.IDeviceConnection;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.binding.IDeviceConnectionRefOut;
import org.robovm.libimobiledevice.binding.IDeviceError;
import org.robovm.libimobiledevice.binding.IDeviceRef;
import org.robovm.libimobiledevice.binding.IDeviceRefOut;
import org.robovm.libimobiledevice.binding.IntOut;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;
import org.robovm.libimobiledevice.binding.StringArray;
import org.robovm.libimobiledevice.binding.StringArrayOut;
import org.robovm.libimobiledevice.binding.StringOut;

public class IDevice
implements AutoCloseable {
    static List<EventListener> listeners = new ArrayList<EventListener>();
    protected IDeviceRef ref;

    IDevice(IDeviceRef ref) {
        this.ref = ref;
    }

    public IDevice(String udid) {
        if (udid == null) {
            throw new NullPointerException("udid");
        }
        IDeviceRefOut refOut = new IDeviceRefOut();
        try {
            IDevice.checkResult(LibIMobileDevice.idevice_new(refOut, udid));
            this.ref = refOut.getValue();
        }
        finally {
            refOut.delete();
        }
    }

    protected IDeviceRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    public String getUdid() {
        StringOut out = new StringOut();
        try {
            IDevice.checkResult(LibIMobileDevice.idevice_get_udid(this.getRef(), out));
            String string = out.getValue();
            return string;
        }
        finally {
            out.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDeviceConnection connect(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range");
        }
        IDeviceConnectionRefOut connOut = new IDeviceConnectionRefOut();
        try {
            IDevice.checkResult(LibIMobileDevice.idevice_connect(this.getRef(), (short)port, connOut));
            IDeviceConnection iDeviceConnection = new IDeviceConnection(connOut.getValue());
            return iDeviceConnection;
        }
        finally {
            connOut.delete();
        }
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LibIMobileDeviceException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LibIMobileDevice.idevice_free(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public static void setDebugLevel(int level) {
        LibIMobileDevice.idevice_set_debug_level(level > 0 ? 1 : 0);
    }

    public static String[] listUdids() {
        StringArrayOut devicesOut = new StringArrayOut();
        IntOut countOut = new IntOut();
        try {
            IDevice.checkResult(LibIMobileDevice.idevice_get_device_list(devicesOut, countOut));
            StringArray devices = devicesOut.getValue();
            int count = countOut.getValue();
            String[] udids = new String[count];
            for (int i = 0; i < count; ++i) {
                udids[i] = devices.get(i);
            }
            String[] stringArray = udids;
            return stringArray;
        }
        catch (LibIMobileDeviceException e) {
            if (e.getErrorCode() == IDeviceError.IDEVICE_E_NO_DEVICE.swigValue()) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            throw e;
        }
        finally {
            devicesOut.delete();
            countOut.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEventListener(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<EventListener> list = listeners;
        synchronized (list) {
            listeners.add(listener);
            if (listeners.size() == 1) {
                LibIMobileDevice.idevice_event_subscribe(LibIMobileDevice.get_global_idevice_event_cb(), 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEventListener(EventListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<EventListener> list = listeners;
        synchronized (list) {
            if (listeners.remove(listener) && listeners.isEmpty()) {
                LibIMobileDevice.idevice_event_unsubscribe();
            }
        }
    }

    static void checkResult(IDeviceError result) {
        if (result != IDeviceError.IDEVICE_E_SUCCESS) {
            throw new LibIMobileDeviceException(result.swigValue(), result.name());
        }
    }

    static void checkResult(IDeviceError result, IDeviceError allowed) {
        if (result != IDeviceError.IDEVICE_E_SUCCESS && result != allowed) {
            throw new LibIMobileDeviceException(result.swigValue(), result.name());
        }
    }

    public static void main(String[] args) throws Exception {
        String[] udids = IDevice.listUdids();
        if (udids.length == 0) {
            System.err.println("No devices connected");
            return;
        }
        for (int i = 0; i < udids.length; ++i) {
            System.out.format("%d: %s\n", i, udids[i]);
        }
    }

    public static interface EventListener {
        public void deviceAdded(String var1);

        public void deviceRemoved(String var1);
    }
}

