/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.libimobiledevice;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.robovm.libimobiledevice.IDevice;
import org.robovm.libimobiledevice.LibIMobileDeviceException;
import org.robovm.libimobiledevice.binding.IDeviceConnectionRef;
import org.robovm.libimobiledevice.binding.IDeviceError;
import org.robovm.libimobiledevice.binding.IntOut;
import org.robovm.libimobiledevice.binding.LibIMobileDevice;

public class IDeviceConnection
implements AutoCloseable {
    protected IDeviceConnectionRef ref;
    private DeviceInputStream deviceInputStream;
    private DeviceOutputStream deviceOutputStream;

    IDeviceConnection(IDeviceConnectionRef ref) {
        this.ref = ref;
    }

    protected IDeviceConnectionRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    private void createStreams() {
        if (this.deviceInputStream == null) {
            this.deviceInputStream = new DeviceInputStream();
            this.deviceOutputStream = new DeviceOutputStream();
        }
    }

    public InputStream getInputStream() {
        this.createStreams();
        return this.deviceInputStream;
    }

    public OutputStream getOutputStream() {
        this.createStreams();
        return this.deviceOutputStream;
    }

    public int receive(byte[] buffer, int offset, int count) {
        return this.receive(buffer, offset, count, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(byte[] buffer, int offset, int count, int timeout) {
        this.checkArrayBounds(buffer, offset, count);
        if (count == 0) {
            return 0;
        }
        byte[] data = buffer;
        if (offset > 0) {
            data = new byte[count];
        }
        IntOut bytesReceivedOut = new IntOut();
        try {
            IDevice.checkResult(LibIMobileDevice.idevice_connection_receive_timeout(this.getRef(), data, count, bytesReceivedOut, timeout), IDeviceError.IDEVICE_E_TIMEOUT);
            int bytesRead = bytesReceivedOut.getValue();
            if (bytesRead > 0 && data != buffer) {
                System.arraycopy(data, 0, buffer, offset, bytesRead);
            }
            int n = bytesRead;
            return n;
        }
        finally {
            bytesReceivedOut.delete();
        }
    }

    private void checkArrayBounds(byte[] buffer, int offset, int count) {
        if ((offset | count) < 0 || offset > buffer.length || buffer.length - offset < count) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(byte[] buffer, int offset, int count) {
        this.checkArrayBounds(buffer, offset, count);
        if (count == 0) {
            return 0;
        }
        byte[] data = buffer;
        if (offset > 0) {
            data = new byte[count];
            System.arraycopy(buffer, offset, data, 0, count);
        }
        IntOut bytesSentOut = new IntOut();
        try {
            IDevice.checkResult(LibIMobileDevice.idevice_connection_send(this.getRef(), data, count, bytesSentOut));
            int n = bytesSentOut.getValue();
            return n;
        }
        finally {
            bytesSentOut.delete();
        }
    }

    public void disconnect() {
        this.dispose();
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LibIMobileDeviceException("Already disposed");
        }
    }

    public synchronized void dispose() {
        this.checkDisposed();
        LibIMobileDevice.idevice_disconnect(this.ref);
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    private class DeviceOutputStream
    extends OutputStream {
        private DeviceOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            byte[] buffer = new byte[]{(byte)b};
            this.write(buffer);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            IDeviceConnection.this.checkArrayBounds(b, off, len);
            try {
                IDeviceConnection.this.send(b, off, len);
            }
            catch (LibIMobileDeviceException e) {
                throw new IOException(e);
            }
        }
    }

    private class DeviceInputStream
    extends InputStream {
        private DeviceInputStream() {
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int n = this.read(b);
            return n <= 0 ? -1 : b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return IDeviceConnection.this.receive(b, off, len);
            }
            catch (LibIMobileDeviceException e) {
                throw new IOException(e);
            }
        }
    }
}

