/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.robovm.llvm.Context;
import org.robovm.llvm.Function;
import org.robovm.llvm.LlvmException;
import org.robovm.llvm.Type;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.MemoryBufferRef;
import org.robovm.llvm.binding.ModuleRef;
import org.robovm.llvm.binding.ModuleRefOut;
import org.robovm.llvm.binding.StringOut;
import org.robovm.llvm.binding.ValueRef;

public class Module
implements AutoCloseable {
    private ModuleRef ref;

    private Module(ModuleRef moduleRef) {
        this.ref = moduleRef;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LlvmException("Already disposed");
        }
    }

    protected ModuleRef getRef() {
        this.checkDisposed();
        return this.ref;
    }

    public synchronized void dispose() {
        LLVM.DisposeModule(this.getRef());
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public Type getTypeByName(String name) {
        return new Type(LLVM.GetTypeByName(this.getRef(), name));
    }

    public Function getFunctionByName(String name) {
        ValueRef fref = LLVM.GetNamedFunction(this.getRef(), name);
        return fref != null ? new Function(fref) : null;
    }

    public Function[] getFunctions() {
        ArrayList<Function> result = new ArrayList<Function>();
        ValueRef fref = LLVM.GetFirstFunction(this.getRef());
        while (fref != null) {
            result.add(new Function(fref));
            fref = LLVM.GetNextFunction(fref);
        }
        return result.toArray(new Function[result.size()]);
    }

    public void writeBitcode(File file) {
        if (LLVM.WriteBitcodeToFile(this.getRef(), file.getAbsolutePath()) != 0) {
            throw new LlvmException("Write failed");
        }
    }

    public void link(Module other) {
        StringOut errorMessage = new StringOut();
        if (LLVM.LinkModules(this.getRef(), other.getRef(), 0, errorMessage)) {
            throw new LlvmException(errorMessage.getValue().trim());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ref == null ? 0 : this.ref.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Module other = (Module)obj;
        return !(this.ref == null ? other.ref != null : !this.ref.equals(other.ref));
    }

    public static Module parseIR(Context context, String ir, String filename) {
        try {
            return Module.parseIR(context, ir.getBytes("utf-8"), filename);
        }
        catch (UnsupportedEncodingException e) {
            throw new LlvmException(e);
        }
    }

    public static Module parseIR(Context context, byte[] data, String filename) {
        MemoryBufferRef memoryBufferRef = LLVM.CreateMemoryBufferWithMemoryRangeCopy(data, filename = filename == null ? "" : filename);
        if (memoryBufferRef == null) {
            throw new LlvmException("Failed to create memory buffer");
        }
        ModuleRefOut moduleRefOut = new ModuleRefOut();
        StringOut errorMessage = new StringOut();
        if (!LLVM.ParseIRInContext(context.getRef(), memoryBufferRef, moduleRefOut, errorMessage)) {
            return new Module(moduleRefOut.getValue());
        }
        throw new LlvmException(errorMessage.getValue().trim());
    }

    public static Module parseClangString(Context context, String buffer, String fileName, String triple) {
        StringOut errorMessage = new StringOut();
        ModuleRef ref = LLVM.ClangCompileFile(context.getRef(), buffer, fileName, triple, errorMessage);
        if (ref != null) {
            return new Module(ref);
        }
        throw new LlvmException(errorMessage.getValue().trim());
    }
}

