/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import org.robovm.llvm.LlvmException;
import org.robovm.llvm.ObjectFile;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.SectionIteratorRef;

public class SectionIterator
implements AutoCloseable {
    protected ObjectFile objectFile;
    protected SectionIteratorRef ref;

    SectionIterator(ObjectFile objectFile, SectionIteratorRef ref) {
        this.objectFile = objectFile;
        this.ref = ref;
    }

    protected final void checkDisposed() {
        if (this.ref == null) {
            throw new LlvmException("Already disposed");
        }
    }

    public synchronized void dispose() {
        LLVM.DisposeSectionIterator(this.getRef());
        this.ref = null;
    }

    @Override
    public void close() {
        this.dispose();
    }

    protected SectionIteratorRef getRef() {
        return this.ref;
    }

    public String getName() {
        return LLVM.GetSectionName(this.getRef());
    }

    public long getAddress() {
        return LLVM.GetSectionAddress(this.getRef());
    }

    public long getSize() {
        return LLVM.GetSectionSize(this.getRef());
    }

    public long copyContents(byte[] dest) {
        return LLVM.CopySectionContents(this.getRef(), dest);
    }

    public void next() {
        LLVM.MoveToNextSection(this.getRef());
    }

    public boolean hasNext() {
        return !LLVM.IsSectionIteratorAtEnd(this.objectFile.getRef(), this.getRef());
    }
}

