/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm.binding;

import org.robovm.llvm.binding.LLVMJNI;

public class IntArray {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IntArray(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IntArray obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LLVMJNI.delete_IntArray(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setValue(int value) {
        LLVMJNI.IntArray_value_set(this.swigCPtr, this, value);
    }

    public int getValue() {
        return LLVMJNI.IntArray_value_get(this.swigCPtr, this);
    }

    public IntArray(int nelements) {
        this(LLVMJNI.new_IntArray(nelements), true);
    }

    public int get(int index) {
        return LLVMJNI.IntArray_get(this.swigCPtr, this, index);
    }

    public void set(int index, int value) {
        LLVMJNI.IntArray_set(this.swigCPtr, this, index, value);
    }
}

