/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm.debuginfo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.robovm.llvm.debuginfo.DwarfDebugVariableInfo;

public class DwarfDebugMethodInfo {
    private final String name;
    private final DwarfDebugVariableInfo[] localvariables;
    private Map<String, DwarfDebugVariableInfo> variableByName;

    public DwarfDebugMethodInfo(String name, DwarfDebugVariableInfo[] localvariables) {
        this.name = name;
        this.localvariables = localvariables;
    }

    public String signature() {
        return this.name;
    }

    public DwarfDebugVariableInfo[] localvariables() {
        return this.localvariables;
    }

    public String toString() {
        return "DwarfDebugMethodInfo{name='" + this.name + "', localvariables=" + Arrays.toString(this.localvariables) + "}";
    }

    public DwarfDebugVariableInfo variableByName(String name) {
        if (this.variableByName == null) {
            this.variableByName = new HashMap<String, DwarfDebugVariableInfo>();
            for (DwarfDebugVariableInfo variableInfo : this.localvariables) {
                this.variableByName.put(variableInfo.name(), variableInfo);
            }
        }
        return this.variableByName.get(name);
    }
}

