/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm;

import java.util.ArrayList;
import org.robovm.llvm.binding.Attribute;
import org.robovm.llvm.binding.LLVM;
import org.robovm.llvm.binding.Linkage;
import org.robovm.llvm.binding.ValueRef;

public class Function {
    private ValueRef ref;

    Function(ValueRef ref) {
        this.ref = ref;
    }

    protected ValueRef getRef() {
        return this.ref;
    }

    public String getName() {
        return LLVM.GetValueName(this.getRef());
    }

    public Linkage getLinkage() {
        return LLVM.GetLinkage(this.getRef());
    }

    public void setLinkage(Linkage linkage) {
        LLVM.SetLinkage(this.getRef(), linkage);
    }

    public Attribute[] getAttributes() {
        int mask = LLVM.GetFunctionAttr(this.getRef());
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (Attribute a : Attribute.values()) {
            if ((a.swigValue() & mask) == 0) continue;
            result.add(a);
        }
        return result.toArray(new Attribute[result.size()]);
    }

    public void addAttribute(Attribute attribute) {
        LLVM.AddFunctionAttr(this.getRef(), attribute.swigValue());
    }

    public void removeAttribute(Attribute attribute) {
        LLVM.RemoveFunctionAttr(this.getRef(), attribute.swigValue());
    }
}

