/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm.debuginfo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.robovm.llvm.debuginfo.DebugVariableInfo;

public class DebugMethodInfo {
    private final String name;
    private final DebugVariableInfo[] localvariables;
    private Map<String, DebugVariableInfo> variableByName;
    private final int startLine;
    private final int finalLine;

    public DebugMethodInfo(String name, DebugVariableInfo[] localvariables) {
        this.name = name;
        this.localvariables = localvariables;
        this.startLine = -1;
        this.finalLine = -1;
    }

    public DebugMethodInfo(String name, DebugVariableInfo[] localvariables, int startLine, int finalLine) {
        this.name = name;
        this.localvariables = localvariables;
        this.startLine = startLine;
        this.finalLine = finalLine;
    }

    public String signature() {
        return this.name;
    }

    public DebugVariableInfo[] localvariables() {
        return this.localvariables;
    }

    public int startLine() {
        return this.startLine;
    }

    public int finalLine() {
        return this.finalLine;
    }

    public String toString() {
        return "DebugMethodInfo{name='" + this.name + '\'' + ", localvariables=" + Arrays.toString(this.localvariables) + '}';
    }

    public DebugVariableInfo variableByName(String name) {
        if (this.variableByName == null) {
            this.variableByName = new HashMap<String, DebugVariableInfo>();
            for (DebugVariableInfo variableInfo : this.localvariables) {
                this.variableByName.put(variableInfo.name(), variableInfo);
            }
        }
        return this.variableByName.get(name);
    }
}

