/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.llvm.debuginfo;

public class DebugVariableInfo {
    public static final int OP_breg13 = 125;
    public static final int OP_fbreg = 145;
    public static final int OP_breg31 = 143;
    private final String name;
    private final boolean isArgument;
    private final int startLine;
    private final int finalLine;
    private final String typeSignature;
    private final int register;
    private final int offset;

    public DebugVariableInfo(String name, boolean isArgument, int register, int offset) {
        this.name = name;
        this.isArgument = isArgument;
        this.register = register;
        this.offset = offset;
        this.startLine = -1;
        this.finalLine = -1;
        this.typeSignature = null;
    }

    public DebugVariableInfo(String name, String typeSignature, boolean isArgument, int startLine, int finalLine, int register, int offset) {
        this.name = name;
        this.typeSignature = typeSignature;
        this.isArgument = isArgument;
        this.startLine = startLine;
        this.finalLine = finalLine;
        this.register = register;
        this.offset = offset;
    }

    public String name() {
        return this.name;
    }

    public boolean isArgument() {
        return this.isArgument;
    }

    public int register() {
        return this.register;
    }

    public int offset() {
        return this.offset;
    }

    public int startLine() {
        return this.startLine;
    }

    public int finalLine() {
        return this.finalLine;
    }

    public String typeSignature() {
        return this.typeSignature;
    }

    public static String registerName(int register) {
        if (register == 125) {
            return "OP_breg13";
        }
        if (register == 143) {
            return "OP_breg31";
        }
        if (register == 145) {
            return "OP_fbreg";
        }
        return "OP_" + Integer.toHexString(register);
    }

    public String toString() {
        return "DebugVariableInfo{name='" + this.name + '\'' + ", isArgument=" + this.isArgument + ", register=" + DebugVariableInfo.registerName(this.register) + ", offset=" + this.offset + '}';
    }
}

