/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.objc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robovm.objc.ObjCClassNotFoundException;
import org.robovm.objc.ObjCObject;
import org.robovm.objc.ObjCProtocol;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.BindSelector;
import org.robovm.objc.annotation.CustomClass;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.NativeProtocolProxy;
import org.robovm.objc.annotation.TypeEncoding;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.ptr.IntPtr;

@Library(value="objc")
public final class ObjCClass
extends ObjCObject {
    private static final String OBJC_PROXY_CLASS_SUFFIX = "$ObjCProxy";
    private static final int OBJC_PROXY_CLASS_SUFFIX_LENGTH;
    private static final Map<Class<? extends ObjCObject>, ObjCClass> typeToClass;
    private static final Map<String, ObjCClass> nameToClass;
    private static final Map<String, Class<? extends ObjCObject>> allNativeClasses;
    private static final Map<String, Class<? extends ObjCObject>> allNativeProtocolProxies;
    private static final Map<String, Class<? extends ObjCObject>> allCustomClasses;
    static final Map<String, Class<? extends ObjCObject>> allObjCProxyClasses;
    private static final int ACC_SYNTHETIC = 4096;
    private static final String CUSTOM_CLASS_NAME_PREFIX = "j_";
    private final Class<? extends ObjCObject> type;
    private final String name;
    private final boolean custom;
    private final boolean protocol;

    static boolean isObjCProxy(Class<?> cls) {
        return (cls.getModifiers() & 0x1000) > 0 && cls.getName().endsWith(OBJC_PROXY_CLASS_SUFFIX);
    }

    private ObjCClass(long handle, Class<? extends ObjCObject> type, String name, boolean custom, boolean protocol) {
        super(handle, false);
        this.type = type;
        this.name = name;
        this.custom = custom;
        this.protocol = protocol;
    }

    public Class<? extends ObjCObject> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public boolean isProtocol() {
        return this.protocol;
    }

    public String toString() {
        return this.type.getName();
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@interface ").append(this.getName());
        long superclass = ObjCRuntime.class_getSuperclass(this.getHandle());
        if (superclass != 0L) {
            sb.append(" : ").append(VM.newStringUTF((long)ObjCRuntime.class_getName(superclass)));
        }
        IntPtr outCount = new IntPtr();
        long protocols = ObjCRuntime.class_copyProtocolList(this.getHandle(), outCount.getHandle());
        if (outCount.get() > 0) {
            sb.append(" <");
            for (int i = 0; i < outCount.get(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(VM.newStringUTF((long)ObjCRuntime.protocol_getName(VM.getPointer((long)protocols))));
                protocols += (long)(Bro.IS_64BIT ? 8 : 4);
            }
            sb.append('>');
        }
        sb.append('\n');
        sb.append("@end");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCClass getByName(String objcClassName) {
        Object object = objcBridgeLock;
        synchronized (object) {
            ObjCClass c = nameToClass.get(objcClassName);
            if (c == null && (c = ObjCClass.getByNameNotLoaded(objcClassName)) == null) {
                throw new ObjCClassNotFoundException("Could not find Java class corresponding to Objective-C class: " + objcClassName);
            }
            return c;
        }
    }

    private static ObjCClass getByNameNotLoaded(String objcClassName) {
        Class<? extends ObjCObject> cls = allNativeClasses.get(objcClassName);
        if (cls != null) {
            return ObjCClass.getByType(cls);
        }
        cls = allNativeProtocolProxies.get(objcClassName);
        if (cls != null) {
            return ObjCClass.getByType(cls);
        }
        cls = allCustomClasses.get(objcClassName);
        if (cls != null) {
            return ObjCClass.getByType(cls);
        }
        return null;
    }

    public static ObjCClass getFromObject(ObjCObject id) {
        long handle = id.getHandle();
        ObjCClass c = null;
        if (handle != 0L) {
            long classPtr = ObjCRuntime.object_getClass(handle);
            c = (ObjCClass)((Object)ObjCObject.getPeerObject(classPtr));
        }
        if (c != null) {
            return c;
        }
        return ObjCClass.getByType(((Object)((Object)id)).getClass());
    }

    public static ObjCClass getFromObject(long handle) {
        long classPtr = ObjCRuntime.object_getClass(handle);
        return ObjCClass.toObjCClass(classPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCClass getByType(Class<? extends ObjCObject> type) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        Object object = objcBridgeLock;
        synchronized (object) {
            ObjCClass c = typeToClass.get(type);
            if (c == null) {
                String name = null;
                NativeClass nativeClassAnno = type.getAnnotation(NativeClass.class);
                if (nativeClassAnno != null) {
                    name = nativeClassAnno.value();
                    name = "".equals(name) ? type.getSimpleName() : name;
                    long classPtr = ObjCRuntime.objc_getClass(VM.getStringUTFChars((String)name));
                    if (classPtr != 0L) {
                        c = new ObjCClass(classPtr, type, name, false, false);
                    }
                } else {
                    NativeProtocolProxy nativeProtocolProxyAnno = type.getAnnotation(NativeProtocolProxy.class);
                    if (nativeProtocolProxyAnno != null) {
                        name = nativeProtocolProxyAnno.value();
                        name = "".equals(name) ? type.getSimpleName() : name;
                        long protocolPtr = ObjCRuntime.objc_getProtocol(VM.getStringUTFChars((String)name));
                        if (protocolPtr != 0L) {
                            c = new ObjCClass(protocolPtr, type, name, false, true);
                        }
                    } else {
                        name = ObjCClass.getCustomClassName(type);
                        c = ObjCClass.register(type, name);
                    }
                }
                if (c == null) {
                    throw new ObjCClassNotFoundException(name);
                }
                typeToClass.put(type, c);
                nameToClass.put(name, c);
            }
            return c;
        }
    }

    private static List<String> getProtocols(long handle, boolean isProtocol) {
        long protocol;
        long protocols;
        long l = protocols = isProtocol ? ObjCRuntime.protocol_copyProtocolList(handle, 0L) : ObjCRuntime.class_copyProtocolList(handle, 0L);
        if (protocols == 0L) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> names = new ArrayList<String>();
        long protos = protocols;
        while (VM.getPointer((long)protos) != 0L) {
            protocol = VM.getPointer((long)protocols);
            names.add(VM.newStringUTF((long)ObjCRuntime.protocol_getName(protocol)));
            protos += Bro.IS_64BIT ? 8L : 4L;
        }
        protos = protocols;
        while (VM.getPointer((long)protos) != 0L) {
            protocol = VM.getPointer((long)protocols);
            names.addAll(ObjCClass.getProtocols(protocol, true));
            protos += Bro.IS_64BIT ? 8L : 4L;
        }
        VM.free((long)protocols);
        return names;
    }

    public static ObjCClass toObjCClass(long handle) {
        Class<? extends ObjCObject> cls;
        long classPtr = handle;
        ObjCClass c = (ObjCClass)((Object)ObjCObject.getPeerObject(classPtr));
        if (c == null) {
            c = ObjCClass.getByNameNotLoaded(VM.newStringUTF((long)ObjCRuntime.class_getName(classPtr)));
        }
        if (c == null) {
            for (String protocol : ObjCClass.getProtocols(classPtr, false)) {
                cls = allNativeProtocolProxies.get(protocol);
                if (cls == null) continue;
                c = ObjCClass.getByType(cls);
                break;
            }
        }
        block1: while (c == null && classPtr != 0L) {
            c = (ObjCClass)((Object)ObjCObject.getPeerObject(classPtr = ObjCRuntime.class_getSuperclass(classPtr)));
            if (c != null || (c = ObjCClass.getByNameNotLoaded(VM.newStringUTF((long)ObjCRuntime.class_getName(classPtr)))) != null) continue;
            for (String protocol : ObjCClass.getProtocols(classPtr, false)) {
                cls = allNativeProtocolProxies.get(protocol);
                if (cls == null) continue;
                c = ObjCClass.getByType(cls);
                continue block1;
            }
        }
        if (c == null) {
            String name = VM.newStringUTF((long)ObjCRuntime.class_getName(handle));
            throw new ObjCClassNotFoundException("Could not find Java class corresponding to Objective-C class: " + name);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjCClass registerCustomClass(Class<? extends ObjCObject> type) {
        if (type.getAnnotation(NativeClass.class) != null) {
            throw new IllegalArgumentException("@NativeClass annotated class " + type.getName() + " can not be registered as a custom class");
        }
        if (type.getAnnotation(NativeProtocolProxy.class) != null) {
            throw new IllegalArgumentException("@NativeProtocolProxy annotated class " + type.getName() + " can not be registered as a custom class");
        }
        Object object = objcBridgeLock;
        synchronized (object) {
            ObjCClass c = typeToClass.get(type);
            if (c == null) {
                String name = ObjCClass.getCustomClassName(type);
                c = ObjCClass.register(type, name);
                typeToClass.put(type, c);
                nameToClass.put(name, c);
            }
            return c;
        }
    }

    private static String getCustomClassName(Class<? extends ObjCObject> type) {
        CustomClass customClassAnno = type.getAnnotation(CustomClass.class);
        String name = type.getName();
        name = customClassAnno != null && customClassAnno.value().length() > 0 ? customClassAnno.value() : CUSTOM_CLASS_NAME_PREFIX + name;
        name = name.replace('.', '_');
        return name;
    }

    private static ObjCClass register(Class<? extends ObjCObject> type, String name) {
        ObjCClass superclass = ObjCClass.getByType(type.getSuperclass());
        long handle = ObjCRuntime.objc_allocateClassPair(superclass.getHandle(), VM.getStringUTFChars((String)name), 0L);
        if (handle == 0L) {
            throw new ObjCClassNotFoundException("Failed to create custom Objective-C class for Java class: " + type);
        }
        for (Map.Entry<String, Method> entry : ObjCClass.getCallbacks(type).entrySet()) {
            boolean isClassMethod;
            String selName = entry.getKey();
            Method method = entry.getValue();
            boolean bl = isClassMethod = method.getParameterTypes()[0] == ObjCClass.class;
            if (isClassMethod && method.getDeclaringClass() != type) continue;
            Selector selector = Selector.register(selName);
            String encoding = null;
            TypeEncoding typeEncoding = method.getAnnotation(TypeEncoding.class);
            if (typeEncoding != null) {
                encoding = typeEncoding.value();
            } else {
                long encodingPtr;
                long methodPtr;
                long l = methodPtr = isClassMethod ? ObjCRuntime.class_getClassMethod(superclass.getHandle(), selector.getHandle()) : ObjCRuntime.class_getInstanceMethod(superclass.getHandle(), selector.getHandle());
                if (methodPtr != 0L && (encodingPtr = ObjCRuntime.method_getTypeEncoding(methodPtr)) != 0L) {
                    encoding = VM.newStringUTF((long)encodingPtr);
                }
            }
            long impl = VM.getCallbackMethodImpl((Method)method);
            long ownerHandle = isClassMethod ? ObjCRuntime.object_getClass(handle) : handle;
            if (ObjCRuntime.class_addMethod(ownerHandle, selector.getHandle(), impl, encoding != null ? VM.getStringUTFChars((String)encoding) : 0L)) continue;
            throw new ObjCClassNotFoundException("Failed to add method " + selName + " to custom Objective-C class for Java class: " + type);
        }
        ObjCObject.ObjectOwnershipHelper.registerClass(handle);
        ObjCRuntime.objc_registerClassPair(handle);
        for (Class<? extends ObjCObject> cls = type; cls != null && cls != ObjCObject.class; cls = cls.getSuperclass()) {
            Class<?>[] interfaces;
            for (Class<?> inf : interfaces = cls.getInterfaces()) {
                String protocolName;
                long protocolPtr;
                if (inf == ObjCProtocol.class || !ObjCProtocol.class.isAssignableFrom(inf) || (protocolPtr = ObjCRuntime.objc_getProtocol(VM.getStringUTFChars((String)(protocolName = inf.getSimpleName())))) == 0L) continue;
                ObjCRuntime.class_addProtocol(handle, protocolPtr);
            }
        }
        return new ObjCClass(handle, type, name, !ObjCClass.isObjCProxy(type), false);
    }

    private static Map<String, Method> getCallbacks(Class<?> type) {
        HashMap<String, Method> callbacks = new HashMap<String, Method>();
        ObjCClass.findCallbacks(type, callbacks);
        return callbacks;
    }

    private static void findCallbacks(Class<?> type, Map<String, Method> result) {
        for (Method m : type.getDeclaredMethods()) {
            BindSelector bindSelector;
            if (m.getAnnotation(Callback.class) == null || (bindSelector = m.getAnnotation(BindSelector.class)) == null || result.containsKey(bindSelector.value())) continue;
            result.put(bindSelector.value(), m);
        }
    }

    static {
        Class[] classes;
        OBJC_PROXY_CLASS_SUFFIX_LENGTH = OBJC_PROXY_CLASS_SUFFIX.length();
        typeToClass = new HashMap<Class<? extends ObjCObject>, ObjCClass>();
        nameToClass = new HashMap<String, ObjCClass>();
        allNativeClasses = new HashMap<String, Class<? extends ObjCObject>>();
        allNativeProtocolProxies = new HashMap<String, Class<? extends ObjCObject>>();
        allCustomClasses = new HashMap<String, Class<? extends ObjCObject>>();
        allObjCProxyClasses = new HashMap<String, Class<? extends ObjCObject>>();
        ObjCRuntime.bind(ObjCClass.class);
        for (Class cls : classes = VM.listClasses(ObjCObject.class, (ClassLoader)ClassLoader.getSystemClassLoader())) {
            String name;
            NativeClass nativeClassAnno = cls.getAnnotation(NativeClass.class);
            if (nativeClassAnno != null) {
                name = nativeClassAnno.value();
                if (name.length() == 0) {
                    name = cls.getSimpleName();
                }
                allNativeClasses.put(name, cls);
            } else {
                NativeProtocolProxy nativeProtocolProxyAnno = cls.getAnnotation(NativeProtocolProxy.class);
                if (nativeProtocolProxyAnno != null) {
                    String name2 = nativeProtocolProxyAnno.value();
                    if (name2.length() == 0) {
                        name2 = cls.getSimpleName();
                    }
                    allNativeProtocolProxies.put(name2, cls);
                } else {
                    CustomClass customClassAnno = cls.getAnnotation(CustomClass.class);
                    String name3 = cls.getName();
                    if (customClassAnno != null) {
                        String value = customClassAnno.value();
                        if (value.length() > 0) {
                            name3 = value;
                        }
                    } else if (name3.indexOf(46) == -1) {
                        name3 = "." + name3;
                    }
                    allCustomClasses.put(name3, cls);
                }
            }
            if (!ObjCClass.isObjCProxy(cls)) continue;
            name = cls.getName();
            String protocolName = name.substring(0, name.length() - OBJC_PROXY_CLASS_SUFFIX_LENGTH);
            allObjCProxyClasses.put(protocolName, cls);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static Class<? extends ObjCObject> toObject(Class<ObjCClass> cls, long handle, long flags) {
            ObjCClass o = ObjCClass.toObjCClass(handle);
            if (o == null) {
                return null;
            }
            return o.getType();
        }

        @MarshalsPointer
        public static long toNative(Class<? extends ObjCObject> o, long flags) {
            if (o == null) {
                return 0L;
            }
            ObjCClass c = ObjCClass.getByType(o);
            return c.getHandle();
        }
    }
}

