/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.objc;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robovm.objc.LongMap;
import org.robovm.objc.ObjCClass;
import org.robovm.objc.ObjCProtocol;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.ObjCSuper;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.VM;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshalers;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="Foundation")
@NativeClass(value="Object")
@Marshalers(value={@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class), @org.robovm.rt.bro.annotation.Marshaler(value=ObjCClass.Marshaler.class)})
public abstract class ObjCObject
extends NativeObject {
    private static volatile boolean logRetainRelease = false;
    static final Object objcBridgeLock;
    private static final LongMap<ObjCObjectRef> peers;
    private static final long CUSTOM_CLASS_OFFSET;
    private static final long NS_OBJECT_CLASS;
    private ObjCSuper zuper;
    protected final boolean customClass;

    protected ObjCObject() {
        long handle = this.alloc();
        this.setHandle(handle);
        if (handle != 0L) {
            ObjCObject.setPeerObject(handle, this);
        }
        this.customClass = this.getObjCClass().isCustom();
    }

    protected ObjCObject(long handle) {
        this.initObject(handle);
        this.customClass = this.getObjCClass().isCustom();
    }

    ObjCObject(long handle, boolean customClass) {
        this.initObject(handle);
        this.customClass = customClass;
    }

    protected void initObject(long handle) {
        if (handle == 0L) {
            throw new RuntimeException("Objective-C initialization method returned nil");
        }
        long oldHandle = this.getHandle();
        if (handle != oldHandle) {
            if (oldHandle != 0L) {
                ObjCObject.removePeerObject(this);
            }
            this.setHandle(handle);
            ObjCObject.setPeerObject(handle, this);
        }
    }

    protected long alloc() {
        throw new UnsupportedOperationException("Cannot create instances of " + ((Object)((Object)this)).getClass().getName());
    }

    protected final void finalize() throws Throwable {
        this.dispose(true);
    }

    public final void dispose() {
        this.dispose(false);
    }

    protected void doDispose() {
    }

    protected void dispose(boolean finalizing) {
        long handle = this.getHandle();
        if (handle != 0L) {
            ObjCObject.removePeerObject(this);
            this.doDispose();
            this.setHandle(0L);
        }
        if (finalizing) {
            try {
                super.finalize();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ObjCSuper getSuper() {
        if (this.zuper == null) {
            Class<?> javaClass = ((Object)((Object)this)).getClass().getSuperclass();
            ObjCClass objCClass = ObjCClass.getByType(javaClass);
            while (objCClass.isCustom()) {
                javaClass = javaClass.getSuperclass();
                objCClass = ObjCClass.getByType(javaClass);
            }
            this.zuper = new ObjCSuper(this, objCClass);
        }
        return this.zuper;
    }

    protected void afterMarshaled(int flags) {
    }

    public final ObjCClass getObjCClass() {
        return ObjCClass.getFromObject(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T extends ObjCObject> T getPeerObject(long handle) {
        Object object = objcBridgeLock;
        synchronized (object) {
            ObjCObjectRef ref = peers.get(handle);
            ObjCObject o = ref != null ? (ObjCObject)((Object)ref.get()) : null;
            return (T)((Object)o);
        }
    }

    protected static void retainCustomObjectFromCb(long handle) {
        ObjectOwnershipHelper.retainObject(handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setPeerObject(long handle, ObjCObject o) {
        Object object = objcBridgeLock;
        synchronized (object) {
            if (o == null) {
                peers.remove(handle);
            } else {
                peers.put(handle, new ObjCObjectRef(o));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removePeerObject(ObjCObject o) {
        Object object = objcBridgeLock;
        synchronized (object) {
            ObjCObject p;
            long handle = o.getHandle();
            ObjCObjectRef ref = peers.remove(handle);
            ObjCObject objCObject = p = ref != null ? (ObjCObject)((Object)ref.get()) : null;
            if (p != null && o != p) {
                peers.put(handle, new ObjCObjectRef(p));
            }
        }
    }

    public <T> T addStrongRef(T to) {
        AssociatedObjectHelper.addStrongRef(this, to);
        return to;
    }

    public void removeStrongRef(Object to) {
        AssociatedObjectHelper.removeStrongRef(this, to, false);
    }

    public void updateStrongRef(Object before, Object after) {
        if (before == after) {
            return;
        }
        if (before != null) {
            AssociatedObjectHelper.removeStrongRef(this, before, true);
        }
        if (after != null) {
            AssociatedObjectHelper.addStrongRef(this, after);
        }
    }

    public Object getAssociatedObject(Object key) {
        return AssociatedObjectHelper.getAssociatedObject(this, key);
    }

    public void setAssociatedObject(Object key, Object value) {
        AssociatedObjectHelper.setAssociatedObject(this, key, value);
    }

    public static <T extends ObjCObject> T toObjCObject(Class<T> cls, long handle, int afterMarshaledFlags) {
        return ObjCObject.toObjCObject(cls, handle, afterMarshaledFlags, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends ObjCObject> T toObjCObject(Class<T> cls, long handle, int afterMarshaledFlags, boolean forceType) {
        if (handle == 0L) {
            return null;
        }
        if (cls == ObjCClass.class) {
            return (T)((Object)ObjCClass.toObjCClass(handle));
        }
        if (forceType) {
            return ObjCObject.createInstance(ObjCClass.getByType(cls), handle, afterMarshaledFlags, false);
        }
        Class<Object> expectedType = cls;
        if (ObjCClass.isObjCProxy(cls)) {
            expectedType = cls.getInterfaces()[0];
        }
        Object object = objcBridgeLock;
        synchronized (object) {
            ObjCClass objCClass;
            T o = ObjCObject.getPeerObject(handle);
            if (o != null && o.getHandle() != 0L) {
                if (expectedType.isAssignableFrom(o.getClass())) {
                    return o;
                }
                if (ObjCClass.isObjCProxy(o.getClass())) {
                    ObjCObject.removePeerObject(o);
                    o = null;
                } else {
                    if (ObjCClass.isObjCProxy(cls)) {
                        return ObjCObject.createInstance(ObjCClass.getByType(cls), handle, afterMarshaledFlags, false);
                    }
                    throw new IllegalStateException("The peer object type " + o.getClass().getName() + " is not compatible with the expected type " + expectedType.getName());
                }
            }
            if (!expectedType.isAssignableFrom((objCClass = ObjCClass.getFromObject(handle)).getType())) {
                objCClass = ObjCClass.getByType(cls);
            }
            return ObjCObject.createInstance(objCClass, handle, afterMarshaledFlags, true);
        }
    }

    private static <T extends ObjCObject> T createInstance(ObjCClass objCClass, long handle, int afterMarshaledFlags, boolean makePeer) {
        Class<? extends ObjCObject> c = objCClass.getType();
        ObjCObject o = (ObjCObject)((Object)VM.allocateObject(c));
        o.setHandle(handle);
        if (makePeer) {
            ObjCObject.setPeerObject(handle, o);
        }
        if (objCClass.isCustom()) {
            VM.setBoolean((long)(VM.getObjectAddress((Object)((Object)o)) + CUSTOM_CLASS_OFFSET), (boolean)true);
        }
        o.afterMarshaled(afterMarshaledFlags);
        return (T)((Object)o);
    }

    public static void logRetainRelease(boolean enabled) {
        logRetainRelease = enabled;
    }

    private static void logRetainRelease(long cls, long self, int count, boolean isRetain) {
        String className = ObjCClass.getFromObject(cls).getType().getName();
        System.err.println(String.format("[Debug] %s %s@0x%s, retain count: %d", isRetain ? "Retained" : "Released", className, Long.toHexString(self), isRetain ? count + 1 : count - 1));
    }

    static {
        ObjCRuntime.bind(ObjCObject.class);
        try {
            Field f = ObjCObject.class.getDeclaredField("customClass");
            CUSTOM_CLASS_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)f));
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        NS_OBJECT_CLASS = ObjCRuntime.objc_getClass(VM.getStringUTFChars((String)"NSObject"));
        objcBridgeLock = new Object();
        peers = new LongMap();
    }

    public static final class Super
    extends Struct<Super> {
        public Super(long receiver, long objcClass) {
            this.receiver(receiver);
            this.objCClass(objcClass);
        }

        @StructMember(value=0)
        @Pointer
        public native long receiver();

        @StructMember(value=0)
        public native Super receiver(@Pointer long var1);

        @StructMember(value=1)
        @Pointer
        public native long objCClass();

        @StructMember(value=1)
        public native Super objCClass(@Pointer long var1);
    }

    static class AssociatedObjectHelper {
        private static final String STRONG_REFS_KEY = AssociatedObjectHelper.class.getName() + ".StrongRefs";
        private static final int OBJC_ASSOCIATION_RETAIN_NONATOMIC = 1;
        private static final long RELEASE_LISTENER_CLASS;
        private static final String OWNER_IVAR_NAME = "value";
        private static final int OWNER_IVAR_OFFSET;
        private static final Selector alloc;
        private static final Selector init;
        private static final Selector release;
        private static final Selector retainCount;
        private static final LongMap<Map<Object, Object>> ASSOCIATED_OBJECTS;

        AssociatedObjectHelper() {
        }

        private static void enableListener(long handle) {
            long releaseListener = ObjCRuntime.objc_getAssociatedObject(handle, RELEASE_LISTENER_CLASS);
            if (releaseListener == 0L) {
                releaseListener = ObjCRuntime.ptr_objc_msgSend(RELEASE_LISTENER_CLASS, alloc.getHandle());
                if (releaseListener == 0L) {
                    throw new OutOfMemoryError();
                }
                releaseListener = ObjCRuntime.ptr_objc_msgSend(releaseListener, init.getHandle());
                VM.setPointer((long)(releaseListener + (long)OWNER_IVAR_OFFSET), (long)handle);
                ObjCRuntime.objc_setAssociatedObject(handle, RELEASE_LISTENER_CLASS, releaseListener, 1);
                ObjCRuntime.void_objc_msgSend(releaseListener, release.getHandle());
            }
        }

        private static void disableListener(long handle) {
            ObjCRuntime.objc_setAssociatedObject(handle, RELEASE_LISTENER_CLASS, 0L, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Object getAssociatedObject(ObjCObject object, Object key) {
            LongMap<Map<Object, Object>> longMap = ASSOCIATED_OBJECTS;
            synchronized (longMap) {
                Map<Object, Object> map = ASSOCIATED_OBJECTS.get(object.getHandle());
                if (map == null) {
                    return null;
                }
                return map.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setAssociatedObject(ObjCObject object, Object key, Object value) {
            LongMap<Map<Object, Object>> longMap = ASSOCIATED_OBJECTS;
            synchronized (longMap) {
                Map<Object, Object> map = ASSOCIATED_OBJECTS.get(object.getHandle());
                if (map == null && value == null) {
                    return;
                }
                if (map == null) {
                    map = new HashMap<Object, Object>();
                    AssociatedObjectHelper.enableListener(object.getHandle());
                    ASSOCIATED_OBJECTS.put(object.getHandle(), map);
                }
                if (value != null) {
                    map.put(key, value);
                } else {
                    map.remove(key);
                    if (map.isEmpty()) {
                        AssociatedObjectHelper.disableListener(object.getHandle());
                        ASSOCIATED_OBJECTS.remove(object.getHandle());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void addStrongRef(ObjCObject from, Object to) {
            if (to == null) {
                throw new NullPointerException();
            }
            LongMap<Map<Object, Object>> longMap = ASSOCIATED_OBJECTS;
            synchronized (longMap) {
                ArrayList<Object> l = (ArrayList<Object>)AssociatedObjectHelper.getAssociatedObject(from, STRONG_REFS_KEY);
                if (l == null) {
                    l = new ArrayList<Object>();
                    AssociatedObjectHelper.setAssociatedObject(from, STRONG_REFS_KEY, l);
                }
                l.add(to);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void removeStrongRef(ObjCObject from, Object to, boolean ignoreNotExists) {
            if (to == null) {
                throw new NullPointerException();
            }
            LongMap<Map<Object, Object>> longMap = ASSOCIATED_OBJECTS;
            synchronized (longMap) {
                List l = (List)AssociatedObjectHelper.getAssociatedObject(from, STRONG_REFS_KEY);
                if (!(ignoreNotExists || l != null && l.remove(to))) {
                    throw new IllegalArgumentException("No strong ref exists from " + (Object)((Object)from) + " (a " + ((Object)((Object)from)).getClass().getName() + ") to " + to + " a (" + to.getClass().getName() + ")");
                }
                if (l != null && l.isEmpty()) {
                    AssociatedObjectHelper.setAssociatedObject(from, STRONG_REFS_KEY, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Callback
        static void release(@Pointer long self, @Pointer long sel) {
            int count = ObjCRuntime.int_objc_msgSend(self, retainCount.getHandle());
            if (count == 1) {
                long owner = VM.getPointer((long)(self + (long)OWNER_IVAR_OFFSET));
                LongMap<Map<Object, Object>> longMap = ASSOCIATED_OBJECTS;
                synchronized (longMap) {
                    ASSOCIATED_OBJECTS.remove(owner);
                }
            }
            if (logRetainRelease) {
                long cls = ObjCRuntime.object_getClass(self);
                ObjCObject.logRetainRelease(cls, self, count, false);
            }
            ObjCRuntime.void_objc_msgSendSuper(new Super(self, NS_OBJECT_CLASS).getHandle(), sel);
        }

        static {
            alloc = Selector.register("alloc");
            init = Selector.register("init");
            release = Selector.register("release");
            retainCount = Selector.register("retainCount");
            ASSOCIATED_OBJECTS = new LongMap();
            int ptrSize = VoidPtr.sizeOf();
            int alignment = ptrSize == 4 ? 2 : 3;
            long cls = ObjCRuntime.objc_allocateClassPair(NS_OBJECT_CLASS, VM.getStringUTFChars((String)"RoboVMReleaseListener"), ptrSize);
            if (cls == 0L) {
                throw new Error("Failed to create the RoboVMReleaseListener Objective-C class: objc_allocateClassPair(...) failed");
            }
            if (!ObjCRuntime.class_addIvar(cls, VM.getStringUTFChars((String)OWNER_IVAR_NAME), ptrSize, (byte)alignment, VM.getStringUTFChars((String)"?"))) {
                throw new Error("Failed to create the RoboVMAssocObjWrapper Objective-C class: class_addIvar(...) failed");
            }
            Method releaseMethod = null;
            try {
                releaseMethod = AssociatedObjectHelper.class.getDeclaredMethod("release", Long.TYPE, Long.TYPE);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
            long superReleaseMethod = ObjCRuntime.class_getInstanceMethod(NS_OBJECT_CLASS, release.getHandle());
            long releaseType = ObjCRuntime.method_getTypeEncoding(superReleaseMethod);
            if (!ObjCRuntime.class_addMethod(cls, release.getHandle(), VM.getCallbackMethodImpl((Method)releaseMethod), releaseType)) {
                throw new Error("Failed to create the RoboVMReleaseListener Objective-C class: class_addMethod(...) failed");
            }
            ObjCRuntime.objc_registerClassPair(cls);
            RELEASE_LISTENER_CLASS = cls;
            OWNER_IVAR_OFFSET = ObjCRuntime.ivar_getOffset(ObjCRuntime.class_getInstanceVariable(cls, VM.getStringUTFChars((String)OWNER_IVAR_NAME)));
        }
    }

    static class ObjectOwnershipHelper {
        private static final LongMap<Object> CUSTOM_OBJECTS = new LongMap();
        private static final long retainCount = Selector.register("retainCount").getHandle();
        private static final long retain = Selector.register("retain").getHandle();
        private static final long originalRetain = Selector.register("original_retain").getHandle();
        private static final long release = Selector.register("release").getHandle();
        private static final long originalRelease = Selector.register("original_release").getHandle();
        private static final long dealloc = Selector.register("dealloc").getHandle();
        private static final Method retainMethod;
        private static final Method releaseMethod;
        private static final Method deallocMethod;
        private static final LongMap<Long> customClassToNativeSuper;
        private static final Long ZERO_LONG;

        ObjectOwnershipHelper() {
        }

        public static void registerClass(long cls) {
            ObjectOwnershipHelper.registerCallbackMethod(cls, retain, originalRetain, retainMethod);
            ObjectOwnershipHelper.registerCallbackMethod(cls, release, originalRelease, releaseMethod);
            ObjectOwnershipHelper.registerCallbackMethod(cls, dealloc, 0L, deallocMethod);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void registerCallbackMethod(long cls, long selector, long newSelector, Method method) {
            long superMethod = ObjCRuntime.class_getInstanceMethod(cls, selector);
            long typeEncoding = ObjCRuntime.method_getTypeEncoding(superMethod);
            if (!ObjCRuntime.class_addMethod(cls, selector, VM.getCallbackMethodImpl((Method)method), typeEncoding)) {
                throw new Error("Failed to register callback method on the ObjectOwnershipHelper: class_addMethod(...) failed");
            }
            long superClass = ObjCRuntime.class_getSuperclass(cls);
            long nativeSuper = 0L;
            while (superClass != 0L) {
                ObjCClass objCClass = ObjCClass.toObjCClass(superClass);
                if (!objCClass.isCustom()) {
                    nativeSuper = superClass;
                    break;
                }
                superClass = ObjCRuntime.class_getSuperclass(superClass);
            }
            if (nativeSuper == 0L) {
                throw new Error("Couldn't find native super class for " + VM.newStringUTF((long)ObjCRuntime.class_getName(cls)));
            }
            LongMap<Long> longMap = customClassToNativeSuper;
            synchronized (longMap) {
                customClassToNativeSuper.put(cls, nativeSuper);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void retainObject(long self) {
            LongMap<Object> longMap = CUSTOM_OBJECTS;
            synchronized (longMap) {
                Object obj = ObjCObject.getPeerObject(self);
                CUSTOM_OBJECTS.put(self, obj);
            }
        }

        @Callback
        @Pointer
        private static long retain(@Pointer long self, @Pointer long sel) {
            ObjectOwnershipHelper.retainObject(self);
            int count = ObjCRuntime.int_objc_msgSend(self, retainCount);
            long cls = ObjCRuntime.object_getClass(self);
            if (logRetainRelease) {
                ObjCObject.logRetainRelease(cls, self, count, true);
            }
            Super sup = new Super(self, ObjectOwnershipHelper.getNativeSuper(cls));
            return ObjCRuntime.ptr_objc_msgSendSuper(sup.getHandle(), sel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Callback
        private static void release(@Pointer long self, @Pointer long sel) {
            int count = ObjCRuntime.int_objc_msgSend(self, retainCount);
            if (count <= 2) {
                LongMap<Object> longMap = CUSTOM_OBJECTS;
                synchronized (longMap) {
                    CUSTOM_OBJECTS.remove(self);
                }
            }
            long cls = ObjCRuntime.object_getClass(self);
            if (logRetainRelease) {
                ObjCObject.logRetainRelease(cls, self, count, false);
            }
            Super sup = new Super(self, ObjectOwnershipHelper.getNativeSuper(cls));
            ObjCRuntime.void_objc_msgSendSuper(sup.getHandle(), sel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Callback
        private static void dealloc(@Pointer long self, @Pointer long sel) {
            long cls = ObjCRuntime.object_getClass(self);
            Super sup = new Super(self, ObjectOwnershipHelper.getNativeSuper(cls));
            ObjCRuntime.void_objc_msgSendSuper(sup.getHandle(), sel);
            LongMap<Object> longMap = CUSTOM_OBJECTS;
            synchronized (longMap) {
                CUSTOM_OBJECTS.remove(self);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean isObjectRetained(ObjCObject object) {
            LongMap<Object> longMap = CUSTOM_OBJECTS;
            synchronized (longMap) {
                return CUSTOM_OBJECTS.containsKey(object.getHandle());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static long getNativeSuper(long cls) {
            long c = cls;
            LongMap<Long> longMap = customClassToNativeSuper;
            synchronized (longMap) {
                while (c != 0L) {
                    long nativeSuper = customClassToNativeSuper.get(c, ZERO_LONG);
                    if (nativeSuper != 0L) {
                        return nativeSuper;
                    }
                    c = ObjCRuntime.class_getSuperclass(c);
                }
            }
            ArrayList<String> classHierarchy = new ArrayList<String>();
            c = cls;
            while (c != 0L) {
                classHierarchy.add(VM.newStringUTF((long)ObjCRuntime.class_getName(c)));
                c = ObjCRuntime.class_getSuperclass(c);
            }
            throw new Error("Failed to find a custom class to native super class mapping for class hierarchy " + classHierarchy);
        }

        static {
            customClassToNativeSuper = new LongMap();
            ZERO_LONG = 0L;
            try {
                retainMethod = ObjectOwnershipHelper.class.getDeclaredMethod("retain", Long.TYPE, Long.TYPE);
                releaseMethod = ObjectOwnershipHelper.class.getDeclaredMethod("release", Long.TYPE, Long.TYPE);
                deallocMethod = ObjectOwnershipHelper.class.getDeclaredMethod("dealloc", Long.TYPE, Long.TYPE);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }
    }

    static class ObjCObjectRef
    extends WeakReference<ObjCObject> {
        public final long handle;

        public ObjCObjectRef(ObjCObject referent) {
            super(referent);
            this.handle = referent.getHandle();
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static ObjCObject toObject(Class<? extends ObjCObject> cls, long handle, long flags) {
            ObjCObject o = ObjCObject.toObjCObject(cls, handle, 0);
            return o;
        }

        @MarshalsPointer
        public static long toNative(ObjCObject o, long flags) {
            if (o == null) {
                return 0L;
            }
            return o.getHandle();
        }

        @MarshalsPointer
        public static ObjCProtocol protocolToObject(Class<?> cls, long handle, long flags) {
            Class<? extends ObjCObject> proxyClass = ObjCClass.allObjCProxyClasses.get(cls.getName());
            if (proxyClass == null) {
                proxyClass = ObjCObject.class;
            }
            ObjCObject o = ObjCObject.toObjCObject(proxyClass, handle, 0);
            return (ObjCProtocol)((Object)o);
        }

        @MarshalsPointer
        public static long protocolToNative(ObjCProtocol o, long flags) {
            if (o == null) {
                return 0L;
            }
            return ((ObjCObject)((Object)o)).getHandle();
        }
    }

    public static class ObjCObjectPtr
    extends Ptr<ObjCObject, ObjCObjectPtr> {
    }
}

