/*
 * Decompiled with CFR 0.152.
 */
package SQLite.JDBC2z;

import SQLite.Database;
import SQLite.Exception;
import SQLite.JDBC2z.JDBCConnection;
import SQLite.JDBC2z.JDBCResultSet;
import SQLite.JDBC2z.JDBCStatement;
import SQLite.JDBC2z.TableResultX;
import SQLite.Shell;
import SQLite.TableResult;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.Hashtable;

public class JDBCDatabaseMetaData
implements DatabaseMetaData {
    private JDBCConnection conn;

    public JDBCDatabaseMetaData(JDBCConnection conn) {
        this.conn = conn;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.conn.url;
    }

    @Override
    public String getUserName() throws SQLException {
        return "";
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "SQLite";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return Database.version();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "SQLite/JDBC";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "1.20100131";
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 20100131;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return true;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return "SELECT,UPDATE,CREATE,TABLE,VIEW,DELETE,FROM,WHERE,COMMIT,ROLLBACK,TRIGGER";
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 8;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 8;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 8;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        JDBCStatement s = new JDBCStatement(this.conn);
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT '' AS 'TABLE_CAT', '' AS 'TABLE_SCHEM', tbl_name AS 'TABLE_NAME', upper(type) AS 'TABLE_TYPE', '' AS REMARKS FROM sqlite_master WHERE tbl_name like ");
        if (tableNamePattern != null) {
            sb.append(Shell.sql_quote(tableNamePattern));
        } else {
            sb.append("'%'");
        }
        sb.append(" AND ");
        if (types == null || types.length == 0) {
            sb.append("(type = 'table' or type = 'view')");
        } else {
            sb.append("(");
            String sep = "";
            for (int i = 0; i < types.length; ++i) {
                sb.append(sep);
                sb.append("type = ");
                sb.append(Shell.sql_quote(types[i].toLowerCase()));
                sep = " or ";
            }
            sb.append(")");
        }
        ResultSet rs = null;
        try {
            rs = s.executeQuery(sb.toString());
            s.close();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            s.close();
        }
        return rs;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        String[] cols = new String[]{"TABLE_SCHEM"};
        TableResult tr = new TableResult();
        tr.columns(cols);
        String[] row = new String[]{""};
        tr.newrow(row);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        return rs;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        String[] cols = new String[]{"TABLE_CAT"};
        TableResult tr = new TableResult();
        tr.columns(cols);
        String[] row = new String[]{""};
        tr.newrow(row);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        return rs;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        String[] cols = new String[]{"TABLE_TYPE"};
        TableResult tr = new TableResult();
        tr.columns(cols);
        String[] row = new String[]{"TABLE"};
        tr.newrow(row);
        row = new String[]{"VIEW"};
        tr.newrow(row);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        return rs;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.conn.db == null) {
            throw new SQLException("connection closed.");
        }
        JDBCResultSet rs0 = null;
        try (JDBCStatement s = new JDBCStatement(this.conn);){
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception se) {
                throw new SQLException("schema reload failed");
            }
            rs0 = (JDBCResultSet)s.executeQuery("PRAGMA table_info(" + Shell.sql_quote(tableNamePattern) + ")");
            s.close();
        }
        if (rs0.tr.nrows < 1) {
            throw new SQLException("no such table: " + tableNamePattern);
        }
        String[] cols = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"};
        int[] types = new int[]{12, 12, 12, 12, 5, 12, 4, 4, 4, 4, 4, 12, 12, 4, 4, 4, 4, 12};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        if (rs0 != null && rs0.tr != null && rs0.tr.nrows > 0) {
            int i;
            Hashtable<String, Integer> h = new Hashtable<String, Integer>();
            for (i = 0; i < rs0.tr.ncolumns; ++i) {
                h.put(rs0.tr.column[i], i);
            }
            if (columnNamePattern != null && columnNamePattern.charAt(0) == '%') {
                columnNamePattern = null;
            }
            for (i = 0; i < rs0.tr.nrows; ++i) {
                String[] r0 = (String[])rs0.tr.rows.elementAt(i);
                int col = (Integer)h.get("name");
                if (columnNamePattern != null && r0[col].compareTo(columnNamePattern) != 0) continue;
                String[] row = new String[cols.length];
                row[0] = "";
                row[1] = "";
                row[2] = tableNamePattern;
                row[3] = r0[col];
                col = (Integer)h.get("type");
                String typeStr = r0[col];
                int type = JDBCDatabaseMetaData.mapSqlType(typeStr);
                row[4] = "" + type;
                row[5] = JDBCDatabaseMetaData.mapTypeName(type);
                row[6] = "" + JDBCDatabaseMetaData.getD(typeStr, type);
                row[7] = "" + JDBCDatabaseMetaData.getM(typeStr, type);
                row[8] = "10";
                row[9] = "0";
                row[11] = null;
                col = (Integer)h.get("dflt_value");
                row[12] = r0[col];
                row[13] = "0";
                row[14] = "0";
                row[15] = "65536";
                col = (Integer)h.get("cid");
                row[16] = Integer.toString(Integer.parseInt(r0[col]) + 1);
                col = (Integer)h.get("notnull");
                row[17] = r0[col].charAt(0) == '0' ? "YES" : "NO";
                row[10] = r0[col].charAt(0) == '0' ? "1" : "0";
                tr.newrow(row);
            }
        }
        return rs;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        String[] cols = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] types = new int[]{12, 12, 12, 12, 12, 12, 12, 12};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        return rs;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String[] cols = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"};
        int[] types = new int[]{12, 12, 12, 12, 12, 12, 12, 12};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        JDBCStatement s0 = new JDBCStatement(this.conn);
        JDBCResultSet rs0 = null;
        JDBCStatement s1 = new JDBCStatement(this.conn);
        JDBCResultSet rs1 = null;
        try {
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception se) {
                throw new SQLException("schema reload failed");
            }
            rs0 = (JDBCResultSet)s0.executeQuery("PRAGMA index_list(" + Shell.sql_quote(table) + ")");
            rs1 = (JDBCResultSet)s1.executeQuery("PRAGMA table_info(" + Shell.sql_quote(table) + ")");
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            s0.close();
            s1.close();
        }
        String[] cols = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] types = new int[]{5, 12, 5, 12, 4, 4, 5, 5};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        if (rs0 != null && rs0.tr != null && rs0.tr.nrows > 0 && rs1 != null && rs1.tr != null && rs1.tr.nrows > 0) {
            int i;
            Hashtable<String, Integer> h0 = new Hashtable<String, Integer>();
            for (int i2 = 0; i2 < rs0.tr.ncolumns; ++i2) {
                h0.put(rs0.tr.column[i2], i2);
            }
            Hashtable<String, Integer> h1 = new Hashtable<String, Integer>();
            for (i = 0; i < rs1.tr.ncolumns; ++i) {
                h1.put(rs1.tr.column[i], i);
            }
            for (i = 0; i < rs0.tr.nrows; ++i) {
                int k;
                String[] r0 = (String[])rs0.tr.rows.elementAt(i);
                int col = (Integer)h0.get("unique");
                String uniq = r0[col];
                col = (Integer)h0.get("name");
                String iname = r0[col];
                if (uniq.charAt(0) == '0') continue;
                JDBCResultSet rs2 = null;
                try (JDBCStatement s2 = new JDBCStatement(this.conn);){
                    rs2 = (JDBCResultSet)s2.executeQuery("PRAGMA index_info(" + Shell.sql_quote(iname) + ")");
                }
                if (rs2 == null || rs2.tr == null || rs2.tr.nrows <= 0) continue;
                Hashtable<String, Integer> h2 = new Hashtable<String, Integer>();
                for (k = 0; k < rs2.tr.ncolumns; ++k) {
                    h2.put(rs2.tr.column[k], k);
                }
                for (k = 0; k < rs2.tr.nrows; ++k) {
                    String[] r2 = (String[])rs2.tr.rows.elementAt(k);
                    col = (Integer)h2.get("name");
                    String cname = r2[col];
                    for (int m = 0; m < rs1.tr.nrows; ++m) {
                        String[] r1 = (String[])rs1.tr.rows.elementAt(m);
                        if (cname.compareTo(r1[col = ((Integer)h1.get("name")).intValue()]) != 0) continue;
                        String[] row = new String[cols.length];
                        row[0] = "" + scope;
                        row[1] = cname;
                        row[2] = "12";
                        row[3] = "VARCHAR";
                        row[4] = "65536";
                        row[5] = "0";
                        row[6] = "0";
                        row[7] = "1";
                        tr.newrow(row);
                    }
                }
            }
        }
        if (tr.nrows <= 0) {
            String[] row = new String[cols.length];
            row[0] = "" + scope;
            row[1] = "_ROWID_";
            row[2] = "4";
            row[3] = "INTEGER";
            row[4] = "10";
            row[5] = "0";
            row[6] = "0";
            row[7] = "2";
            tr.newrow(row);
        }
        return rs;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        String[] cols = new String[]{"SCOPE", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "PSEUDO_COLUMN"};
        int[] types = new int[]{5, 12, 5, 12, 4, 4, 5, 5};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        JDBCResultSet rs0 = null;
        try (JDBCStatement s0 = new JDBCStatement(this.conn);){
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception se) {
                throw new SQLException("schema reload failed");
            }
            rs0 = (JDBCResultSet)s0.executeQuery("PRAGMA index_list(" + Shell.sql_quote(table) + ")");
        }
        String[] cols = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"};
        int[] types = new int[]{12, 12, 12, 12, 5, 12};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        if (rs0 != null && rs0.tr != null && rs0.tr.nrows > 0) {
            int i;
            Hashtable<String, Integer> h0 = new Hashtable<String, Integer>();
            for (i = 0; i < rs0.tr.ncolumns; ++i) {
                h0.put(rs0.tr.column[i], i);
            }
            for (i = 0; i < rs0.tr.nrows; ++i) {
                int k;
                String[] r0 = (String[])rs0.tr.rows.elementAt(i);
                int col = (Integer)h0.get("unique");
                String uniq = r0[col];
                col = (Integer)h0.get("name");
                String iname = r0[col];
                if (uniq.charAt(0) == '0') continue;
                JDBCResultSet rs1 = null;
                try (JDBCStatement s1 = new JDBCStatement(this.conn);){
                    rs1 = (JDBCResultSet)s1.executeQuery("PRAGMA index_info(" + Shell.sql_quote(iname) + ")");
                }
                if (rs1 == null || rs1.tr == null || rs1.tr.nrows <= 0) continue;
                Hashtable<String, Integer> h1 = new Hashtable<String, Integer>();
                for (k = 0; k < rs1.tr.ncolumns; ++k) {
                    h1.put(rs1.tr.column[k], k);
                }
                for (k = 0; k < rs1.tr.nrows; ++k) {
                    String[] r1 = (String[])rs1.tr.rows.elementAt(k);
                    String[] row = new String[cols.length];
                    row[0] = "";
                    row[1] = "";
                    row[2] = table;
                    col = (Integer)h1.get("name");
                    row[3] = r1[col];
                    col = (Integer)h1.get("seqno");
                    row[4] = Integer.toString(Integer.parseInt(r1[col]) + 1);
                    row[5] = iname;
                    tr.newrow(row);
                }
            }
        }
        if (tr.nrows > 0) {
            return rs;
        }
        try (JDBCStatement s1 = new JDBCStatement(this.conn);){
            rs0 = (JDBCResultSet)s1.executeQuery("PRAGMA table_info(" + Shell.sql_quote(table) + ")");
        }
        if (rs0 != null && rs0.tr != null && rs0.tr.nrows > 0) {
            int i;
            Hashtable<String, Integer> h0 = new Hashtable<String, Integer>();
            for (i = 0; i < rs0.tr.ncolumns; ++i) {
                h0.put(rs0.tr.column[i], i);
            }
            for (i = 0; i < rs0.tr.nrows; ++i) {
                String pk;
                int col;
                String[] r0 = (String[])rs0.tr.rows.elementAt(i);
                String type = r0[col = ((Integer)h0.get("type")).intValue()];
                if (!type.equalsIgnoreCase("integer") || (pk = r0[col = ((Integer)h0.get("pk")).intValue()]).charAt(0) == '0') continue;
                String[] row = new String[cols.length];
                row[0] = "";
                row[1] = "";
                row[2] = table;
                col = (Integer)h0.get("name");
                row[3] = r0[col];
                col = (Integer)h0.get("cid");
                row[4] = Integer.toString(Integer.parseInt(r0[col]) + 1);
                row[5] = "";
                tr.newrow(row);
            }
        }
        return rs;
    }

    private void internalImportedKeys(String table, String pktable, JDBCResultSet in, TableResultX out) {
        int i;
        Hashtable<String, Integer> h0 = new Hashtable<String, Integer>();
        for (i = 0; i < in.tr.ncolumns; ++i) {
            h0.put(in.tr.column[i], i);
        }
        for (i = 0; i < in.tr.nrows; ++i) {
            String[] r0 = (String[])in.tr.rows.elementAt(i);
            int col = (Integer)h0.get("table");
            String pktab = r0[col];
            if (pktable != null && !pktable.equalsIgnoreCase(pktab)) continue;
            col = (Integer)h0.get("from");
            String fkcol = r0[col];
            col = (Integer)h0.get("to");
            String pkcol = r0[col];
            col = (Integer)h0.get("seq");
            String seq = r0[col];
            String[] row = new String[out.ncolumns];
            row[0] = "";
            row[1] = "";
            row[2] = pktab;
            row[3] = pkcol;
            row[4] = "";
            row[5] = "";
            row[6] = table;
            row[7] = fkcol == null ? pkcol : fkcol;
            row[8] = Integer.toString(Integer.parseInt(seq) + 1);
            row[9] = "3";
            row[10] = "3";
            row[11] = null;
            row[12] = null;
            row[13] = "7";
            out.newrow(row);
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        JDBCResultSet rs0 = null;
        try (JDBCStatement s0 = new JDBCStatement(this.conn);){
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception se) {
                throw new SQLException("schema reload failed");
            }
            rs0 = (JDBCResultSet)s0.executeQuery("PRAGMA foreign_key_list(" + Shell.sql_quote(table) + ")");
        }
        String[] cols = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] types = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        if (rs0 != null && rs0.tr != null && rs0.tr.nrows > 0) {
            this.internalImportedKeys(table, null, rs0, tr);
        }
        return rs;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        String[] cols = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] types = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        return rs;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        JDBCResultSet rs0 = null;
        if (foreignTable != null && foreignTable.charAt(0) != '%') {
            try (JDBCStatement s0 = new JDBCStatement(this.conn);){
                try {
                    this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
                }
                catch (Exception se) {
                    throw new SQLException("schema reload failed");
                }
                rs0 = (JDBCResultSet)s0.executeQuery("PRAGMA foreign_key_list(" + Shell.sql_quote(foreignTable) + ")");
            }
        }
        String[] cols = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        int[] types = new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        if (rs0 != null && rs0.tr != null && rs0.tr.nrows > 0) {
            String pktable = null;
            if (primaryTable != null && primaryTable.charAt(0) != '%') {
                pktable = primaryTable;
            }
            this.internalImportedKeys(foreignTable, pktable, rs0, tr);
        }
        return rs;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        String[] cols = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        int[] types = new int[]{12, 5, 4, 12, 12, 12, 5, -7, 5, -7, -7, -7, 12, 5, 5, 4, 4, 4};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        String[] row1 = new String[]{"VARCHAR", "12", "65536", "'", "'", null, "1", "1", "3", "0", "0", "0", null, "0", "0", "0", "0", "0"};
        tr.newrow(row1);
        String[] row2 = new String[]{"INTEGER", "4", "32", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "2"};
        tr.newrow(row2);
        String[] row3 = new String[]{"DOUBLE", "8", "16", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "10"};
        tr.newrow(row3);
        String[] row4 = new String[]{"FLOAT", "6", "7", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "10"};
        tr.newrow(row4);
        String[] row5 = new String[]{"SMALLINT", "5", "16", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "2"};
        tr.newrow(row5);
        String[] row6 = new String[]{"BIT", "-7", "1", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "2"};
        tr.newrow(row6);
        String[] row7 = new String[]{"TIMESTAMP", "93", "30", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tr.newrow(row7);
        String[] row8 = new String[]{"DATE", "91", "10", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tr.newrow(row8);
        String[] row9 = new String[]{"TIME", "92", "8", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tr.newrow(row9);
        String[] row10 = new String[]{"BINARY", "-2", "65536", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tr.newrow(row10);
        String[] row11 = new String[]{"VARBINARY", "-3", "65536", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "0"};
        tr.newrow(row11);
        String[] row12 = new String[]{"REAL", "7", "16", null, null, null, "1", "0", "3", "0", "0", "1", null, "0", "0", "0", "0", "10"};
        tr.newrow(row12);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        JDBCResultSet rs0 = null;
        try (JDBCStatement s0 = new JDBCStatement(this.conn);){
            try {
                this.conn.db.exec("SELECT 1 FROM sqlite_master LIMIT 1", null);
            }
            catch (Exception se) {
                throw new SQLException("schema reload failed");
            }
            rs0 = (JDBCResultSet)s0.executeQuery("PRAGMA index_list(" + Shell.sql_quote(table) + ")");
        }
        String[] cols = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"};
        int[] types = new int[]{12, 12, 12, -7, 12, 12, 5, 5, 12, 12, 4, 4, 12};
        TableResultX tr = new TableResultX();
        tr.columns(cols);
        tr.sql_types(types);
        JDBCResultSet rs = new JDBCResultSet(tr, null);
        if (rs0 != null && rs0.tr != null && rs0.tr.nrows > 0) {
            int i;
            Hashtable<String, Integer> h0 = new Hashtable<String, Integer>();
            for (i = 0; i < rs0.tr.ncolumns; ++i) {
                h0.put(rs0.tr.column[i], i);
            }
            for (i = 0; i < rs0.tr.nrows; ++i) {
                int k;
                String[] r0 = (String[])rs0.tr.rows.elementAt(i);
                int col = (Integer)h0.get("unique");
                String uniq = r0[col];
                col = (Integer)h0.get("name");
                String iname = r0[col];
                if (unique && uniq.charAt(0) == '0') continue;
                JDBCResultSet rs1 = null;
                try (JDBCStatement s1 = new JDBCStatement(this.conn);){
                    rs1 = (JDBCResultSet)s1.executeQuery("PRAGMA index_info(" + Shell.sql_quote(iname) + ")");
                }
                if (rs1 == null || rs1.tr == null || rs1.tr.nrows <= 0) continue;
                Hashtable<String, Integer> h1 = new Hashtable<String, Integer>();
                for (k = 0; k < rs1.tr.ncolumns; ++k) {
                    h1.put(rs1.tr.column[k], k);
                }
                for (k = 0; k < rs1.tr.nrows; ++k) {
                    String[] r1 = (String[])rs1.tr.rows.elementAt(k);
                    String[] row = new String[cols.length];
                    row[0] = "";
                    row[1] = "";
                    row[2] = table;
                    row[3] = uniq.charAt(0) != '0' || iname.charAt(0) == '(' && iname.indexOf(" autoindex ") > 0 ? "0" : "1";
                    row[4] = "";
                    row[5] = iname;
                    row[6] = "3";
                    col = (Integer)h1.get("seqno");
                    row[7] = Integer.toString(Integer.parseInt(r1[col]) + 1);
                    col = (Integer)h1.get("name");
                    row[8] = r1[col];
                    row[9] = "A";
                    row[10] = "0";
                    row[11] = "0";
                    row[12] = null;
                    tr.newrow(row);
                }
            }
        }
        return rs;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003 || type == 1004 || type == 1005;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        if (type == 1003 || type == 1004 || type == 1005) {
            return concurrency == 1007 || concurrency == 1008;
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return type == 1003 || type == 1004 || type == 1005;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return type == 1003 || type == 1004 || type == 1005;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return type == 1003 || type == 1004 || type == 1005;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    static String mapTypeName(int type) {
        switch (type) {
            case 4: {
                return "integer";
            }
            case 5: {
                return "smallint";
            }
            case 6: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 93: {
                return "timestamp";
            }
            case 91: {
                return "date";
            }
            case 92: {
                return "time";
            }
            case -2: {
                return "binary";
            }
            case -3: {
                return "varbinary";
            }
            case 7: {
                return "real";
            }
        }
        return "varchar";
    }

    static int mapSqlType(String type) {
        if (type == null) {
            return 12;
        }
        if ((type = type.toLowerCase()).startsWith("inter")) {
            return 12;
        }
        if (type.startsWith("numeric") || type.startsWith("int")) {
            return 4;
        }
        if (type.startsWith("tinyint") || type.startsWith("smallint")) {
            return 5;
        }
        if (type.startsWith("float")) {
            return 6;
        }
        if (type.startsWith("double")) {
            return 8;
        }
        if (type.startsWith("datetime") || type.startsWith("timestamp")) {
            return 93;
        }
        if (type.startsWith("date")) {
            return 91;
        }
        if (type.startsWith("time")) {
            return 92;
        }
        if (type.startsWith("blob")) {
            return -2;
        }
        if (type.startsWith("binary")) {
            return -2;
        }
        if (type.startsWith("varbinary")) {
            return -3;
        }
        if (type.startsWith("real")) {
            return 7;
        }
        return 12;
    }

    static int getM(String typeStr, int type) {
        int m = 65536;
        switch (type) {
            case 4: {
                m = 11;
                break;
            }
            case 5: {
                m = 6;
                break;
            }
            case 6: {
                m = 25;
                break;
            }
            case 7: 
            case 8: {
                m = 54;
                break;
            }
            case 93: {
                return 30;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
        }
        typeStr = typeStr.toLowerCase();
        int i1 = typeStr.indexOf(40);
        if (i1 > 0) {
            int i2;
            if ((i2 = typeStr.indexOf(44, ++i1)) < 0) {
                i2 = typeStr.indexOf(41, i1);
            }
            if (i2 - i1 > 0) {
                String num = typeStr.substring(i1, i2);
                try {
                    m = Integer.parseInt(num, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return m;
    }

    static int getD(String typeStr, int type) {
        int d = 0;
        switch (type) {
            case 4: {
                d = 10;
                break;
            }
            case 5: {
                d = 5;
                break;
            }
            case 6: {
                d = 24;
                break;
            }
            case 7: 
            case 8: {
                d = 53;
                break;
            }
            default: {
                return JDBCDatabaseMetaData.getM(typeStr, type);
            }
        }
        typeStr = typeStr.toLowerCase();
        int i1 = typeStr.indexOf(40);
        if (i1 > 0) {
            int i2;
            if ((i2 = typeStr.indexOf(44, ++i1)) < 0) {
                return JDBCDatabaseMetaData.getM(typeStr, type);
            }
            i1 = i2;
            if ((i2 = typeStr.indexOf(41, i1)) - i1 > 0) {
                String num = typeStr.substring(i1, i2);
                try {
                    d = Integer.parseInt(num, 10);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return d;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int x) {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public int getDatabaseMajorVersion() {
        return 1;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return 20100131;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 1;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas(String cat, String schema) throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLException("unsupported");
    }

    @Override
    public ResultSet getFunctions(String cat, String schema, String func) throws SQLException {
        throw new SQLException("unsupported");
    }

    @Override
    public ResultSet getFunctionColumns(String cat, String schema, String func, String colpat) throws SQLException {
        throw new SQLException("unsupported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("unsupported");
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        return false;
    }
}

