/*
 * Decompiled with CFR 0.152.
 */
package SQLite;

public class StringEncoder {
    static final char[] xdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encode(byte[] a) {
        if (a == null || a.length == 0) {
            return "x";
        }
        int[] cnt = new int[256];
        for (int i = 0; i < a.length; ++i) {
            int n = a[i] & 0xFF;
            cnt[n] = cnt[n] + 1;
        }
        int shift = 1;
        int nEscapes = a.length;
        for (int i = 1; i < 256; ++i) {
            int sum;
            if (i == 39 || (sum = cnt[i] + cnt[i + 1 & 0xFF] + cnt[i + 39 & 0xFF]) >= nEscapes) continue;
            nEscapes = sum;
            shift = i;
            if (nEscapes == 0) break;
        }
        int outLen = a.length + nEscapes + 1;
        StringBuffer out = new StringBuffer(outLen);
        out.append((char)shift);
        for (int i = 0; i < a.length; ++i) {
            char c = (char)(a[i] - shift & 0xFF);
            if (c == '\u0000') {
                out.append('\u0001');
                out.append('\u0001');
                continue;
            }
            if (c == '\u0001') {
                out.append('\u0001');
                out.append('\u0002');
                continue;
            }
            if (c == '\'') {
                out.append('\u0001');
                out.append('\u0003');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static byte[] decode(String s) {
        char[] a = s.toCharArray();
        if (a.length > 2 && a[0] == 'X' && a[1] == '\'' && a[a.length - 1] == '\'') {
            byte[] result = new byte[(a.length - 3) / 2];
            int k = 0;
            for (int i = 2; i < a.length - 1; i += 2) {
                int tmp;
                switch (a[i]) {
                    case '0': {
                        tmp = 0;
                        break;
                    }
                    case '1': {
                        tmp = 1;
                        break;
                    }
                    case '2': {
                        tmp = 2;
                        break;
                    }
                    case '3': {
                        tmp = 3;
                        break;
                    }
                    case '4': {
                        tmp = 4;
                        break;
                    }
                    case '5': {
                        tmp = 5;
                        break;
                    }
                    case '6': {
                        tmp = 6;
                        break;
                    }
                    case '7': {
                        tmp = 7;
                        break;
                    }
                    case '8': {
                        tmp = 8;
                        break;
                    }
                    case '9': {
                        tmp = 9;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        tmp = 10;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        tmp = 11;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        tmp = 12;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        tmp = 13;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        tmp = 14;
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        tmp = 15;
                        break;
                    }
                    default: {
                        tmp = 0;
                    }
                }
                result[k] = (byte)(tmp << 4);
                switch (a[i + 1]) {
                    case '0': {
                        tmp = 0;
                        break;
                    }
                    case '1': {
                        tmp = 1;
                        break;
                    }
                    case '2': {
                        tmp = 2;
                        break;
                    }
                    case '3': {
                        tmp = 3;
                        break;
                    }
                    case '4': {
                        tmp = 4;
                        break;
                    }
                    case '5': {
                        tmp = 5;
                        break;
                    }
                    case '6': {
                        tmp = 6;
                        break;
                    }
                    case '7': {
                        tmp = 7;
                        break;
                    }
                    case '8': {
                        tmp = 8;
                        break;
                    }
                    case '9': {
                        tmp = 9;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        tmp = 10;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        tmp = 11;
                        break;
                    }
                    case 'C': 
                    case 'c': {
                        tmp = 12;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        tmp = 13;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        tmp = 14;
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        tmp = 15;
                        break;
                    }
                    default: {
                        tmp = 0;
                    }
                }
                int n = k++;
                result[n] = (byte)(result[n] | tmp);
            }
            return result;
        }
        byte[] result = new byte[a.length - 1];
        int i = 0;
        char shift = s.charAt(i++);
        int j = 0;
        while (i < s.length()) {
            int c;
            if ((c = s.charAt(i++)) == 1) {
                if ((c = s.charAt(i++)) == 1) {
                    c = 0;
                } else if (c == 2) {
                    c = 1;
                } else if (c == 3) {
                    c = 39;
                } else {
                    throw new IllegalArgumentException("invalid string passed to decoder: " + j);
                }
            }
            result[j++] = (byte)(c + shift & 0xFF);
        }
        int outLen = j;
        if (result.length != outLen) {
            result = StringEncoder.byteCopy(result, 0, outLen, new byte[outLen]);
        }
        return result;
    }

    private static byte[] byteCopy(byte[] source, int offset, int count, byte[] target) {
        int i = offset;
        int j = 0;
        while (i < offset + count) {
            target[j] = source[i];
            ++i;
            ++j;
        }
        return target;
    }

    public static String encodeX(byte[] a) {
        if (a == null || a.length == 0) {
            return "X''";
        }
        int outLen = a.length * 2 + 3;
        StringBuffer out = new StringBuffer(outLen);
        out.append('X');
        out.append('\'');
        for (int i = 0; i < a.length; ++i) {
            out.append(xdigits[a[i] >> 4 & 0xF]);
            out.append(xdigits[a[i] & 0xF]);
        }
        out.append('\'');
        return out.toString();
    }
}

