/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimerTask;

public class Timer {
    private static long timerId;
    private final TimerImpl impl;
    private final FinalizerHelper finalizer;

    private static synchronized long nextId() {
        return timerId++;
    }

    public Timer(String name, boolean isDaemon) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        this.impl = new TimerImpl(name, isDaemon);
        this.finalizer = new FinalizerHelper(this.impl);
    }

    public Timer(String name) {
        this(name, false);
    }

    public Timer(boolean isDaemon) {
        this("Timer-" + Timer.nextId(), isDaemon);
    }

    public Timer() {
        this(false);
    }

    public void cancel() {
        this.impl.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purge() {
        TimerImpl timerImpl = this.impl;
        synchronized (timerImpl) {
            return this.impl.purge();
        }
    }

    public void schedule(TimerTask task, Date when) {
        if (when.getTime() < 0L) {
            throw new IllegalArgumentException("when < 0: " + when.getTime());
        }
        long delay = when.getTime() - System.currentTimeMillis();
        this.scheduleImpl(task, delay < 0L ? 0L : delay, -1L, false);
    }

    public void schedule(TimerTask task, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("delay < 0: " + delay);
        }
        this.scheduleImpl(task, delay, -1L, false);
    }

    public void schedule(TimerTask task, long delay, long period) {
        if (delay < 0L || period <= 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleImpl(task, delay, period, false);
    }

    public void schedule(TimerTask task, Date when, long period) {
        if (period <= 0L || when.getTime() < 0L) {
            throw new IllegalArgumentException();
        }
        long delay = when.getTime() - System.currentTimeMillis();
        this.scheduleImpl(task, delay < 0L ? 0L : delay, period, false);
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        if (delay < 0L || period <= 0L) {
            throw new IllegalArgumentException();
        }
        this.scheduleImpl(task, delay, period, true);
    }

    public void scheduleAtFixedRate(TimerTask task, Date when, long period) {
        if (period <= 0L || when.getTime() < 0L) {
            throw new IllegalArgumentException();
        }
        long delay = when.getTime() - System.currentTimeMillis();
        this.scheduleImpl(task, delay, period, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleImpl(TimerTask task, long delay, long period, boolean fixed) {
        TimerImpl timerImpl = this.impl;
        synchronized (timerImpl) {
            if (this.impl.cancelled) {
                throw new IllegalStateException("Timer was canceled");
            }
            long when = delay + System.currentTimeMillis();
            if (when < 0L) {
                throw new IllegalArgumentException("Illegal delay to start the TimerTask: " + when);
            }
            Object object = task.lock;
            synchronized (object) {
                if (task.isScheduled()) {
                    throw new IllegalStateException("TimerTask is scheduled already");
                }
                if (task.cancelled) {
                    throw new IllegalStateException("TimerTask is canceled");
                }
                task.when = when;
                task.period = period;
                task.fixedRate = fixed;
            }
            this.impl.insertTask(task);
        }
    }

    private static final class TimerImpl
    extends Thread {
        private boolean cancelled;
        private boolean finished;
        private TimerHeap tasks = new TimerHeap();

        TimerImpl(String name, boolean isDaemon) {
            this.setName(name);
            this.setDaemon(isDaemon);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                TimerTask task;
                TimerImpl timerImpl = this;
                synchronized (timerImpl) {
                    long timeToSleep;
                    if (this.cancelled) {
                        return;
                    }
                    if (this.tasks.isEmpty()) {
                        if (this.finished) {
                            return;
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    long currentTime = System.currentTimeMillis();
                    task = this.tasks.minimum();
                    Object object = task.lock;
                    synchronized (object) {
                        if (task.cancelled) {
                            this.tasks.delete(0);
                            continue;
                        }
                        timeToSleep = task.when - currentTime;
                    }
                    if (timeToSleep > 0L) {
                        try {
                            this.wait(timeToSleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    object = task.lock;
                    synchronized (object) {
                        int pos = 0;
                        if (this.tasks.minimum().when != task.when) {
                            pos = this.tasks.getTask(task);
                        }
                        if (task.cancelled) {
                            this.tasks.delete(this.tasks.getTask(task));
                            continue;
                        }
                        task.setScheduledTime(task.when);
                        this.tasks.delete(pos);
                        if (task.period >= 0L) {
                            task.when = task.fixedRate ? (task.when += task.period) : System.currentTimeMillis() + task.period;
                            this.insertTask(task);
                        } else {
                            task.when = 0L;
                        }
                    }
                }
                boolean taskCompletedNormally = false;
                try {
                    task.run();
                    taskCompletedNormally = true;
                    continue;
                }
                finally {
                    if (taskCompletedNormally) continue;
                    TimerImpl timerImpl2 = this;
                    synchronized (timerImpl2) {
                        this.cancelled = true;
                    }
                    continue;
                }
                break;
            }
        }

        private void insertTask(TimerTask newTask) {
            this.tasks.insert(newTask);
            this.notify();
        }

        public synchronized void cancel() {
            this.cancelled = true;
            this.tasks.reset();
            this.notify();
        }

        public int purge() {
            if (this.tasks.isEmpty()) {
                return 0;
            }
            this.tasks.deletedCancelledNumber = 0;
            this.tasks.deleteIfCancelled();
            return this.tasks.deletedCancelledNumber;
        }

        private static final class TimerHeap {
            private int DEFAULT_HEAP_SIZE = 256;
            private TimerTask[] timers = new TimerTask[this.DEFAULT_HEAP_SIZE];
            private int size = 0;
            private int deletedCancelledNumber = 0;

            private TimerHeap() {
            }

            public TimerTask minimum() {
                return this.timers[0];
            }

            public boolean isEmpty() {
                return this.size == 0;
            }

            public void insert(TimerTask task) {
                if (this.timers.length == this.size) {
                    TimerTask[] appendedTimers = new TimerTask[this.size * 2];
                    System.arraycopy((Object)this.timers, 0, (Object)appendedTimers, 0, this.size);
                    this.timers = appendedTimers;
                }
                this.timers[this.size++] = task;
                this.upHeap();
            }

            public void delete(int pos) {
                if (pos >= 0 && pos < this.size) {
                    this.timers[pos] = this.timers[--this.size];
                    this.timers[this.size] = null;
                    this.downHeap(pos);
                }
            }

            private void upHeap() {
                int current = this.size - 1;
                int parent = (current - 1) / 2;
                while (this.timers[current].when < this.timers[parent].when) {
                    TimerTask tmp = this.timers[current];
                    this.timers[current] = this.timers[parent];
                    this.timers[parent] = tmp;
                    current = parent;
                    parent = (current - 1) / 2;
                }
            }

            private void downHeap(int pos) {
                int current = pos;
                int child = 2 * current + 1;
                while (child < this.size && this.size > 0) {
                    if (child + 1 < this.size && this.timers[child + 1].when < this.timers[child].when) {
                        ++child;
                    }
                    if (this.timers[current].when < this.timers[child].when) break;
                    TimerTask tmp = this.timers[current];
                    this.timers[current] = this.timers[child];
                    this.timers[child] = tmp;
                    current = child;
                    child = 2 * current + 1;
                }
            }

            public void reset() {
                this.timers = new TimerTask[this.DEFAULT_HEAP_SIZE];
                this.size = 0;
            }

            public void adjustMinimum() {
                this.downHeap(0);
            }

            public void deleteIfCancelled() {
                for (int i = 0; i < this.size; ++i) {
                    if (!this.timers[i].cancelled) continue;
                    ++this.deletedCancelledNumber;
                    this.delete(i);
                    --i;
                }
            }

            private int getTask(TimerTask task) {
                for (int i = 0; i < this.timers.length; ++i) {
                    if (this.timers[i] != task) continue;
                    return i;
                }
                return -1;
            }
        }
    }

    private static final class FinalizerHelper {
        private final TimerImpl impl;

        FinalizerHelper(TimerImpl impl) {
            this.impl = impl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                TimerImpl timerImpl = this.impl;
                synchronized (timerImpl) {
                    this.impl.finished = true;
                    this.impl.notify();
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

