/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.Deflater;
import libcore.io.Streams;

public class DeflaterInputStream
extends FilterInputStream {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    protected final Deflater def;
    protected final byte[] buf;
    private boolean closed = false;
    private boolean available = true;

    public DeflaterInputStream(InputStream in) {
        this(in, new Deflater(), 1024);
    }

    public DeflaterInputStream(InputStream in, Deflater deflater) {
        this(in, deflater, 1024);
    }

    public DeflaterInputStream(InputStream in, Deflater deflater, int bufferSize) {
        super(in);
        if (in == null) {
            throw new NullPointerException("in == null");
        }
        if (deflater == null) {
            throw new NullPointerException("deflater == null");
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize <= 0: " + bufferSize);
        }
        this.def = deflater;
        this.buf = new byte[bufferSize];
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.def.end();
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        return Streams.readSingleByte(this);
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int count;
        int bytesDeflated;
        this.checkClosed();
        Arrays.checkOffsetAndCount(buffer.length, byteOffset, byteCount);
        if (byteCount == 0) {
            return 0;
        }
        if (!this.available) {
            return -1;
        }
        for (count = 0; count < byteCount && !this.def.finished(); count += bytesDeflated) {
            if (this.def.needsInput()) {
                int bytesRead = this.in.read(this.buf);
                if (bytesRead == -1) {
                    this.def.finish();
                } else {
                    this.def.setInput(this.buf, 0, bytesRead);
                }
            }
            if ((bytesDeflated = this.def.deflate(this.buf, 0, Math.min(this.buf.length, byteCount - count))) == -1) break;
            System.arraycopy((Object)this.buf, 0, (Object)buffer, byteOffset + count, bytesDeflated);
        }
        if (count == 0) {
            count = -1;
            this.available = false;
        }
        return count;
    }

    @Override
    public long skip(long byteCount) throws IOException {
        byteCount = Math.min(Integer.MAX_VALUE, byteCount);
        return Streams.skipByReading(this, byteCount);
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return this.available ? 1 : 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int limit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException();
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
    }
}

