/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.robovm.rt.VM;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.MarshalsArray;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public abstract class Struct<T extends Struct<T>>
extends NativeObject
implements Iterable<T> {
    protected Struct() {
        this.setHandle(VM.allocateMemory(this._sizeOf()));
    }

    protected Struct(long handle) {
        this.setHandle(handle);
    }

    public T copy() {
        return this.copy(1);
    }

    public T copy(int n) {
        Object o = Struct.allocate(this.getClass(), n);
        VM.memcpy(((NativeObject)o).getHandle(), this.getHandle(), this._sizeOf() * n);
        return (T)o;
    }

    public T copyWithMalloc() {
        return this.copyWithMalloc(1);
    }

    public T copyWithMalloc(int n) {
        Object o = Struct.malloc(this.getClass(), n);
        VM.memcpy(((NativeObject)o).getHandle(), this.getHandle(), this._sizeOf() * n);
        return (T)o;
    }

    @Override
    public <U extends NativeObject> U as(Class<U> type) {
        if (Struct.class.isAssignableFrom(type)) {
            Class<U> c = type;
            return Struct.toStruct(c, this.getHandle());
        }
        return super.as(type);
    }

    protected int _sizeOf() {
        return 0;
    }

    public void clear() {
        this.clear(1);
    }

    public void clear(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        VM.memset(this.getHandle(), (byte)0, this._sizeOf() * n);
    }

    public void free() {
        VM.free(this.getHandle());
    }

    @Override
    public Iterator<T> iterator() {
        return new StructIterator<Struct>(this);
    }

    public Iterator<T> iterator(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        return new StructIterator<Struct>(this, n);
    }

    protected T wrap(long address) {
        return (T)Struct.toStruct(this.getClass(), address);
    }

    public T next() {
        return this.next(1L);
    }

    public T next(long delta) {
        if (delta == 0L) {
            return (T)this;
        }
        return this.wrap(this.getHandle() + (long)this._sizeOf() * delta);
    }

    public T previous() {
        return this.previous(1L);
    }

    public T previous(long delta) {
        return this.next(-delta);
    }

    public T[] toArray(int n) {
        Struct[] array = (Struct[])Array.newInstance(this.getClass(), n);
        for (int i = 0; i < n; ++i) {
            array[i] = this.next(i);
        }
        return array;
    }

    public void update(T o) {
        this.update(o, 1);
    }

    public void update(T o, int n) {
        if (o == null) {
            throw new NullPointerException("o");
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("Expected an instance of " + this.getClass().getName() + ". Actual type: " + o.getClass().getName());
        }
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        VM.memcpy(this.getHandle(), ((NativeObject)o).getHandle(), this._sizeOf() * n);
    }

    public void update(T[] array) {
        if (array == null) {
            throw new NullPointerException("array");
        }
        Class<?> cls = this.getClass();
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            T o = array[i];
            if (o == null) {
                throw new NullPointerException("null at index " + i);
            }
            if (o.getClass() == cls) continue;
            throw new IllegalArgumentException("Expected an instance of " + cls.getName() + " at index " + i + ". Actual type: " + o.getClass().getName());
        }
        long dst = this.getHandle();
        int size = this._sizeOf();
        for (int i = 0; i < len; ++i) {
            VM.memcpy(dst, ((NativeObject)array[i]).getHandle(), size);
            dst += (long)size;
        }
    }

    public List<T> toList(int n) {
        ArrayList<T> l = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            l.add(this.next(i));
        }
        return l;
    }

    public static int sizeOf() {
        return 0;
    }

    public static int sizeOf(Struct<?> struct) {
        return struct._sizeOf();
    }

    public static int offsetOf(int index) {
        return 0;
    }

    public static <T extends Struct<T>> T allocate(Class<T> cls) {
        return Struct.allocate(cls, 1);
    }

    public static <T extends Struct<T>> T allocate(Class<T> cls, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        Struct o = (Struct)VM.allocateObject(cls);
        long handle = VM.allocateMemory(o._sizeOf() * n);
        o.setHandle(handle);
        return (T)o;
    }

    public static <T extends Struct<T>> T malloc(Class<T> cls) {
        return Struct.malloc(cls, 1);
    }

    public static <T extends Struct<T>> T malloc(Class<T> cls, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n < 1");
        }
        Struct o = (Struct)VM.allocateObject(cls);
        long handle = VM.malloc(o._sizeOf() * n);
        o.setHandle(handle);
        return (T)o;
    }

    public static <T extends Struct<T>> T toStruct(Class<T> cls, long handle) {
        if (handle == 0L) {
            return null;
        }
        Struct o = (Struct)VM.allocateObject(cls);
        o.setHandle(handle);
        return (T)o;
    }

    static class StructIterator<T extends Struct<T>>
    implements Iterator<T> {
        private T next;
        private int n;
        private int i = 0;

        StructIterator(T first) {
            this(first, -1);
        }

        StructIterator(T first, int n) {
            this.next = first;
            this.n = n;
        }

        @Override
        public boolean hasNext() {
            return this.n == -1 || this.i < this.n;
        }

        @Override
        public T next() {
            T o = this.next;
            this.next = ((Struct)this.next).next();
            ++this.i;
            return o;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static <T extends Struct<T>> T toObject(Class<T> cls, long handle, long flags) {
            return Struct.toStruct(cls, handle);
        }

        @MarshalsPointer
        public static long toNative(Struct<?> o, long flags) {
            if (o == null) {
                return 0L;
            }
            return o.getHandle();
        }

        @MarshalsArray
        public static <T extends Struct<T>> T toObject(Class<T> cls, long handle, long flags, int d1) {
            T s = Struct.toStruct(cls, handle);
            return s;
        }

        @MarshalsArray
        public static <T extends Struct<T>> void toNative(T o, long handle, long flags, int d1) {
            if (o.getHandle() == handle) {
                return;
            }
            VM.memcpy(handle, o.getHandle(), d1 * o._sizeOf());
        }

        @MarshalsArray
        public static <T extends Struct<T>> T toObject(Class<T> cls, long handle, long flags, int d1, int d2) {
            T s = Struct.toStruct(cls, handle);
            return s;
        }

        @MarshalsArray
        public static <T extends Struct<T>> void toNative(T o, long handle, long flags, int d1, int d2) {
            Marshaler.toNative(o, handle, flags, d1 * d2);
        }

        @MarshalsArray
        public static <T extends Struct<T>> T toObject(Class<T> cls, long handle, long flags, int d1, int d2, int d3) {
            T s = Struct.toStruct(cls, handle);
            return s;
        }

        @MarshalsArray
        public static <T extends Struct<T>> void toNative(T o, long handle, long flags, int d1, int d2, int d3) {
            Marshaler.toNative(o, handle, flags, d1 * d2 * d3);
        }

        private static void checkDimensions(Class<?> baseType, String format, int actual, int expected) {
            if (actual != expected) {
                String suffixActual = String.format(format, actual);
                String suffixExpected = String.format(format, expected);
                throw new IllegalArgumentException("Expected " + baseType.getName() + suffixExpected + ". Got " + baseType.getName() + suffixActual);
            }
        }

        @MarshalsArray
        public static <T extends Struct<T>> T[] array1DToObject(Class<T[]> arrayClass, long handle, long flags, int d1) {
            Object s = Struct.toStruct(arrayClass.getComponentType(), handle);
            return s.toArray(d1);
        }

        @MarshalsArray
        public static <T extends Struct<T>> void array1DToNative(T[] o, long handle, long flags, int d1) {
            Class<?> structClass = o.getClass().getComponentType();
            Marshaler.checkDimensions(structClass, "[%d]", o.length, d1);
            Object s = Struct.toStruct(structClass, handle);
            ((Struct)s).update(o);
        }

        @MarshalsArray
        public static <T extends Struct<T>> T[][] array2DToObject(Class<T[][]> arrayClass, long handle, long flags, int d1, int d2) {
            Class<?> structClass = arrayClass.getComponentType().getComponentType();
            Struct[][] o = (Struct[][])Array.newInstance(structClass, d1, d2);
            Object s = Struct.toStruct(structClass, handle);
            int len1 = o.length;
            for (int i = 0; i < len1; ++i) {
                o[i] = s.toArray(d2);
                s = ((Struct)s).next(d2);
            }
            return o;
        }

        @MarshalsArray
        public static <T extends Struct<T>> void array2DToNative(T[][] o, long handle, long flags, int d1, int d2) {
            Class<?> structClass = o.getClass().getComponentType().getComponentType();
            Marshaler.checkDimensions(structClass, "[%d][]", o.length, d1);
            int len1 = o.length;
            for (int i = 0; i < len1; ++i) {
                Marshaler.checkDimensions(structClass, "[][%d]", o[i].length, d2);
            }
            Object s = Struct.toStruct(structClass, handle);
            for (int i = 0; i < len1; ++i) {
                ((Struct)s).update(o[i]);
                s = ((Struct)s).next(d2);
            }
        }

        @MarshalsArray
        public static <T extends Struct<T>> T[][][] array3DToObject(Class<T[][][]> arrayClass, long handle, long flags, int d1, int d2, int d3) {
            Class<?> structClass = arrayClass.getComponentType().getComponentType().getComponentType();
            Struct[][][] o = (Struct[][][])Array.newInstance(structClass, d1, d2, d3);
            Object s = Struct.toStruct(structClass, handle);
            int len1 = o.length;
            for (int i = 0; i < len1; ++i) {
                int len2 = o[i].length;
                for (int j = 0; j < len2; ++j) {
                    o[i][j] = s.toArray(d3);
                    s = ((Struct)s).next(d3);
                }
            }
            return o;
        }

        @MarshalsArray
        public static <T extends Struct<T>> void array3DToNative(T[][][] o, long handle, long flags, int d1, int d2, int d3) {
            Class<?> structClass = o.getClass().getComponentType().getComponentType().getComponentType();
            Marshaler.checkDimensions(structClass, "[%d][][]", o.length, d1);
            int len1 = o.length;
            for (int i = 0; i < len1; ++i) {
                T[][] p = o[i];
                Marshaler.checkDimensions(structClass, "[][%d][]", p.length, d2);
                int len2 = p.length;
                for (int j = 0; j < len2; ++j) {
                    Marshaler.checkDimensions(structClass, "[][][%d]", p[j].length, d3);
                }
            }
            Object s = Struct.toStruct(structClass, handle);
            for (int i = 0; i < len1; ++i) {
                T[][] p = o[i];
                int len2 = p.length;
                for (int j = 0; j < len2; ++j) {
                    ((Struct)s).update(o[i][j]);
                    s = ((Struct)s).next(d3);
                }
            }
        }
    }
}

