/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro.ptr;

import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public final class MachineSizedFloatPtr
extends Struct<MachineSizedFloatPtr> {
    @StructMember(value=0)
    @MachineSizedFloat
    public native double get();

    @StructMember(value=0)
    public native void set(@MachineSizedFloat double var1);

    public FloatBuffer asFloatBuffer(int n) {
        if (this._sizeOf() != 4) {
            throw new IllegalStateException("Not a 32-bit platform");
        }
        return VM.newDirectByteBuffer(this.getHandle(), n << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    public DoubleBuffer asDoubleBuffer(int n) {
        if (this._sizeOf() != 8) {
            throw new IllegalStateException("Not a 64-bit platform");
        }
        return VM.newDirectByteBuffer(this.getHandle(), n << 3).order(ByteOrder.nativeOrder()).asDoubleBuffer();
    }

    public float[] toFloatArray(int n) {
        float[] result = new float[n];
        this.get(result);
        return result;
    }

    public void get(float[] dst) {
        this.get(dst, 0, dst.length);
    }

    public void get(float[] dst, int offset, int count) {
        if (this._sizeOf() == 4) {
            this.asFloatBuffer(count).get(dst, offset, count);
        } else {
            Arrays.checkOffsetAndCount(dst.length, offset, count);
            DoubleBuffer buf = this.asDoubleBuffer(count);
            for (int i = 0; i < count; ++i) {
                dst[i + offset] = (float)buf.get();
            }
        }
    }

    public void set(float[] src) {
        this.set(src, 0, src.length);
    }

    public void set(float[] src, int offset, int count) {
        if (this._sizeOf() == 4) {
            this.asFloatBuffer(count).put(src, offset, count);
        } else {
            Arrays.checkOffsetAndCount(src.length, offset, count);
            DoubleBuffer buf = this.asDoubleBuffer(count);
            for (int i = 0; i < count; ++i) {
                buf.put(src[i + offset]);
            }
        }
    }

    public double[] toDoubleArray(int n) {
        double[] result = new double[n];
        this.get(result);
        return result;
    }

    public void get(double[] dst) {
        this.get(dst, 0, dst.length);
    }

    public void get(double[] dst, int offset, int count) {
        if (this._sizeOf() == 8) {
            this.asDoubleBuffer(count).get(dst, offset, count);
        } else {
            Arrays.checkOffsetAndCount(dst.length, offset, count);
            FloatBuffer buf = this.asFloatBuffer(count);
            for (int i = 0; i < count; ++i) {
                dst[i + offset] = buf.get();
            }
        }
    }

    public void set(double[] src) {
        this.set(src, 0, src.length);
    }

    public void set(double[] src, int offset, int count) {
        if (this._sizeOf() == 4) {
            this.asDoubleBuffer(count).put(src, offset, count);
        } else {
            Arrays.checkOffsetAndCount(src.length, offset, count);
            FloatBuffer buf = this.asFloatBuffer(count);
            for (int i = 0; i < count; ++i) {
                buf.put((float)src[i + offset]);
            }
        }
    }

    public static class MachineSizedFloatPtrPtr
    extends Ptr<MachineSizedFloatPtr, MachineSizedFloatPtrPtr> {
    }
}

