/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;

public final class Math {
    public static final double E = 2.718281828459045;
    public static final double PI = 3.141592653589793;
    private static Random random;

    private Math() {
    }

    public static double abs(double d) {
        return Double.longBitsToDouble(Double.doubleToRawLongBits(d) & Long.MAX_VALUE);
    }

    public static float abs(float f) {
        return Float.intBitsToFloat(Float.floatToRawIntBits(f) & Integer.MAX_VALUE);
    }

    public static int abs(int i) {
        return i >= 0 ? i : -i;
    }

    public static long abs(long l) {
        return l >= 0L ? l : -l;
    }

    public static native double acos(double var0);

    public static native double asin(double var0);

    public static native double atan(double var0);

    public static native double atan2(double var0, double var2);

    public static native double cbrt(double var0);

    public static native double ceil(double var0);

    public static native double cos(double var0);

    public static native double cosh(double var0);

    public static native double exp(double var0);

    public static native double expm1(double var0);

    public static native double floor(double var0);

    public static native double hypot(double var0, double var2);

    public static native double IEEEremainder(double var0, double var2);

    public static native double log(double var0);

    public static native double log10(double var0);

    public static native double log1p(double var0);

    public static double max(double d1, double d2) {
        if (d1 > d2) {
            return d1;
        }
        if (d1 < d2) {
            return d2;
        }
        if (d1 != d2) {
            return Double.NaN;
        }
        if (Double.doubleToRawLongBits(d1) != 0L) {
            return d2;
        }
        return 0.0;
    }

    public static float max(float f1, float f2) {
        if (f1 > f2) {
            return f1;
        }
        if (f1 < f2) {
            return f2;
        }
        if (f1 != f2) {
            return Float.NaN;
        }
        if (Float.floatToRawIntBits(f1) != 0) {
            return f2;
        }
        return 0.0f;
    }

    public static int max(int i1, int i2) {
        return i1 > i2 ? i1 : i2;
    }

    public static long max(long l1, long l2) {
        return l1 > l2 ? l1 : l2;
    }

    public static double min(double d1, double d2) {
        if (d1 > d2) {
            return d2;
        }
        if (d1 < d2) {
            return d1;
        }
        if (d1 != d2) {
            return Double.NaN;
        }
        if (Double.doubleToRawLongBits(d1) == Long.MIN_VALUE) {
            return -0.0;
        }
        return d2;
    }

    public static float min(float f1, float f2) {
        if (f1 > f2) {
            return f2;
        }
        if (f1 < f2) {
            return f1;
        }
        if (f1 != f2) {
            return Float.NaN;
        }
        if (Float.floatToRawIntBits(f1) == Integer.MIN_VALUE) {
            return -0.0f;
        }
        return f2;
    }

    public static int min(int i1, int i2) {
        return i1 < i2 ? i1 : i2;
    }

    public static long min(long l1, long l2) {
        return l1 < l2 ? l1 : l2;
    }

    public static native double pow(double var0, double var2);

    public static native double rint(double var0);

    public static long round(double d) {
        if (d != d) {
            return 0L;
        }
        return (long)Math.floor(d + 0.5);
    }

    public static int round(float f) {
        if (f != f) {
            return 0;
        }
        return (int)Math.floor(f + 0.5f);
    }

    public static double signum(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double sig = d;
        if (d > 0.0) {
            sig = 1.0;
        } else if (d < 0.0) {
            sig = -1.0;
        }
        return sig;
    }

    public static float signum(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        float sig = f;
        if (f > 0.0f) {
            sig = 1.0f;
        } else if (f < 0.0f) {
            sig = -1.0f;
        }
        return sig;
    }

    public static native double sin(double var0);

    public static native double sinh(double var0);

    public static native double sqrt(double var0);

    public static native double tan(double var0);

    public static native double tanh(double var0);

    public static synchronized double random() {
        if (random == null) {
            random = new Random();
        }
        return random.nextDouble();
    }

    public static double toRadians(double angdeg) {
        return angdeg / 180.0 * Math.PI;
    }

    public static double toDegrees(double angrad) {
        return angrad * 180.0 / Math.PI;
    }

    public static double ulp(double d) {
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == Double.MAX_VALUE || d == -1.7976931348623157E308) {
            return Math.pow(2.0, 971.0);
        }
        d = Math.abs(d);
        return Math.nextafter(d, Double.MAX_VALUE) - d;
    }

    private static native double nextafter(double var0, double var2);

    public static float ulp(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        if (Float.isInfinite(f)) {
            return Float.POSITIVE_INFINITY;
        }
        if (f == Float.MAX_VALUE || f == -3.4028235E38f) {
            return (float)Math.pow(2.0, 104.0);
        }
        f = Math.abs(f);
        int hx = Float.floatToRawIntBits(f);
        int hy = Float.floatToRawIntBits(Float.MAX_VALUE);
        if ((hx & Integer.MAX_VALUE) == 0) {
            return Float.intBitsToFloat(hy & Integer.MIN_VALUE | 1);
        }
        hx = hx > 0 ^ hx > hy ? ++hx : --hx;
        return Float.intBitsToFloat(hx) - f;
    }

    public static double copySign(double magnitude, double sign) {
        long magnitudeBits = Double.doubleToRawLongBits(magnitude);
        long signBits = Double.doubleToRawLongBits(sign);
        magnitudeBits = magnitudeBits & Long.MAX_VALUE | signBits & Long.MIN_VALUE;
        return Double.longBitsToDouble(magnitudeBits);
    }

    public static float copySign(float magnitude, float sign) {
        int magnitudeBits = Float.floatToRawIntBits(magnitude);
        int signBits = Float.floatToRawIntBits(sign);
        magnitudeBits = magnitudeBits & Integer.MAX_VALUE | signBits & Integer.MIN_VALUE;
        return Float.intBitsToFloat(magnitudeBits);
    }

    public static int getExponent(float f) {
        int bits = Float.floatToRawIntBits(f);
        bits = (bits & 0x7F800000) >> 23;
        return bits - 127;
    }

    public static int getExponent(double d) {
        long bits = Double.doubleToRawLongBits(d);
        bits = (bits & 0x7FF0000000000000L) >> 52;
        return (int)bits - 1023;
    }

    public static double nextAfter(double start, double direction) {
        if (start == 0.0 && direction == 0.0) {
            return direction;
        }
        return Math.nextafter(start, direction);
    }

    public static float nextAfter(float start, double direction) {
        if (Float.isNaN(start) || Double.isNaN(direction)) {
            return Float.NaN;
        }
        if (start == 0.0f && direction == 0.0) {
            return (float)direction;
        }
        if (start == Float.MIN_VALUE && direction < (double)start || start == -1.4E-45f && direction > (double)start) {
            return start > 0.0f ? 0.0f : -0.0f;
        }
        if (Float.isInfinite(start) && direction != (double)start) {
            return start > 0.0f ? Float.MAX_VALUE : -3.4028235E38f;
        }
        if (start == Float.MAX_VALUE && direction > (double)start || start == -3.4028235E38f && direction < (double)start) {
            return start > 0.0f ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (direction > (double)start) {
            if (start > 0.0f) {
                return Float.intBitsToFloat(Float.floatToIntBits(start) + 1);
            }
            if (start < 0.0f) {
                return Float.intBitsToFloat(Float.floatToIntBits(start) - 1);
            }
            return Float.MIN_VALUE;
        }
        if (direction < (double)start) {
            if (start > 0.0f) {
                return Float.intBitsToFloat(Float.floatToIntBits(start) - 1);
            }
            if (start < 0.0f) {
                return Float.intBitsToFloat(Float.floatToIntBits(start) + 1);
            }
            return -1.4E-45f;
        }
        return (float)direction;
    }

    public static double nextUp(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == 0.0) {
            return Double.MIN_VALUE;
        }
        if (d > 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d) + 1L);
        }
        return Double.longBitsToDouble(Double.doubleToLongBits(d) - 1L);
    }

    public static float nextUp(float f) {
        if (Float.isNaN(f)) {
            return Float.NaN;
        }
        if (f == Float.POSITIVE_INFINITY) {
            return Float.POSITIVE_INFINITY;
        }
        if (f == 0.0f) {
            return Float.MIN_VALUE;
        }
        if (f > 0.0f) {
            return Float.intBitsToFloat(Float.floatToIntBits(f) + 1);
        }
        return Float.intBitsToFloat(Float.floatToIntBits(f) - 1);
    }

    public static double scalb(double d, int scaleFactor) {
        long result;
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            return d;
        }
        long bits = Double.doubleToLongBits(d);
        long sign = bits & Long.MIN_VALUE;
        long factor = ((bits & 0x7FF0000000000000L) >> 52) - 1023L + (long)scaleFactor;
        int subNormalFactor = Long.numberOfLeadingZeros(bits & Long.MAX_VALUE) - 12;
        if (subNormalFactor < 0) {
            subNormalFactor = 0;
        } else {
            factor -= (long)subNormalFactor;
        }
        if (factor > 1023L) {
            return d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (factor <= -1023L) {
            long digits = factor + 1023L + (long)subNormalFactor;
            result = Math.abs(d) < Double.MIN_NORMAL ? Math.shiftLongBits(bits & 0xFFFFFFFFFFFFFL, digits) : Math.shiftLongBits(bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L, digits - 1L);
        } else {
            result = Math.abs(d) >= Double.MIN_NORMAL ? factor + 1023L << 52 | bits & 0xFFFFFFFFFFFFFL : factor + 1023L << 52 | bits << subNormalFactor + 1 & 0xFFFFFFFFFFFFFL;
        }
        return Double.longBitsToDouble(result | sign);
    }

    public static float scalb(float d, int scaleFactor) {
        int result;
        if (Float.isNaN(d) || Float.isInfinite(d) || d == 0.0f) {
            return d;
        }
        int bits = Float.floatToIntBits(d);
        int sign = bits & Integer.MIN_VALUE;
        int factor = ((bits & 0x7F800000) >> 23) - 127 + scaleFactor;
        int subNormalFactor = Integer.numberOfLeadingZeros(bits & Integer.MAX_VALUE) - 9;
        if (subNormalFactor < 0) {
            subNormalFactor = 0;
        } else {
            factor -= subNormalFactor;
        }
        if (factor > 127) {
            return d > 0.0f ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (factor <= -127) {
            int digits = factor + 127 + subNormalFactor;
            result = Math.abs(d) < Float.MIN_NORMAL ? Math.shiftIntBits(bits & 0x7FFFFF, digits) : Math.shiftIntBits(bits & 0x7FFFFF | 0x800000, digits - 1);
        } else {
            result = Math.abs(d) >= Float.MIN_NORMAL ? factor + 127 << 23 | bits & 0x7FFFFF : factor + 127 << 23 | bits << subNormalFactor + 1 & 0x7FFFFF;
        }
        return Float.intBitsToFloat(result | sign);
    }

    private static int shiftIntBits(int bits, int digits) {
        boolean halfBit;
        if (digits > 0) {
            return bits << digits;
        }
        int absDigits = -digits;
        if (Integer.numberOfLeadingZeros(bits & Integer.MAX_VALUE) > 32 - absDigits) {
            return 0;
        }
        int ret = bits >> absDigits;
        boolean bl = halfBit = (bits >> absDigits - 1 & 1) == 1;
        if (halfBit) {
            if (Integer.numberOfTrailingZeros(bits) < absDigits - 1) {
                ++ret;
            }
            if (Integer.numberOfTrailingZeros(bits) == absDigits - 1 && (ret & 1) == 1) {
                ++ret;
            }
        }
        return ret;
    }

    private static long shiftLongBits(long bits, long digits) {
        boolean halfBit;
        if (digits > 0L) {
            return bits << (int)digits;
        }
        long absDigits = -digits;
        if ((long)Long.numberOfLeadingZeros(bits & Long.MAX_VALUE) > 64L - absDigits) {
            return 0L;
        }
        long ret = bits >> (int)absDigits;
        boolean bl = halfBit = (bits >> (int)(absDigits - 1L) & 1L) == 1L;
        if (halfBit) {
            if ((long)Long.numberOfTrailingZeros(bits) < absDigits - 1L) {
                ++ret;
            }
            if ((long)Long.numberOfTrailingZeros(bits) == absDigits - 1L && (ret & 1L) == 1L) {
                ++ret;
            }
        }
        return ret;
    }
}

