/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;

public class Random
implements Serializable {
    private static final long serialVersionUID = 3905348978240129619L;
    private static final long multiplier = 25214903917L;
    private boolean haveNextNextGaussian;
    private long seed;
    private double nextNextGaussian;

    public Random() {
        this.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
    }

    public Random(long seed) {
        this.setSeed(seed);
    }

    protected synchronized int next(int bits) {
        this.seed = this.seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(this.seed >>> 48 - bits);
    }

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public void nextBytes(byte[] buf) {
        int rand = 0;
        int count = 0;
        int loop = 0;
        while (count < buf.length) {
            if (loop == 0) {
                rand = this.nextInt();
                loop = 3;
            } else {
                --loop;
            }
            buf[count++] = (byte)rand;
            rand >>= 8;
        }
    }

    public double nextDouble() {
        return (double)(((long)this.next(26) << 27) + (long)this.next(27)) / 9.007199254740992E15;
    }

    public float nextFloat() {
        return (float)this.next(24) / 1.6777216E7f;
    }

    public synchronized double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        while ((s = (v1 = 2.0 * this.nextDouble() - 1.0) * v1 + (v2 = 2.0 * this.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        this.nextNextGaussian = v2 * multiplier;
        this.haveNextNextGaussian = true;
        return v1 * multiplier;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0: " + n);
        }
        if ((n & -n) == n) {
            return (int)((long)n * (long)this.next(31) >> 31);
        }
        while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
        }
        return val;
    }

    public long nextLong() {
        return ((long)this.next(32) << 32) + (long)this.next(32);
    }

    public synchronized void setSeed(long seed) {
        this.seed = (seed ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        this.haveNextNextGaussian = false;
    }
}

