/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.security.CodeSigner;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.security.auth.x500.X500Principal;

public class JarEntry
extends ZipEntry {
    private Attributes attributes;
    JarFile parentJar;
    CodeSigner[] signers;
    private CertificateFactory factory;
    private boolean isFactoryChecked = false;

    public JarEntry(String name) {
        super(name);
    }

    public JarEntry(ZipEntry entry) {
        super(entry);
    }

    public Attributes getAttributes() throws IOException {
        if (this.attributes != null || this.parentJar == null) {
            return this.attributes;
        }
        Manifest manifest = this.parentJar.getManifest();
        if (manifest == null) {
            return null;
        }
        this.attributes = manifest.getAttributes(this.getName());
        return this.attributes;
    }

    public Certificate[] getCertificates() {
        if (this.parentJar == null) {
            return null;
        }
        JarVerifier jarVerifier = this.parentJar.verifier;
        if (jarVerifier == null) {
            return null;
        }
        return jarVerifier.getCertificates(this.getName());
    }

    void setAttributes(Attributes attrib) {
        this.attributes = attrib;
    }

    public JarEntry(JarEntry je) {
        super(je);
        this.parentJar = je.parentJar;
        this.attributes = je.attributes;
        this.signers = je.signers;
    }

    public CodeSigner[] getCodeSigners() {
        if (this.signers == null) {
            this.signers = this.getCodeSigners(this.getCertificates());
        }
        if (this.signers == null) {
            return null;
        }
        CodeSigner[] tmp = new CodeSigner[this.signers.length];
        System.arraycopy((Object)this.signers, 0, (Object)tmp, 0, tmp.length);
        return tmp;
    }

    private CodeSigner[] getCodeSigners(Certificate[] certs) {
        if (certs == null) {
            return null;
        }
        X500Principal prevIssuer = null;
        ArrayList<Certificate> list = new ArrayList<Certificate>(certs.length);
        ArrayList<CodeSigner> asigners = new ArrayList<CodeSigner>();
        for (Certificate element : certs) {
            X500Principal subj;
            if (!(element instanceof X509Certificate)) continue;
            X509Certificate x509 = (X509Certificate)element;
            if (prevIssuer != null && !prevIssuer.equals(subj = x509.getSubjectX500Principal())) {
                this.addCodeSigner(asigners, list);
                list.clear();
            }
            prevIssuer = x509.getIssuerX500Principal();
            list.add(x509);
        }
        if (!list.isEmpty()) {
            this.addCodeSigner(asigners, list);
        }
        if (asigners.isEmpty()) {
            return null;
        }
        CodeSigner[] tmp = new CodeSigner[asigners.size()];
        asigners.toArray(tmp);
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCodeSigner(ArrayList<CodeSigner> asigners, List<Certificate> list) {
        CertPath certPath = null;
        if (!this.isFactoryChecked) {
            try {
                this.factory = CertificateFactory.getInstance("X.509");
            }
            catch (CertificateException certificateException) {
            }
            finally {
                this.isFactoryChecked = true;
            }
        }
        if (this.factory == null) {
            return;
        }
        try {
            certPath = this.factory.generateCertPath(list);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (certPath != null) {
            asigners.add(new CodeSigner(certPath, null));
        }
    }
}

