/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1OctetString;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.ExtensionValue;
import org.apache.harmony.security.x509.GeneralName;
import org.apache.harmony.security.x509.GeneralNames;
import org.apache.harmony.security.x509.GeneralSubtree;
import org.apache.harmony.security.x509.GeneralSubtrees;

public final class NameConstraints
extends ExtensionValue {
    private final GeneralSubtrees permittedSubtrees;
    private final GeneralSubtrees excludedSubtrees;
    private byte[] encoding;
    private ArrayList<GeneralName>[] permitted_names;
    private ArrayList<GeneralName>[] excluded_names;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{new ASN1Implicit(0, GeneralSubtrees.ASN1), new ASN1Implicit(1, GeneralSubtrees.ASN1)}){
        {
            this.setOptional(0);
            this.setOptional(1);
        }

        @Override
        protected Object getDecodedObject(BerInputStream in) {
            Object[] values = (Object[])in.content;
            return new NameConstraints((GeneralSubtrees)values[0], (GeneralSubtrees)values[1], in.getEncoded());
        }

        @Override
        protected void getValues(Object object, Object[] values) {
            NameConstraints nc = (NameConstraints)object;
            values[0] = nc.permittedSubtrees;
            values[1] = nc.excludedSubtrees;
        }
    };

    public NameConstraints(GeneralSubtrees permittedSubtrees, GeneralSubtrees excludedSubtrees) {
        List<GeneralSubtree> es;
        List<GeneralSubtree> ps;
        if (permittedSubtrees != null && ((ps = permittedSubtrees.getSubtrees()) == null || ps.isEmpty())) {
            throw new IllegalArgumentException("permittedSubtrees are empty");
        }
        if (excludedSubtrees != null && ((es = excludedSubtrees.getSubtrees()) == null || es.isEmpty())) {
            throw new IllegalArgumentException("excludedSubtrees are empty");
        }
        this.permittedSubtrees = permittedSubtrees;
        this.excludedSubtrees = excludedSubtrees;
    }

    private NameConstraints(GeneralSubtrees permittedSubtrees, GeneralSubtrees excludedSubtrees, byte[] encoding) {
        this(permittedSubtrees, excludedSubtrees);
        this.encoding = encoding;
    }

    public static NameConstraints decode(byte[] encoding) throws IOException {
        return (NameConstraints)ASN1.decode(encoding);
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    private void prepareNames() {
        int tag;
        GeneralName name;
        this.permitted_names = new ArrayList[9];
        if (this.permittedSubtrees != null) {
            for (GeneralSubtree generalSubtree : this.permittedSubtrees.getSubtrees()) {
                name = generalSubtree.getBase();
                tag = name.getTag();
                if (this.permitted_names[tag] == null) {
                    this.permitted_names[tag] = new ArrayList();
                }
                this.permitted_names[tag].add(name);
            }
        }
        this.excluded_names = new ArrayList[9];
        if (this.excludedSubtrees != null) {
            for (GeneralSubtree generalSubtree : this.excludedSubtrees.getSubtrees()) {
                name = generalSubtree.getBase();
                tag = name.getTag();
                if (this.excluded_names[tag] == null) {
                    this.excluded_names[tag] = new ArrayList();
                }
                this.excluded_names[tag].add(name);
            }
        }
    }

    private byte[] getExtensionValue(X509Certificate cert, String OID) {
        try {
            byte[] bytes = cert.getExtensionValue(OID);
            if (bytes == null) {
                return null;
            }
            return (byte[])ASN1OctetString.getInstance().decode(bytes);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isAcceptable(X509Certificate cert) {
        ArrayList<GeneralName> names;
        if (this.permitted_names == null) {
            this.prepareNames();
        }
        byte[] bytes = this.getExtensionValue(cert, "2.5.29.17");
        try {
            names = bytes == null ? new ArrayList(1) : ((GeneralNames)GeneralNames.ASN1.decode(bytes)).getNames();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (this.excluded_names[4] != null || this.permitted_names[4] != null) {
            try {
                names.add(new GeneralName(4, cert.getSubjectX500Principal().getName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.isAcceptable(names);
    }

    public boolean isAcceptable(List<GeneralName> names) {
        if (this.permitted_names == null) {
            this.prepareNames();
        }
        boolean[] types_presented = new boolean[9];
        boolean[] permitted_found = new boolean[9];
        for (GeneralName name : names) {
            int i;
            int type = name.getTag();
            if (this.excluded_names[type] != null) {
                for (i = 0; i < this.excluded_names[type].size(); ++i) {
                    if (!this.excluded_names[type].get(i).isAcceptable(name)) continue;
                    return false;
                }
            }
            if (this.permitted_names[type] == null || permitted_found[type]) continue;
            types_presented[type] = true;
            for (i = 0; i < this.permitted_names[type].size(); ++i) {
                if (!this.permitted_names[type].get(i).isAcceptable(name)) continue;
                permitted_found[type] = true;
            }
        }
        for (int type = 0; type < 9; ++type) {
            if (!types_presented[type] || permitted_found[type]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dumpValue(StringBuilder sb, String prefix) {
        sb.append(prefix).append("Name Constraints: [\n");
        if (this.permittedSubtrees != null) {
            sb.append(prefix).append("  Permitted: [\n");
            for (GeneralSubtree generalSubtree : this.permittedSubtrees.getSubtrees()) {
                generalSubtree.dumpValue(sb, prefix + "    ");
            }
            sb.append(prefix).append("  ]\n");
        }
        if (this.excludedSubtrees != null) {
            sb.append(prefix).append("  Excluded: [\n");
            for (GeneralSubtree generalSubtree : this.excludedSubtrees.getSubtrees()) {
                generalSubtree.dumpValue(sb, prefix + "    ");
            }
            sb.append(prefix).append("  ]\n");
        }
        sb.append('\n').append(prefix).append("]\n");
    }
}

