/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro;

import org.robovm.rt.bro.annotation.MarshalsValue;

public class EnumMarshalers {

    public static class AsIntMarshaler {
        @MarshalsValue
        public static <T extends Enum<T>> T toObject(Class<T> cls, int ordinal, long flags) {
            Enum[] values = Enum.getSharedConstants(cls);
            if (values.length == 0) {
                throw new AssertionError((Object)"Enum class has no values!");
            }
            if (ordinal < 0 || ordinal >= values.length) {
                Class<?> enumType = values[0].getClass();
                throw new IllegalArgumentException("No constant with ordinal " + ordinal + " in " + enumType.getName());
            }
            return (T)values[ordinal];
        }

        @MarshalsValue
        public static int toNative(Enum<?> v, long flags) {
            return v.ordinal();
        }
    }
}

