/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.bouncycastle.math.ec;

import com.android.org.bouncycastle.math.ec.ECConstants;
import com.android.org.bouncycastle.math.ec.ECFieldElement;
import com.android.org.bouncycastle.math.ec.ECPoint;
import com.android.org.bouncycastle.math.ec.Tnaf;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECCurve {
    ECFieldElement a;
    ECFieldElement b;

    public abstract int getFieldSize();

    public abstract ECFieldElement fromBigInteger(BigInteger var1);

    public abstract ECPoint createPoint(BigInteger var1, BigInteger var2, boolean var3);

    public abstract ECPoint getInfinity();

    public ECFieldElement getA() {
        return this.a;
    }

    public ECFieldElement getB() {
        return this.b;
    }

    protected abstract ECPoint decompressPoint(int var1, BigInteger var2);

    public ECPoint decodePoint(byte[] encoded) {
        ECPoint p = null;
        int expectedLength = (this.getFieldSize() + 7) / 8;
        switch (encoded[0]) {
            case 0: {
                if (encoded.length != 1) {
                    throw new IllegalArgumentException("Incorrect length for infinity encoding");
                }
                p = this.getInfinity();
                break;
            }
            case 2: 
            case 3: {
                if (encoded.length != expectedLength + 1) {
                    throw new IllegalArgumentException("Incorrect length for compressed encoding");
                }
                int yTilde = encoded[0] & 1;
                BigInteger X1 = ECCurve.fromArray(encoded, 1, expectedLength);
                p = this.decompressPoint(yTilde, X1);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                if (encoded.length != 2 * expectedLength + 1) {
                    throw new IllegalArgumentException("Incorrect length for uncompressed/hybrid encoding");
                }
                BigInteger X1 = ECCurve.fromArray(encoded, 1, expectedLength);
                BigInteger Y1 = ECCurve.fromArray(encoded, 1 + expectedLength, expectedLength);
                p = this.createPoint(X1, Y1, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid point encoding 0x" + Integer.toString(encoded[0], 16));
            }
        }
        return p;
    }

    private static BigInteger fromArray(byte[] buf, int off, int length) {
        byte[] mag = new byte[length];
        System.arraycopy((Object)buf, off, (Object)mag, 0, length);
        return new BigInteger(1, mag);
    }

    public static class F2m
    extends ECCurve {
        private int m;
        private int k1;
        private int k2;
        private int k3;
        private BigInteger n;
        private BigInteger h;
        private ECPoint.F2m infinity;
        private byte mu = 0;
        private BigInteger[] si = null;

        public F2m(int m, int k, BigInteger a, BigInteger b) {
            this(m, k, 0, 0, a, b, null, null);
        }

        public F2m(int m, int k, BigInteger a, BigInteger b, BigInteger n, BigInteger h) {
            this(m, k, 0, 0, a, b, n, h);
        }

        public F2m(int m, int k1, int k2, int k3, BigInteger a, BigInteger b) {
            this(m, k1, k2, k3, a, b, null, null);
        }

        public F2m(int m, int k1, int k2, int k3, BigInteger a, BigInteger b, BigInteger n, BigInteger h) {
            this.m = m;
            this.k1 = k1;
            this.k2 = k2;
            this.k3 = k3;
            this.n = n;
            this.h = h;
            if (k1 == 0) {
                throw new IllegalArgumentException("k1 must be > 0");
            }
            if (k2 == 0) {
                if (k3 != 0) {
                    throw new IllegalArgumentException("k3 must be 0 if k2 == 0");
                }
            } else {
                if (k2 <= k1) {
                    throw new IllegalArgumentException("k2 must be > k1");
                }
                if (k3 <= k2) {
                    throw new IllegalArgumentException("k3 must be > k2");
                }
            }
            this.a = this.fromBigInteger(a);
            this.b = this.fromBigInteger(b);
            this.infinity = new ECPoint.F2m(this, null, null);
        }

        @Override
        public int getFieldSize() {
            return this.m;
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger x) {
            return new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, x);
        }

        @Override
        public ECPoint createPoint(BigInteger x, BigInteger y, boolean withCompression) {
            return new ECPoint.F2m(this, this.fromBigInteger(x), this.fromBigInteger(y), withCompression);
        }

        @Override
        public ECPoint getInfinity() {
            return this.infinity;
        }

        public boolean isKoblitz() {
            return this.n != null && this.h != null && (this.a.toBigInteger().equals(ECConstants.ZERO) || this.a.toBigInteger().equals(ECConstants.ONE)) && this.b.toBigInteger().equals(ECConstants.ONE);
        }

        synchronized byte getMu() {
            if (this.mu == 0) {
                this.mu = Tnaf.getMu(this);
            }
            return this.mu;
        }

        synchronized BigInteger[] getSi() {
            if (this.si == null) {
                this.si = Tnaf.getSi(this);
            }
            return this.si;
        }

        @Override
        protected ECPoint decompressPoint(int yTilde, BigInteger X1) {
            ECFieldElement xp = this.fromBigInteger(X1);
            ECFieldElement yp = null;
            if (xp.toBigInteger().equals(ECConstants.ZERO)) {
                yp = (ECFieldElement.F2m)this.b;
                for (int i = 0; i < this.m - 1; ++i) {
                    yp = ((ECFieldElement)yp).square();
                }
            } else {
                int zBit;
                ECFieldElement beta = xp.add(this.a).add(this.b.multiply(xp.square().invert()));
                ECFieldElement z = this.solveQuadradicEquation(beta);
                if (z == null) {
                    throw new IllegalArgumentException("Invalid point compression");
                }
                int n = zBit = z.toBigInteger().testBit(0) ? 1 : 0;
                if (zBit != yTilde) {
                    z = z.add(this.fromBigInteger(ECConstants.ONE));
                }
                yp = xp.multiply(z);
            }
            return new ECPoint.F2m(this, xp, yp, true);
        }

        private ECFieldElement solveQuadradicEquation(ECFieldElement beta) {
            ECFieldElement.F2m zeroElement = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, ECConstants.ZERO);
            if (beta.toBigInteger().equals(ECConstants.ZERO)) {
                return zeroElement;
            }
            ECFieldElement z = null;
            ECFieldElement gamma = zeroElement;
            Random rand = new Random();
            do {
                ECFieldElement.F2m t = new ECFieldElement.F2m(this.m, this.k1, this.k2, this.k3, new BigInteger(this.m, rand));
                z = zeroElement;
                ECFieldElement w = beta;
                for (int i = 1; i <= this.m - 1; ++i) {
                    ECFieldElement w2 = w.square();
                    z = ((ECFieldElement)z).square().add(w2.multiply(t));
                    w = w2.add(beta);
                }
                if (w.toBigInteger().equals(ECConstants.ZERO)) continue;
                return null;
            } while ((gamma = ((ECFieldElement)z).square().add(z)).toBigInteger().equals(ECConstants.ZERO));
            return z;
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (!(anObject instanceof F2m)) {
                return false;
            }
            F2m other = (F2m)anObject;
            return this.m == other.m && this.k1 == other.k1 && this.k2 == other.k2 && this.k3 == other.k3 && this.a.equals(other.a) && this.b.equals(other.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
        }

        public int getM() {
            return this.m;
        }

        public boolean isTrinomial() {
            return this.k2 == 0 && this.k3 == 0;
        }

        public int getK1() {
            return this.k1;
        }

        public int getK2() {
            return this.k2;
        }

        public int getK3() {
            return this.k3;
        }

        public BigInteger getN() {
            return this.n;
        }

        public BigInteger getH() {
            return this.h;
        }
    }

    public static class Fp
    extends ECCurve {
        BigInteger q;
        ECPoint.Fp infinity;

        public Fp(BigInteger q, BigInteger a, BigInteger b) {
            this.q = q;
            this.a = this.fromBigInteger(a);
            this.b = this.fromBigInteger(b);
            this.infinity = new ECPoint.Fp(this, null, null);
        }

        public BigInteger getQ() {
            return this.q;
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        @Override
        public ECFieldElement fromBigInteger(BigInteger x) {
            return new ECFieldElement.Fp(this.q, x);
        }

        @Override
        public ECPoint createPoint(BigInteger x, BigInteger y, boolean withCompression) {
            return new ECPoint.Fp(this, this.fromBigInteger(x), this.fromBigInteger(y), withCompression);
        }

        @Override
        protected ECPoint decompressPoint(int yTilde, BigInteger X1) {
            int bit0;
            ECFieldElement x = this.fromBigInteger(X1);
            ECFieldElement alpha = x.multiply(x.square().add(this.a)).add(this.b);
            ECFieldElement beta = alpha.sqrt();
            if (beta == null) {
                throw new RuntimeException("Invalid point compression");
            }
            BigInteger betaValue = beta.toBigInteger();
            int n = bit0 = betaValue.testBit(0) ? 1 : 0;
            if (bit0 != yTilde) {
                beta = this.fromBigInteger(this.q.subtract(betaValue));
            }
            return new ECPoint.Fp(this, x, beta, true);
        }

        @Override
        public ECPoint getInfinity() {
            return this.infinity;
        }

        public boolean equals(Object anObject) {
            if (anObject == this) {
                return true;
            }
            if (!(anObject instanceof Fp)) {
                return false;
            }
            Fp other = (Fp)anObject;
            return this.q.equals(other.q) && this.a.equals(other.a) && this.b.equals(other.b);
        }

        public int hashCode() {
            return this.a.hashCode() ^ this.b.hashCode() ^ this.q.hashCode();
        }
    }
}

