/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLX509Certificate;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.security.auth.x500.X500Principal;
import libcore.io.IoUtils;

public final class TrustedCertificateStore {
    private static final String PREFIX_SYSTEM = "system:";
    private static final String PREFIX_USER = "user:";
    private static final URI CA_CERTS_DIR_SYSTEM;
    private static final URI CA_CERTS_DIR_ADDED;
    private static final URI CA_CERTS_DIR_DELETED;
    private static final CertificateFactory CERT_FACTORY;
    private final URI systemDir;
    private final URI addedDir;
    private final URI deletedDir;

    public static final boolean isSystem(String alias) {
        return alias.startsWith(PREFIX_SYSTEM);
    }

    public static final boolean isUser(String alias) {
        return alias.startsWith(PREFIX_USER);
    }

    public TrustedCertificateStore() {
        this(CA_CERTS_DIR_SYSTEM, CA_CERTS_DIR_ADDED, CA_CERTS_DIR_DELETED);
    }

    public TrustedCertificateStore(File systemDir, File addedDir, File deletedDir) {
        this.systemDir = systemDir.toURI();
        this.addedDir = addedDir.toURI();
        this.deletedDir = deletedDir.toURI();
    }

    public TrustedCertificateStore(URI systemDir, URI addedDir, URI deletedDir) {
        this.systemDir = systemDir;
        this.addedDir = addedDir;
        this.deletedDir = deletedDir;
    }

    public Certificate getCertificate(String alias) {
        return this.getCertificate(alias, false);
    }

    public Certificate getCertificate(String alias, boolean includeDeletedSystem) {
        URI file = this.fileForAlias(alias);
        if (file == null || TrustedCertificateStore.isUser(alias) && this.isTombstone(file)) {
            return null;
        }
        X509Certificate cert = this.readCertificate(file);
        if (cert == null || TrustedCertificateStore.isSystem(alias) && !includeDeletedSystem && this.isDeletedSystemCertificate(cert)) {
            return null;
        }
        return cert;
    }

    private URI fileForAlias(String alias) {
        URI file;
        if (alias == null) {
            throw new NullPointerException("alias == null");
        }
        if (TrustedCertificateStore.isSystem(alias)) {
            file = this.makeURI(this.systemDir, alias.substring(PREFIX_SYSTEM.length()));
        } else if (TrustedCertificateStore.isUser(alias)) {
            file = this.makeURI(this.addedDir, alias.substring(PREFIX_USER.length()));
        } else {
            return null;
        }
        if (!this.exists(file) || this.isTombstone(file)) {
            return null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTombstone(URI file) {
        if ("file".equals(file.getScheme())) {
            return new File(file).length() == 0L;
        }
        InputStream in = null;
        try {
            in = file.toURL().openStream();
            boolean bl = in.read() == -1;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            IoUtils.closeQuietly(in);
        }
        return false;
    }

    private boolean isFile(URI file) {
        if ("file".equals(file.getScheme())) {
            return new File(file).isFile();
        }
        if ("jar".equals(file.getScheme())) {
            try {
                JarURLConnection conn = (JarURLConnection)file.toURL().openConnection();
                return conn.getJarEntry() != null && !conn.getJarEntry().getName().endsWith("/");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean exists(URI file) {
        if ("file".equals(file.getScheme())) {
            return new File(file).exists();
        }
        if ("jar".equals(file.getScheme())) {
            try {
                JarURLConnection conn = (JarURLConnection)file.toURL().openConnection();
                return conn.getJarEntry() != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private String getName(URI file) {
        if ("jar".equals(file.getScheme())) {
            String uriStr = file.getSchemeSpecificPart();
            return uriStr.substring(uriStr.lastIndexOf(47) + 1);
        }
        return file.getPath().substring(file.getPath().lastIndexOf(47) + 1);
    }

    private String[] list(URI file) {
        if ("file".equals(file.getScheme())) {
            return new File(file).list();
        }
        if ("jar".equals(file.getScheme())) {
            try {
                String path;
                JarURLConnection conn = (JarURLConnection)file.toURL().openConnection();
                JarFile jarFile = conn.getJarFile();
                String uriStr = file.toString();
                if (!uriStr.endsWith("/")) {
                    uriStr = uriStr + "/";
                }
                if ((path = uriStr.substring(uriStr.lastIndexOf(33) + 1)).startsWith("/")) {
                    path = path.substring(1);
                }
                Enumeration<JarEntry> en = jarFile.entries();
                ArrayList<String> result = new ArrayList<String>();
                while (en.hasMoreElements()) {
                    int lastSlash;
                    JarEntry entry = en.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(path) || name.endsWith("/") || (lastSlash = name.lastIndexOf(47)) != path.length() - 1) continue;
                    result.add(name.substring(lastSlash + 1));
                }
                return result.toArray(new String[result.size()]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private long lastModified(URI file) {
        if ("file".equals(file.getScheme())) {
            return new File(file).lastModified();
        }
        if ("jar".equals(file.getScheme())) {
            try {
                JarURLConnection conn = (JarURLConnection)file.toURL().openConnection();
                return conn.getJarEntry().getTime();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private X509Certificate readCertificate(URI file) {
        if (!this.isFile(file)) {
            return null;
        }
        InputStream is = null;
        try {
            is = "file".equals(file.getScheme()) ? new BufferedInputStream(new FileInputStream(new File(file))) : file.toURL().openStream();
            X509Certificate x509Certificate = (X509Certificate)CERT_FACTORY.generateCertificate(is);
            IoUtils.closeQuietly(is);
            return x509Certificate;
        }
        catch (IOException e) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
        }
        catch (CertificateException e2) {
            X509Certificate x509Certificate = null;
            return x509Certificate;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCertificate(URI uri, X509Certificate cert) throws IOException, CertificateException {
        File file = new File(uri);
        File dir = file.getParentFile();
        dir.mkdirs();
        dir.setReadable(true, false);
        dir.setExecutable(true, false);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            os.write(cert.getEncoded());
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(os);
            throw throwable;
        }
        IoUtils.closeQuietly(os);
        file.setReadable(true, false);
    }

    private boolean isDeletedSystemCertificate(X509Certificate x) {
        return this.exists(this.getCertificateFile(this.deletedDir, x));
    }

    public Date getCreationDate(String alias) {
        if (!this.containsAlias(alias)) {
            return null;
        }
        URI file = this.fileForAlias(alias);
        if (file == null) {
            return null;
        }
        long time = this.lastModified(file);
        if (time == 0L) {
            return null;
        }
        return new Date(time);
    }

    public Set<String> aliases() {
        HashSet<String> result = new HashSet<String>();
        this.addAliases(result, PREFIX_USER, this.addedDir);
        this.addAliases(result, PREFIX_SYSTEM, this.systemDir);
        return result;
    }

    public Set<String> userAliases() {
        HashSet<String> result = new HashSet<String>();
        this.addAliases(result, PREFIX_USER, this.addedDir);
        return result;
    }

    private void addAliases(Set<String> result, String prefix, URI dir) {
        String[] files = this.list(dir);
        if (files == null) {
            return;
        }
        for (String filename : files) {
            String alias = prefix + filename;
            if (!this.containsAlias(alias)) continue;
            result.add(alias);
        }
    }

    public Set<String> allSystemAliases() {
        HashSet<String> result = new HashSet<String>();
        String[] files = this.list(this.systemDir);
        if (files == null) {
            return result;
        }
        for (String filename : files) {
            String alias = PREFIX_SYSTEM + filename;
            if (!this.containsAlias(alias, true)) continue;
            result.add(alias);
        }
        return result;
    }

    public boolean containsAlias(String alias) {
        return this.containsAlias(alias, false);
    }

    private boolean containsAlias(String alias, boolean includeDeletedSystem) {
        return this.getCertificate(alias, includeDeletedSystem) != null;
    }

    public String getCertificateAlias(Certificate c) {
        if (c == null || !(c instanceof X509Certificate)) {
            return null;
        }
        X509Certificate x = (X509Certificate)c;
        URI user = this.getCertificateFile(this.addedDir, x);
        if (this.exists(user)) {
            return PREFIX_USER + this.getName(user);
        }
        if (this.isDeletedSystemCertificate(x)) {
            return null;
        }
        URI system = this.getCertificateFile(this.systemDir, x);
        if (this.exists(system)) {
            return PREFIX_SYSTEM + this.getName(system);
        }
        return null;
    }

    public boolean isUserAddedCertificate(X509Certificate cert) {
        return this.exists(this.getCertificateFile(this.addedDir, cert));
    }

    private URI getCertificateFile(URI dir, final X509Certificate x) {
        CertSelector selector = new CertSelector(){

            @Override
            public boolean match(X509Certificate cert) {
                return cert.equals(x);
            }
        };
        return this.findCert(dir, x.getSubjectX500Principal(), selector, URI.class);
    }

    public boolean isTrustAnchor(final X509Certificate c) {
        CertSelector selector = new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                return ca.getPublicKey().equals(c.getPublicKey());
            }
        };
        boolean user = this.findCert(this.addedDir, c.getSubjectX500Principal(), selector, Boolean.class);
        if (user) {
            return true;
        }
        X509Certificate system = this.findCert(this.systemDir, c.getSubjectX500Principal(), selector, X509Certificate.class);
        return system != null && !this.isDeletedSystemCertificate(system);
    }

    public X509Certificate findIssuer(final X509Certificate c) {
        CertSelector selector = new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                try {
                    c.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        };
        X500Principal issuer = c.getIssuerX500Principal();
        X509Certificate user = this.findCert(this.addedDir, issuer, selector, X509Certificate.class);
        if (user != null) {
            return user;
        }
        X509Certificate system = this.findCert(this.systemDir, issuer, selector, X509Certificate.class);
        if (system != null && !this.isDeletedSystemCertificate(system)) {
            return system;
        }
        return null;
    }

    private static boolean isSelfIssuedCertificate(OpenSSLX509Certificate cert) {
        long ctx = cert.getContext();
        return NativeCrypto.X509_check_issued(ctx, ctx) == 0;
    }

    private static OpenSSLX509Certificate convertToOpenSSLIfNeeded(X509Certificate cert) throws CertificateException {
        if (cert == null) {
            return null;
        }
        if (cert instanceof OpenSSLX509Certificate) {
            return (OpenSSLX509Certificate)cert;
        }
        try {
            return OpenSSLX509Certificate.fromX509Der(cert.getEncoded());
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    public List<X509Certificate> getCertificateChain(X509Certificate leaf) throws CertificateException {
        OpenSSLX509Certificate issuer;
        OpenSSLX509Certificate cert;
        ArrayList<OpenSSLX509Certificate> chain = new ArrayList<OpenSSLX509Certificate>();
        chain.add(TrustedCertificateStore.convertToOpenSSLIfNeeded(leaf));
        int i = 0;
        while (!TrustedCertificateStore.isSelfIssuedCertificate(cert = (OpenSSLX509Certificate)chain.get(i)) && (issuer = TrustedCertificateStore.convertToOpenSSLIfNeeded(this.findIssuer(cert))) != null) {
            chain.add(issuer);
            ++i;
        }
        return new ArrayList<X509Certificate>(chain);
    }

    private <T> T findCert(URI dir, X500Principal subject, CertSelector selector, Class<T> desiredReturnType) {
        String hash = this.hash(subject);
        int index = 0;
        while (true) {
            X509Certificate cert;
            URI file;
            if (!this.isFile(file = this.file(dir, hash, index))) {
                if (desiredReturnType == Boolean.class) {
                    return (T)Boolean.FALSE;
                }
                if (desiredReturnType == URI.class) {
                    return (T)file;
                }
                return null;
            }
            if (!this.isTombstone(file) && (cert = this.readCertificate(file)) != null && selector.match(cert)) {
                if (desiredReturnType == X509Certificate.class) {
                    return (T)cert;
                }
                if (desiredReturnType == Boolean.class) {
                    return (T)Boolean.TRUE;
                }
                if (desiredReturnType == URI.class) {
                    return (T)file;
                }
                throw new AssertionError();
            }
            ++index;
        }
    }

    private String hash(X500Principal name) {
        int hash = NativeCrypto.X509_NAME_hash_old(name);
        return IntegralToString.intToHexString(hash, false, 8);
    }

    private URI makeURI(URI base, String file) {
        StringBuilder sb = new StringBuilder(base.toString());
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append(file);
        try {
            return new URI(sb.toString());
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private URI file(URI dir, String hash, int index) {
        return this.makeURI(dir, hash + "." + index);
    }

    public void installCertificate(X509Certificate cert) throws IOException, CertificateException {
        if (cert == null) {
            throw new NullPointerException("cert == null");
        }
        URI system = this.getCertificateFile(this.systemDir, cert);
        if (this.exists(system)) {
            URI deleted = this.getCertificateFile(this.deletedDir, cert);
            if (this.exists(deleted)) {
                if (!"file".equals(deleted.getScheme()) || !new File(deleted).delete()) {
                    throw new IOException("Could not remove " + deleted);
                }
                return;
            }
            return;
        }
        URI user = this.getCertificateFile(this.addedDir, cert);
        if (this.exists(user)) {
            return;
        }
        this.writeCertificate(user, cert);
    }

    public void deleteCertificateEntry(String alias) throws IOException, CertificateException {
        if (alias == null) {
            return;
        }
        URI file = this.fileForAlias(alias);
        if (file == null) {
            return;
        }
        if (TrustedCertificateStore.isSystem(alias)) {
            X509Certificate cert = this.readCertificate(file);
            if (cert == null) {
                return;
            }
            URI deleted = this.getCertificateFile(this.deletedDir, cert);
            if (this.exists(deleted)) {
                return;
            }
            this.writeCertificate(deleted, cert);
            return;
        }
        if (TrustedCertificateStore.isUser(alias)) {
            new FileOutputStream(new File(file)).close();
            this.removeUnnecessaryTombstones(alias);
            return;
        }
    }

    private void removeUnnecessaryTombstones(String alias) throws IOException {
        URI file;
        int lastTombstoneIndex;
        if (!TrustedCertificateStore.isUser(alias)) {
            throw new AssertionError((Object)alias);
        }
        int dotIndex = alias.lastIndexOf(46);
        if (dotIndex == -1) {
            throw new AssertionError((Object)alias);
        }
        String hash = alias.substring(PREFIX_USER.length(), dotIndex);
        if (this.exists(this.file(this.addedDir, hash, (lastTombstoneIndex = Integer.parseInt(alias.substring(dotIndex + 1))) + 1))) {
            return;
        }
        while (lastTombstoneIndex >= 0 && this.isTombstone(file = this.file(this.addedDir, hash, lastTombstoneIndex))) {
            if (!"file".equals(file.getScheme()) || !new File(file).delete()) {
                throw new IOException("Could not remove " + file);
            }
            --lastTombstoneIndex;
        }
    }

    static {
        String ANDROID_ROOT = System.getenv("ANDROID_ROOT");
        String ANDROID_DATA = System.getenv("ANDROID_DATA");
        if (ANDROID_ROOT != null && ANDROID_DATA != null) {
            CA_CERTS_DIR_SYSTEM = new File(ANDROID_ROOT + "/etc/security/cacerts").toURI();
            CA_CERTS_DIR_ADDED = new File(ANDROID_DATA + "/misc/keychain/cacerts-added").toURI();
            CA_CERTS_DIR_DELETED = new File(ANDROID_DATA + "/misc/keychain/cacerts-removed").toURI();
        } else {
            try {
                CA_CERTS_DIR_SYSTEM = TrustedCertificateStore.class.getResource("/cacerts/").toURILenient();
            }
            catch (URISyntaxException e) {
                throw new AssertionError((Object)e);
            }
            String userHome = System.getProperty("user.home");
            CA_CERTS_DIR_ADDED = new File(userHome + "/keychain/cacerts-added").toURI();
            CA_CERTS_DIR_DELETED = new File(userHome + "/keychain/cacerts-removed").toURI();
        }
        try {
            CERT_FACTORY = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static interface CertSelector {
        public boolean match(X509Certificate var1);
    }
}

