/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Hashtable;
import org.robovm.rt.ReflectionAccess;

public class AccessibleObject
implements AnnotatedElement {
    static final ReflectionAccess REFLECTION_ACCESS = new ReflectionAccess(){

        @Override
        public Method[] clone(Method[] m) {
            if (m.length == 0) {
                return m;
            }
            Method[] result = new Method[m.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new Method(m[i]);
            }
            return result;
        }

        @Override
        public Constructor<?>[] clone(Constructor<?>[] c) {
            if (c.length == 0) {
                return c;
            }
            Constructor[] result = new Constructor[c.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new Constructor(c[i]);
            }
            return result;
        }

        @Override
        public Field[] clone(Field[] f) {
            if (f.length == 0) {
                return f;
            }
            Field[] result = new Field[f.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new Field(f[i]);
            }
            return result;
        }

        @Override
        public Method clone(Method m) {
            return new Method(m);
        }

        @Override
        public Constructor<?> clone(Constructor<?> c) {
            return new Constructor(c);
        }

        @Override
        public Field clone(Field f) {
            return new Field(f);
        }

        @Override
        public boolean equals(Method a, Method b) {
            if (a.getReturnType() != b.getReturnType()) {
                return false;
            }
            if (!a.getName().equals(b.getName())) {
                return false;
            }
            return this.compareClassLists(a.getParameterTypes(false), b.getParameterTypes(false));
        }

        @Override
        public boolean matchParameterTypes(Constructor<?> c, Class<?>[] parameterTypes) {
            return this.compareClassLists(c.getParameterTypes(false), parameterTypes);
        }

        @Override
        public boolean matchParameterTypes(Method m, Class<?>[] parameterTypes) {
            return this.compareClassLists(m.getParameterTypes(false), parameterTypes);
        }

        private boolean compareClassLists(Class<?>[] a, Class<?>[] b) {
            if (a == null) {
                return b == null || b.length == 0;
            }
            int length = a.length;
            if (b == null) {
                return length == 0;
            }
            if (length != b.length) {
                return false;
            }
            for (int i = length - 1; i >= 0; --i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }
    };
    boolean flag = false;
    static Hashtable<String, String> trans = new Hashtable(9);

    public static void setAccessible(AccessibleObject[] objects, boolean flag) {
        for (AccessibleObject object : objects) {
            object.flag = flag;
        }
    }

    protected AccessibleObject() {
    }

    public boolean isAccessible() {
        return this.flag;
    }

    public void setAccessible(boolean flag) {
        this.flag = flag;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return this.getAnnotation(annotationType) != null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getDeclaredAnnotations(true);
    }

    protected Annotation[] getDeclaredAnnotations(boolean copy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        Annotation[] annos = this.getDeclaredAnnotations(false);
        for (int i = annos.length - 1; i >= 0; --i) {
            if (annos[i].annotationType() != annotationType) continue;
            return (T)annos[i];
        }
        return null;
    }

    String getSignature(Class<?> clazz) {
        String result = "";
        String nextType = clazz.getName();
        result = trans.containsKey(nextType) ? trans.get(nextType) : (clazz.isArray() ? "[" + this.getSignature(clazz.getComponentType()) : "L" + nextType + ";");
        return result;
    }

    String toString(Class<?>[] types) {
        StringBuilder result = new StringBuilder();
        if (types.length != 0) {
            this.appendTypeName(result, types[0]);
            for (int i = 1; i < types.length; ++i) {
                result.append(',');
                this.appendTypeName(result, types[i]);
            }
        }
        return result.toString();
    }

    String getSignatureAttribute() {
        throw new UnsupportedOperationException();
    }

    static boolean isSamePackage(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1.getClassLoader() != c2.getClassLoader()) {
            return false;
        }
        String n1 = c1.getName();
        String n2 = c2.getName();
        int dot1 = n1.lastIndexOf(46);
        int dot2 = n2.lastIndexOf(46);
        if (dot1 == -1) {
            return dot2 == -1;
        }
        if (dot1 != dot2) {
            return false;
        }
        return n1.substring(0, dot1).equals(n2.substring(0, dot2));
    }

    static native int getAccessFlags(Class<?> var0);

    static boolean checkAccessibleFast(Member member) {
        int access = member.getModifiers();
        return (AccessibleObject.getAccessFlags(member.getDeclaringClass()) & access & 1) > 0;
    }

    static boolean checkAccessible(Class<?> caller, Member member) {
        Class<?> callee = member.getDeclaringClass();
        if (caller == callee) {
            return true;
        }
        boolean samePackage = false;
        if ((AccessibleObject.getAccessFlags(callee) & 1) == 0 && !(samePackage = AccessibleObject.isSamePackage(caller, callee))) {
            return false;
        }
        int access = member.getModifiers();
        if ((access & 1) > 0) {
            return true;
        }
        if ((access & 2) > 0) {
            return false;
        }
        if ((access & 4) > 0) {
            for (Class<?> sc = caller.getSuperclass(); sc != null; sc = sc.getSuperclass()) {
                if (sc != callee) continue;
                return true;
            }
        }
        return samePackage || AccessibleObject.isSamePackage(caller, callee);
    }

    void appendTypeName(StringBuilder out, Class<?> c) {
        int dimensions = 0;
        while (c.isArray()) {
            c = c.getComponentType();
            ++dimensions;
        }
        out.append(c.getName());
        for (int d = 0; d < dimensions; ++d) {
            out.append("[]");
        }
    }

    void appendArrayGenericType(StringBuilder sb, Type[] types) {
        if (types.length > 0) {
            this.appendGenericType(sb, types[0]);
            for (int i = 1; i < types.length; ++i) {
                sb.append(',');
                this.appendGenericType(sb, types[i]);
            }
        }
    }

    void appendGenericType(StringBuilder sb, Type obj) {
        if (obj instanceof TypeVariable) {
            sb.append(((TypeVariable)obj).getName());
        } else if (obj instanceof ParameterizedType) {
            sb.append(obj.toString());
        } else if (obj instanceof GenericArrayType) {
            Type simplified = ((GenericArrayType)obj).getGenericComponentType();
            this.appendGenericType(sb, simplified);
            sb.append("[]");
        } else if (obj instanceof Class) {
            Class c = (Class)obj;
            if (c.isArray()) {
                int len;
                String[] as = c.getName().split("\\[");
                if (as[len = as.length - 1].length() > 1) {
                    sb.append(as[len].substring(1, as[len].length() - 1));
                } else {
                    char ch = as[len].charAt(0);
                    if (ch == 'I') {
                        sb.append("int");
                    } else if (ch == 'B') {
                        sb.append("byte");
                    } else if (ch == 'J') {
                        sb.append("long");
                    } else if (ch == 'F') {
                        sb.append("float");
                    } else if (ch == 'D') {
                        sb.append("double");
                    } else if (ch == 'S') {
                        sb.append("short");
                    } else if (ch == 'C') {
                        sb.append("char");
                    } else if (ch == 'Z') {
                        sb.append("boolean");
                    } else if (ch == 'V') {
                        sb.append("void");
                    }
                }
                for (int i = 0; i < len; ++i) {
                    sb.append("[]");
                }
            } else {
                sb.append(c.getName());
            }
        }
    }

    static {
        trans.put("byte", "B");
        trans.put("char", "C");
        trans.put("short", "S");
        trans.put("int", "I");
        trans.put("long", "J");
        trans.put("float", "F");
        trans.put("double", "D");
        trans.put("void", "V");
        trans.put("boolean", "Z");
    }
}

