/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import libcore.io.Memory;

public class ModifiedUtf8 {
    public static String decode(byte[] in, char[] out, int offset, int utfSize) throws UTFDataFormatException {
        int count = 0;
        int s = 0;
        while (count < utfSize) {
            byte b;
            if ((out[s] = (char)in[offset + count++]) < '\u0080') {
                ++s;
                continue;
            }
            char a = out[s];
            if ((a & 0xE0) == 192) {
                if (count >= utfSize) {
                    throw new UTFDataFormatException("bad second byte at " + count);
                }
                if (((b = in[offset + count++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte at " + (count - 1));
                }
                out[s++] = (char)((a & 0x1F) << 6 | b & 0x3F);
                continue;
            }
            if ((a & 0xF0) == 224) {
                if (count + 1 >= utfSize) {
                    throw new UTFDataFormatException("bad third byte at " + (count + 1));
                }
                b = in[offset + count++];
                byte c = in[offset + count++];
                if ((b & 0xC0) != 128 || (c & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second or third byte at " + (count - 2));
                }
                out[s++] = (char)((a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F);
                continue;
            }
            throw new UTFDataFormatException("bad byte at " + (count - 1));
        }
        return new String(out, 0, s);
    }

    public static long countBytes(String s, boolean shortLength) throws UTFDataFormatException {
        long result = 0L;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            result = ch != '\u0000' && ch <= '\u007f' ? ++result : (ch <= '\u07ff' ? (result += 2L) : (result += 3L));
            if (!shortLength || result <= 65535L) continue;
            throw new UTFDataFormatException("String more than 65535 UTF bytes long");
        }
        return result;
    }

    public static void encode(byte[] dst, int offset, String s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (ch != '\u0000' && ch <= '\u007f') {
                dst[offset++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                dst[offset++] = (byte)(0xC0 | 0x1F & ch >> 6);
                dst[offset++] = (byte)(0x80 | 0x3F & ch);
                continue;
            }
            dst[offset++] = (byte)(0xE0 | 0xF & ch >> 12);
            dst[offset++] = (byte)(0x80 | 0x3F & ch >> 6);
            dst[offset++] = (byte)(0x80 | 0x3F & ch);
        }
    }

    public static byte[] encode(String s) throws UTFDataFormatException {
        int utfCount = (int)ModifiedUtf8.countBytes(s, true);
        byte[] result = new byte[2 + utfCount];
        Memory.pokeShort(result, 0, (short)utfCount, ByteOrder.BIG_ENDIAN);
        ModifiedUtf8.encode(result, 2, s);
        return result;
    }

    private ModifiedUtf8() {
    }
}

