/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.ManifestReader;
import libcore.io.Streams;

public class Manifest
implements Cloneable {
    static final int LINE_LENGTH_LIMIT = 72;
    private static final byte[] LINE_SEPARATOR = new byte[]{13, 10};
    private static final byte[] VALUE_SEPARATOR = new byte[]{58, 32};
    private static final Field BAIS_BUF = Manifest.getByteArrayInputStreamField("buf");
    private static final Field BAIS_POS = Manifest.getByteArrayInputStreamField("pos");
    private Attributes mainAttributes = new Attributes();
    private HashMap<String, Attributes> entries = new HashMap();
    private HashMap<String, Chunk> chunks;
    private int mainEnd;

    private static Field getByteArrayInputStreamField(String name) {
        try {
            Field f = ByteArrayInputStream.class.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public Manifest() {
    }

    public Manifest(InputStream is) throws IOException {
        this.read(is);
    }

    public Manifest(Manifest man) {
        this.mainAttributes = (Attributes)man.mainAttributes.clone();
        this.entries = (HashMap)((HashMap)man.getEntries()).clone();
    }

    Manifest(InputStream is, boolean readChunks) throws IOException {
        if (readChunks) {
            this.chunks = new HashMap();
        }
        this.read(is);
    }

    public void clear() {
        this.entries.clear();
        this.mainAttributes.clear();
    }

    public Attributes getAttributes(String name) {
        return this.getEntries().get(name);
    }

    public Map<String, Attributes> getEntries() {
        return this.entries;
    }

    public Attributes getMainAttributes() {
        return this.mainAttributes;
    }

    public Object clone() {
        return new Manifest(this);
    }

    public void write(OutputStream os) throws IOException {
        Manifest.write(this, os);
    }

    public void read(InputStream is) throws IOException {
        byte[] buf = is instanceof ByteArrayInputStream ? Manifest.exposeByteArrayInputStreamBytes((ByteArrayInputStream)is) : Streams.readFullyNoClose(is);
        if (buf.length == 0) {
            return;
        }
        byte b = buf[buf.length - 1];
        if (b == 0 || b == 26) {
            buf[buf.length - 1] = 10;
        }
        ManifestReader im = new ManifestReader(buf, this.mainAttributes);
        this.mainEnd = im.getEndOfMainSection();
        im.readEntries(this.entries, this.chunks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] exposeByteArrayInputStreamBytes(ByteArrayInputStream bais) {
        byte[] buffer;
        ByteArrayInputStream byteArrayInputStream = bais;
        synchronized (byteArrayInputStream) {
            int pos;
            byte[] buf;
            try {
                buf = (byte[])BAIS_BUF.get(bais);
                pos = BAIS_POS.getInt(bais);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
            int available = bais.available();
            if (pos == 0 && buf.length == available) {
                buffer = buf;
            } else {
                buffer = new byte[available];
                System.arraycopy((Object)buf, pos, (Object)buffer, 0, available);
            }
            bais.skip(available);
        }
        return buffer;
    }

    public int hashCode() {
        return this.mainAttributes.hashCode() ^ this.getEntries().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!this.mainAttributes.equals(((Manifest)o).mainAttributes)) {
            return false;
        }
        return this.getEntries().equals(((Manifest)o).getEntries());
    }

    Chunk getChunk(String name) {
        return this.chunks.get(name);
    }

    void removeChunks() {
        this.chunks = null;
    }

    int getMainAttributesEnd() {
        return this.mainEnd;
    }

    static void write(Manifest manifest, OutputStream out) throws IOException {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        ByteBuffer buffer = ByteBuffer.allocate(72);
        Attributes.Name versionName = Attributes.Name.MANIFEST_VERSION;
        String version = manifest.mainAttributes.getValue(versionName);
        if (version == null) {
            versionName = Attributes.Name.SIGNATURE_VERSION;
            version = manifest.mainAttributes.getValue(versionName);
        }
        if (version != null) {
            Manifest.writeEntry(out, versionName, version, encoder, buffer);
            for (Attributes.Name name : manifest.mainAttributes.keySet()) {
                if (name.equals(versionName)) continue;
                Manifest.writeEntry(out, name, manifest.mainAttributes.getValue(name), encoder, buffer);
            }
        }
        out.write(LINE_SEPARATOR);
        for (String string : manifest.getEntries().keySet()) {
            Manifest.writeEntry(out, Attributes.Name.NAME, string, encoder, buffer);
            Attributes attributes = manifest.entries.get(string);
            for (Attributes.Name name : attributes.keySet()) {
                Manifest.writeEntry(out, name, attributes.getValue(name), encoder, buffer);
            }
            out.write(LINE_SEPARATOR);
        }
    }

    private static void writeEntry(OutputStream os, Attributes.Name name, String value, CharsetEncoder encoder, ByteBuffer bBuf) throws IOException {
        String nameString = name.getName();
        os.write(nameString.getBytes(StandardCharsets.US_ASCII));
        os.write(VALUE_SEPARATOR);
        encoder.reset();
        bBuf.clear().limit(72 - nameString.length() - 2);
        CharBuffer cBuf = CharBuffer.wrap(value);
        while (true) {
            CoderResult r;
            if (CoderResult.UNDERFLOW == (r = encoder.encode(cBuf, bBuf, true))) {
                r = encoder.flush(bBuf);
            }
            os.write(bBuf.array(), bBuf.arrayOffset(), bBuf.position());
            os.write(LINE_SEPARATOR);
            if (CoderResult.UNDERFLOW == r) break;
            os.write(32);
            bBuf.clear().limit(71);
        }
    }

    static class Chunk {
        int start;
        int end;

        Chunk(int start, int end) {
            this.start = start;
            this.end = end;
        }
    }
}

