/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

public abstract class SSLSocket
extends Socket {
    protected SSLSocket() {
    }

    protected SSLSocket(String host, int port) throws IOException, UnknownHostException {
        super(host, port);
    }

    protected SSLSocket(InetAddress address, int port) throws IOException {
        super(address, port);
    }

    protected SSLSocket(String host, int port, InetAddress clientAddress, int clientPort) throws IOException, UnknownHostException {
        super(host, port, clientAddress, clientPort);
    }

    protected SSLSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        super(address, port, clientAddress, clientPort);
    }

    @Override
    public void shutdownInput() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdownOutput() throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract String[] getSupportedCipherSuites();

    public abstract String[] getEnabledCipherSuites();

    public abstract void setEnabledCipherSuites(String[] var1);

    public abstract String[] getSupportedProtocols();

    public abstract String[] getEnabledProtocols();

    public abstract void setEnabledProtocols(String[] var1);

    public abstract SSLSession getSession();

    public abstract void addHandshakeCompletedListener(HandshakeCompletedListener var1);

    public abstract void removeHandshakeCompletedListener(HandshakeCompletedListener var1);

    public abstract void startHandshake() throws IOException;

    public abstract void setUseClientMode(boolean var1);

    public abstract boolean getUseClientMode();

    public abstract void setNeedClientAuth(boolean var1);

    public abstract void setWantClientAuth(boolean var1);

    public abstract boolean getNeedClientAuth();

    public abstract boolean getWantClientAuth();

    public abstract void setEnableSessionCreation(boolean var1);

    public abstract boolean getEnableSessionCreation();

    public SSLParameters getSSLParameters() {
        SSLParameters p = new SSLParameters();
        p.setCipherSuites(this.getEnabledCipherSuites());
        p.setProtocols(this.getEnabledProtocols());
        p.setNeedClientAuth(this.getNeedClientAuth());
        p.setWantClientAuth(this.getWantClientAuth());
        return p;
    }

    public void setSSLParameters(SSLParameters p) {
        String[] protocols;
        String[] cipherSuites = p.getCipherSuites();
        if (cipherSuites != null) {
            this.setEnabledCipherSuites(cipherSuites);
        }
        if ((protocols = p.getProtocols()) != null) {
            this.setEnabledProtocols(protocols);
        }
        if (p.getNeedClientAuth()) {
            this.setNeedClientAuth(true);
        } else if (p.getWantClientAuth()) {
            this.setWantClientAuth(true);
        } else {
            this.setWantClientAuth(false);
        }
    }
}

