/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TimeZone;
import libcore.io.BufferIterator;
import libcore.io.ErrnoException;
import libcore.io.MemoryMappedFile;
import libcore.util.TzDataRoboVM;
import libcore.util.ZoneInfo;

public final class ZoneInfoDB {
    private static final TzData DATA = ZoneInfoDB.hasAndroidData() ? new TzDataAndroid(System.getenv("ANDROID_DATA") + "/misc/zoneinfo/tzdata", System.getenv("ANDROID_ROOT") + "/usr/share/zoneinfo/tzdata") : new TzDataRoboVM();

    private static boolean hasAndroidData() {
        String zoneFileName = (System.getenv("ANDROID_ROOT") == null ? "" : System.getenv("ANDROID_ROOT")) + "/usr/share/zoneinfo/zoneinfo.dat";
        File f = new File(zoneFileName);
        return f.exists() && f.isFile();
    }

    private ZoneInfoDB() {
    }

    public static TzData getInstance() {
        return DATA;
    }

    public static abstract class TzData {
        public abstract String[] getAvailableIDs();

        public abstract String[] getAvailableIDs(int var1);

        public abstract String getZoneTab();

        public abstract TimeZone makeTimeZone(String var1) throws IOException;

        public String getDefaultID() {
            return null;
        }

        public abstract String getVersion();
    }

    public static class TzDataAndroid
    extends TzData {
        private MemoryMappedFile mappedFile;
        private String version;
        private String zoneTab;
        private String[] ids;
        private int[] byteOffsets;
        private int[] rawUtcOffsets;

        public TzDataAndroid(String ... paths) {
            for (String path : paths) {
                if (!this.loadData(path)) continue;
                return;
            }
            System.logE("Couldn't find any tzdata!");
            this.version = "missing";
            this.zoneTab = "# Emergency fallback data.\n";
            this.ids = new String[]{"GMT"};
            this.rawUtcOffsets = new int[1];
            this.byteOffsets = this.rawUtcOffsets;
        }

        private boolean loadData(String path) {
            try {
                this.mappedFile = MemoryMappedFile.mmapRO(path);
            }
            catch (ErrnoException errnoException) {
                return false;
            }
            try {
                this.readHeader();
                return true;
            }
            catch (Exception ex) {
                System.logE("tzdata file \"" + path + "\" was present but invalid!", ex);
                return false;
            }
        }

        private void readHeader() {
            BufferIterator it = this.mappedFile.bigEndianIterator();
            byte[] tzdata_version = new byte[12];
            it.readByteArray(tzdata_version, 0, tzdata_version.length);
            String magic = new String(tzdata_version, 0, 6, StandardCharsets.US_ASCII);
            if (!magic.equals("tzdata") || tzdata_version[11] != 0) {
                throw new RuntimeException("bad tzdata magic: " + Arrays.toString(tzdata_version));
            }
            this.version = new String(tzdata_version, 6, 5, StandardCharsets.US_ASCII);
            int index_offset = it.readInt();
            int data_offset = it.readInt();
            int zonetab_offset = it.readInt();
            this.readIndex(it, index_offset, data_offset);
            this.readZoneTab(it, zonetab_offset, (int)this.mappedFile.size() - zonetab_offset);
        }

        private void readZoneTab(BufferIterator it, int zoneTabOffset, int zoneTabSize) {
            byte[] bytes = new byte[zoneTabSize];
            it.seek(zoneTabOffset);
            it.readByteArray(bytes, 0, bytes.length);
            this.zoneTab = new String(bytes, 0, bytes.length, StandardCharsets.US_ASCII);
        }

        private void readIndex(BufferIterator it, int indexOffset, int dataOffset) {
            it.seek(indexOffset);
            int SIZEOF_TZNAME = 40;
            int SIZEOF_TZINT = 4;
            byte[] idBytes = new byte[40];
            int indexSize = dataOffset - indexOffset;
            int entryCount = indexSize / 52;
            char[] idChars = new char[entryCount * 40];
            int[] idEnd = new int[entryCount];
            int idOffset = 0;
            this.byteOffsets = new int[entryCount];
            this.rawUtcOffsets = new int[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                it.readByteArray(idBytes, 0, idBytes.length);
                this.byteOffsets[i] = it.readInt();
                int n = i;
                this.byteOffsets[n] = this.byteOffsets[n] + dataOffset;
                int length = it.readInt();
                if (length < 44) {
                    throw new AssertionError((Object)"length in index file < sizeof(tzhead)");
                }
                this.rawUtcOffsets[i] = it.readInt();
                int len = idBytes.length;
                for (int j = 0; j < len && idBytes[j] != 0; ++j) {
                    idChars[idOffset++] = (char)(idBytes[j] & 0xFF);
                }
                idEnd[i] = idOffset;
            }
            String allIds = new String(idChars, 0, idOffset);
            this.ids = new String[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                this.ids[i] = allIds.substring(i == 0 ? 0 : idEnd[i - 1], idEnd[i]);
            }
        }

        @Override
        public String[] getAvailableIDs() {
            return (String[])this.ids.clone();
        }

        @Override
        public String[] getAvailableIDs(int rawOffset) {
            ArrayList<String> matches = new ArrayList<String>();
            int end = this.rawUtcOffsets.length;
            for (int i = 0; i < end; ++i) {
                if (this.rawUtcOffsets[i] != rawOffset) continue;
                matches.add(this.ids[i]);
            }
            return matches.toArray(new String[matches.size()]);
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getZoneTab() {
            return this.zoneTab;
        }

        @Override
        public TimeZone makeTimeZone(String id) throws IOException {
            int index = Arrays.binarySearch(this.ids, id);
            if (index < 0) {
                return null;
            }
            BufferIterator it = this.mappedFile.bigEndianIterator();
            it.skip(this.byteOffsets[index]);
            return ZoneInfo.makeTimeZone(id, it);
        }
    }
}

