/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.provider.cert;

import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1Any;
import org.apache.harmony.security.asn1.ASN1Explicit;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1Oid;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.pkcs7.ContentInfo;
import org.apache.harmony.security.pkcs7.SignedData;
import org.apache.harmony.security.provider.cert.X509CertImpl;

public class X509CertPathImpl
extends CertPath {
    private static final long serialVersionUID = 7989755106209515436L;
    static final List<String> encodings = Collections.unmodifiableList(Arrays.asList(Encoding.access$000(Encoding.PKI_PATH), Encoding.access$000(Encoding.PKCS7)));
    private final List<X509Certificate> certificates;
    private byte[] pkiPathEncoding;
    private byte[] pkcs7Encoding;
    public static final ASN1SequenceOf ASN1 = new ASN1SequenceOf(ASN1Any.getInstance()){

        @Override
        public Object getDecodedObject(BerInputStream in) throws IOException {
            List encodedCerts = (List)in.content;
            int size = encodedCerts.size();
            ArrayList<X509CertImpl> certificates = new ArrayList<X509CertImpl>(size);
            for (int i = size - 1; i >= 0; --i) {
                certificates.add(new X509CertImpl((org.apache.harmony.security.x509.Certificate)org.apache.harmony.security.x509.Certificate.ASN1.decode((byte[])encodedCerts.get(i))));
            }
            return new X509CertPathImpl(certificates, Encoding.PKI_PATH);
        }

        public Collection<byte[]> getValues(Object object) {
            X509CertPathImpl cp = (X509CertPathImpl)object;
            if (cp.certificates == null) {
                return Collections.emptyList();
            }
            int size = cp.certificates.size();
            ArrayList<byte[]> encodings = new ArrayList<byte[]>(size);
            try {
                for (int i = size - 1; i >= 0; --i) {
                    encodings.add(((X509Certificate)cp.certificates.get(i)).getEncoded());
                }
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Encoding error occurred", e);
            }
            return encodings;
        }
    };
    private static final ASN1Sequence ASN1_SIGNED_DATA = new ASN1Sequence(new ASN1Type[]{ASN1Any.getInstance(), new ASN1Implicit(0, ASN1), ASN1Any.getInstance()}){
        private final byte[] PRECALCULATED_HEAD = new byte[]{2, 1, 1, 49, 0, 48, 3, 6, 1, 0};
        private final byte[] SIGNERS_INFO = new byte[]{49, 0};

        @Override
        protected void getValues(Object object, Object[] values) {
            values[0] = this.PRECALCULATED_HEAD;
            values[1] = object;
            values[2] = this.SIGNERS_INFO;
        }

        @Override
        public Object decode(BerInputStream in) throws IOException {
            throw new RuntimeException("Invalid use of encoder for PKCS#7 SignedData object");
        }
    };
    private static final ASN1Sequence PKCS7_SIGNED_DATA_OBJECT = new ASN1Sequence(new ASN1Type[]{ASN1Any.getInstance(), new ASN1Explicit(0, ASN1_SIGNED_DATA)}){
        private final byte[] SIGNED_DATA_OID = ASN1Oid.getInstance().encode(ContentInfo.SIGNED_DATA);

        @Override
        protected void getValues(Object object, Object[] values) {
            values[0] = this.SIGNED_DATA_OID;
            values[1] = object;
        }

        @Override
        public Object decode(BerInputStream in) throws IOException {
            throw new RuntimeException("Invalid use of encoder for PKCS#7 SignedData object");
        }
    };

    public X509CertPathImpl(List<? extends Certificate> certs) throws CertificateException {
        super("X.509");
        int size = certs.size();
        this.certificates = new ArrayList<X509Certificate>(size);
        for (int i = 0; i < size; ++i) {
            Certificate cert = certs.get(i);
            if (!(cert instanceof X509Certificate)) {
                throw new CertificateException("Certificate " + i + " is not an X.509 certificate");
            }
            this.certificates.add((X509Certificate)cert);
        }
    }

    private X509CertPathImpl(List<X509Certificate> certs, Encoding type) {
        super("X.509");
        this.certificates = certs;
    }

    private static X509CertPathImpl getCertPathFromContentInfo(ContentInfo contentInfo) throws CertificateException {
        SignedData sd = contentInfo.getSignedData();
        if (sd == null) {
            throw new CertificateException("Incorrect PKCS7 encoded form: missing signed data");
        }
        List<org.apache.harmony.security.x509.Certificate> certs = sd.getCertificates();
        if (certs == null) {
            certs = Collections.emptyList();
        }
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>(certs.size());
        for (org.apache.harmony.security.x509.Certificate cert : certs) {
            result.add(new X509CertImpl(cert));
        }
        return new X509CertPathImpl(result, Encoding.PKCS7);
    }

    public static X509CertPathImpl getInstance(InputStream in) throws CertificateException {
        try {
            return (X509CertPathImpl)ASN1.decode(in);
        }
        catch (IOException e) {
            throw new CertificateException("Failed to decode CertPath", e);
        }
    }

    public static X509CertPathImpl getInstance(InputStream in, String encoding) throws CertificateException {
        try {
            Encoding encType = Encoding.findByApiName(encoding);
            if (encType == null) {
                throw new CertificateException("Unsupported encoding: " + encoding);
            }
            switch (encType) {
                case PKI_PATH: {
                    return (X509CertPathImpl)ASN1.decode(in);
                }
                case PKCS7: {
                    return X509CertPathImpl.getCertPathFromContentInfo((ContentInfo)ContentInfo.ASN1.decode(in));
                }
            }
            throw new CertificateException("Unsupported encoding: " + encoding);
        }
        catch (IOException e) {
            throw new CertificateException("Failed to decode CertPath", e);
        }
    }

    public static X509CertPathImpl getInstance(byte[] in) throws CertificateException {
        try {
            return (X509CertPathImpl)ASN1.decode(in);
        }
        catch (IOException e) {
            throw new CertificateException("Failed to decode CertPath", e);
        }
    }

    public static X509CertPathImpl getInstance(byte[] in, String encoding) throws CertificateException {
        try {
            Encoding encType = Encoding.findByApiName(encoding);
            if (encType == null) {
                throw new CertificateException("Unsupported encoding: " + encoding);
            }
            switch (encType) {
                case PKI_PATH: {
                    return (X509CertPathImpl)ASN1.decode(in);
                }
                case PKCS7: {
                    return X509CertPathImpl.getCertPathFromContentInfo((ContentInfo)ContentInfo.ASN1.decode(in));
                }
            }
            throw new CertificateException("Unsupported encoding: " + encoding);
        }
        catch (IOException e) {
            throw new CertificateException("Failed to decode CertPath", e);
        }
    }

    public List<X509Certificate> getCertificates() {
        return Collections.unmodifiableList(this.certificates);
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.getEncoded(Encoding.PKI_PATH);
    }

    private byte[] getEncoded(Encoding encoding) throws CertificateEncodingException {
        switch (encoding) {
            case PKI_PATH: {
                if (this.pkiPathEncoding == null) {
                    this.pkiPathEncoding = ASN1.encode(this);
                }
                return (byte[])this.pkiPathEncoding.clone();
            }
            case PKCS7: {
                if (this.pkcs7Encoding == null) {
                    this.pkcs7Encoding = PKCS7_SIGNED_DATA_OBJECT.encode(this);
                }
                return (byte[])this.pkcs7Encoding.clone();
            }
        }
        throw new CertificateEncodingException("Unsupported encoding: " + (Object)((Object)encoding));
    }

    @Override
    public byte[] getEncoded(String encoding) throws CertificateEncodingException {
        Encoding encType = Encoding.findByApiName(encoding);
        if (encType == null) {
            throw new CertificateEncodingException("Unsupported encoding: " + encoding);
        }
        return this.getEncoded(encType);
    }

    @Override
    public Iterator<String> getEncodings() {
        return encodings.iterator();
    }

    private static enum Encoding {
        PKI_PATH("PkiPath"),
        PKCS7("PKCS7");

        private final String apiName;

        private Encoding(String apiName) {
            this.apiName = apiName;
        }

        static Encoding findByApiName(String apiName) throws CertificateEncodingException {
            for (Encoding element : Encoding.values()) {
                if (!element.apiName.equals(apiName)) continue;
                return element;
            }
            return null;
        }

        static /* synthetic */ String access$000(Encoding x0) {
            return x0.apiName;
        }
    }
}

