/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.Logger;
import com.android.org.conscrypt.SSLRecordProtocol;

public class AlertProtocol {
    protected static final byte WARNING = 1;
    protected static final byte FATAL = 2;
    protected static final byte CLOSE_NOTIFY = 0;
    protected static final byte UNEXPECTED_MESSAGE = 10;
    protected static final byte BAD_RECORD_MAC = 20;
    protected static final byte DECRYPTION_FAILED = 21;
    protected static final byte RECORD_OVERFLOW = 22;
    protected static final byte DECOMPRESSION_FAILURE = 30;
    protected static final byte HANDSHAKE_FAILURE = 40;
    protected static final byte BAD_CERTIFICATE = 42;
    protected static final byte UNSUPPORTED_CERTIFICATE = 43;
    protected static final byte CERTIFICATE_REVOKED = 44;
    protected static final byte CERTIFICATE_EXPIRED = 45;
    protected static final byte CERTIFICATE_UNKNOWN = 46;
    protected static final byte ILLEGAL_PARAMETER = 47;
    protected static final byte UNKNOWN_CA = 48;
    protected static final byte ACCESS_DENIED = 49;
    protected static final byte DECODE_ERROR = 50;
    protected static final byte DECRYPT_ERROR = 51;
    protected static final byte EXPORT_RESTRICTION = 60;
    protected static final byte PROTOCOL_VERSION = 70;
    protected static final byte INSUFFICIENT_SECURITY = 71;
    protected static final byte INTERNAL_ERROR = 80;
    protected static final byte USER_CANCELED = 90;
    protected static final byte NO_RENEGOTIATION = 100;
    private final byte[] alert = new byte[2];
    private SSLRecordProtocol recordProtocol;
    private Logger.Stream logger = Logger.getStream("alert");

    protected AlertProtocol() {
    }

    protected void setRecordProtocol(SSLRecordProtocol recordProtocol) {
        this.recordProtocol = recordProtocol;
    }

    protected void alert(byte level, byte description) {
        if (this.logger != null) {
            this.logger.println("Alert.alert: " + level + " " + description);
        }
        this.alert[0] = level;
        this.alert[1] = description;
    }

    protected byte getDescriptionCode() {
        return this.alert[0] != 0 ? this.alert[1] : (byte)-100;
    }

    protected void setProcessed() {
        if (this.logger != null) {
            this.logger.println("Alert.setProcessed");
        }
        this.alert[0] = 0;
    }

    protected boolean hasAlert() {
        return this.alert[0] != 0;
    }

    protected boolean isFatalAlert() {
        return this.alert[0] == 2;
    }

    protected String getAlertDescription() {
        switch (this.alert[1]) {
            case 0: {
                return "close_notify";
            }
            case 10: {
                return "unexpected_message";
            }
            case 20: {
                return "bad_record_mac";
            }
            case 21: {
                return "decryption_failed";
            }
            case 22: {
                return "record_overflow";
            }
            case 30: {
                return "decompression_failure";
            }
            case 40: {
                return "handshake_failure";
            }
            case 42: {
                return "bad_certificate";
            }
            case 43: {
                return "unsupported_certificate";
            }
            case 44: {
                return "certificate_revoked";
            }
            case 45: {
                return "certificate_expired";
            }
            case 46: {
                return "certificate_unknown";
            }
            case 47: {
                return "illegal_parameter";
            }
            case 48: {
                return "unknown_ca";
            }
            case 49: {
                return "access_denied";
            }
            case 50: {
                return "decode_error";
            }
            case 51: {
                return "decrypt_error";
            }
            case 60: {
                return "export_restriction";
            }
            case 70: {
                return "protocol_version";
            }
            case 71: {
                return "insufficient_security";
            }
            case 80: {
                return "internal_error";
            }
            case 90: {
                return "user_canceled";
            }
            case 100: {
                return "no_renegotiation";
            }
        }
        return null;
    }

    protected byte[] wrap() {
        byte[] res = this.recordProtocol.wrap((byte)21, this.alert, 0, 2);
        return res;
    }

    protected void shutdown() {
        this.alert[0] = 0;
        this.alert[1] = 0;
        this.recordProtocol = null;
    }
}

