/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AlertException;
import com.android.org.conscrypt.AlertProtocol;
import com.android.org.conscrypt.CipherSuite;
import com.android.org.conscrypt.ClientHandshakeImpl;
import com.android.org.conscrypt.EndOfSourceException;
import com.android.org.conscrypt.HandshakeProtocol;
import com.android.org.conscrypt.Logger;
import com.android.org.conscrypt.ProtocolVersion;
import com.android.org.conscrypt.SSLParametersImpl;
import com.android.org.conscrypt.SSLRecordProtocol;
import com.android.org.conscrypt.SSLSessionImpl;
import com.android.org.conscrypt.SSLSocketInputStream;
import com.android.org.conscrypt.SSLSocketOutputStream;
import com.android.org.conscrypt.SSLStreamedInput;
import com.android.org.conscrypt.ServerHandshakeImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class SSLSocketImpl
extends SSLSocket {
    private boolean handshake_started = false;
    private final String wrappedHost;
    private final int wrappedPort;
    protected SSLRecordProtocol recordProtocol;
    private HandshakeProtocol handshakeProtocol;
    private AlertProtocol alertProtocol;
    private SSLSocketInputStream appDataIS;
    private SSLSocketOutputStream appDataOS;
    private SSLSessionImpl session;
    private boolean socket_was_closed = false;
    protected SSLParametersImpl sslParameters;
    protected InputStream input;
    protected OutputStream output;
    private ArrayList<HandshakeCompletedListener> listeners;
    private Logger.Stream logger = Logger.getStream("socket");

    protected SSLSocketImpl(SSLParametersImpl sslParameters) {
        this.sslParameters = sslParameters;
        this.wrappedHost = null;
        this.wrappedPort = -1;
    }

    protected SSLSocketImpl(String host, int port, SSLParametersImpl sslParameters) throws IOException, UnknownHostException {
        super(host, port);
        this.wrappedHost = host;
        this.wrappedPort = port;
        this.sslParameters = sslParameters;
        this.init();
    }

    protected SSLSocketImpl(String host, int port, InetAddress localHost, int localPort, SSLParametersImpl sslParameters) throws IOException, UnknownHostException {
        super(host, port, localHost, localPort);
        this.wrappedHost = host;
        this.wrappedPort = port;
        this.sslParameters = sslParameters;
        this.init();
    }

    protected SSLSocketImpl(InetAddress host, int port, SSLParametersImpl sslParameters) throws IOException {
        super(host, port);
        this.sslParameters = sslParameters;
        this.wrappedHost = null;
        this.wrappedPort = -1;
        this.init();
    }

    protected SSLSocketImpl(InetAddress address, int port, InetAddress localAddress, int localPort, SSLParametersImpl sslParameters) throws IOException {
        super(address, port, localAddress, localPort);
        this.sslParameters = sslParameters;
        this.wrappedHost = null;
        this.wrappedPort = -1;
        this.init();
    }

    protected void init() throws IOException {
        if (this.appDataIS != null) {
            return;
        }
        this.initTransportLayer();
        this.appDataIS = new SSLSocketInputStream(this);
        this.appDataOS = new SSLSocketOutputStream(this);
    }

    protected void initTransportLayer() throws IOException {
        this.input = super.getInputStream();
        this.output = super.getOutputStream();
    }

    protected void closeTransportLayer() throws IOException {
        super.close();
        if (this.input != null) {
            this.input.close();
            this.output.close();
        }
    }

    String getWrappedHostName() {
        return this.wrappedHost;
    }

    int getWrappedPort() {
        return this.wrappedPort;
    }

    String getPeerHostName() {
        if (this.wrappedHost != null) {
            return this.wrappedHost;
        }
        InetAddress inetAddress = super.getInetAddress();
        if (inetAddress != null) {
            return inetAddress.getHostName();
        }
        return null;
    }

    int getPeerPort() {
        return this.wrappedPort == -1 ? super.getPort() : this.wrappedPort;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return CipherSuite.getSupportedCipherSuiteNames();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslParameters.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setEnabledCipherSuites(suites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return (String[])ProtocolVersion.supportedProtocols.clone();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslParameters.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setEnabledProtocols(protocols);
    }

    @Override
    public void setUseClientMode(boolean mode) {
        if (this.handshake_started) {
            throw new IllegalArgumentException("Could not change the mode after the initial handshake has begun.");
        }
        this.sslParameters.setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    @Override
    public SSLSession getSession() {
        if (!this.handshake_started) {
            try {
                this.startHandshake();
            }
            catch (IOException e) {
                return SSLSessionImpl.getNullSession();
            }
        }
        return this.session;
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
    }

    @Override
    public void startHandshake() throws IOException {
        if (this.appDataIS == null) {
            throw new IOException("Socket is not connected.");
        }
        if (this.socket_was_closed) {
            throw new IOException("Socket has already been closed.");
        }
        if (!this.handshake_started) {
            this.handshake_started = true;
            if (this.sslParameters.getUseClientMode()) {
                if (this.logger != null) {
                    this.logger.println("SSLSocketImpl: CLIENT");
                }
                this.handshakeProtocol = new ClientHandshakeImpl(this);
            } else {
                if (this.logger != null) {
                    this.logger.println("SSLSocketImpl: SERVER");
                }
                this.handshakeProtocol = new ServerHandshakeImpl(this);
            }
            this.alertProtocol = new AlertProtocol();
            this.recordProtocol = new SSLRecordProtocol(this.handshakeProtocol, this.alertProtocol, new SSLStreamedInput(this.input), this.appDataIS.dataPoint);
        }
        if (this.logger != null) {
            this.logger.println("SSLSocketImpl.startHandshake");
        }
        this.handshakeProtocol.start();
        this.doHandshake();
        if (this.logger != null) {
            this.logger.println("SSLSocketImpl.startHandshake: END");
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.socket_was_closed) {
            throw new IOException("Socket has already been closed.");
        }
        return this.appDataIS;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.socket_was_closed) {
            throw new IOException("Socket has already been closed.");
        }
        return this.appDataOS;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        super.connect(endpoint);
        this.init();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        super.connect(endpoint, timeout);
        this.init();
    }

    @Override
    public void close() throws IOException {
        if (this.logger != null) {
            this.logger.println("SSLSocket.close " + this.socket_was_closed);
        }
        if (!this.socket_was_closed) {
            if (this.handshake_started) {
                this.alertProtocol.alert((byte)1, (byte)0);
                try {
                    this.output.write(this.alertProtocol.wrap());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.alertProtocol.setProcessed();
            }
            this.shutdown();
            this.closeTransportLayer();
            this.socket_was_closed = true;
        }
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Method sendUrgentData() is not supported.");
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("Methods sendUrgentData, setOOBInline are not supported.");
    }

    private void shutdown() {
        if (this.handshake_started) {
            this.alertProtocol.shutdown();
            this.alertProtocol = null;
            this.handshakeProtocol.shutdown();
            this.handshakeProtocol = null;
            this.recordProtocol.shutdown();
            this.recordProtocol = null;
        }
        this.socket_was_closed = true;
    }

    protected void needAppData() throws IOException {
        if (!this.handshake_started) {
            this.startHandshake();
        }
        if (this.logger != null) {
            this.logger.println("SSLSocket.needAppData..");
        }
        try {
            while (this.appDataIS.available() == 0) {
                int type = this.recordProtocol.unwrap();
                switch (type) {
                    case 22: {
                        if (this.handshakeProtocol.getStatus().equals((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) break;
                        this.doHandshake();
                        break;
                    }
                    case 21: {
                        this.processAlert();
                        if (!this.socket_was_closed) break;
                        return;
                    }
                    case 23: {
                        if (this.logger == null) break;
                        this.logger.println("SSLSocket.needAppData: got the data");
                        break;
                    }
                    default: {
                        this.reportFatalAlert((byte)10, new SSLException("Unexpected message of type " + type + " has been got"));
                    }
                }
                if (this.alertProtocol.hasAlert()) {
                    this.output.write(this.alertProtocol.wrap());
                    this.alertProtocol.setProcessed();
                }
                if (!this.socket_was_closed) continue;
                this.appDataIS.setEnd();
                return;
            }
        }
        catch (AlertException e) {
            this.reportFatalAlert(e.getDescriptionCode(), e.getReason());
        }
        catch (EndOfSourceException e) {
            this.appDataIS.setEnd();
        }
        if (this.logger != null) {
            this.logger.println("SSLSocket.needAppData: app data len: " + this.appDataIS.available());
        }
    }

    protected void writeAppData(byte[] data, int offset, int len) throws IOException {
        if (!this.handshake_started) {
            this.startHandshake();
        }
        if (this.logger != null) {
            this.logger.println("SSLSocket.writeAppData: " + len + " " + 16384);
        }
        try {
            if (len < 16384) {
                this.output.write(this.recordProtocol.wrap((byte)23, data, offset, len));
            } else {
                while (len >= 16384) {
                    this.output.write(this.recordProtocol.wrap((byte)23, data, offset, 16384));
                    offset += 16384;
                    len -= 16384;
                }
                if (len > 0) {
                    this.output.write(this.recordProtocol.wrap((byte)23, data, offset, len));
                }
            }
        }
        catch (AlertException e) {
            this.reportFatalAlert(e.getDescriptionCode(), e.getReason());
        }
    }

    private void doHandshake() throws IOException {
        try {
            SSLEngineResult.HandshakeStatus status;
            while (!(status = this.handshakeProtocol.getStatus()).equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
                block14: {
                    block15: {
                        block13: {
                            if (this.logger != null) {
                                String s = status.equals((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP) ? "NEED_WRAP" : (status.equals((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP) ? "NEED_UNWRAP" : "STATUS: OTHER!");
                                this.logger.println("SSLSocketImpl: HS status: " + s + " " + (Object)((Object)status));
                            }
                            if (!status.equals((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP)) break block13;
                            this.output.write(this.handshakeProtocol.wrap());
                            break block14;
                        }
                        if (!status.equals((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP)) break block15;
                        int type = this.recordProtocol.unwrap();
                        switch (type) {
                            case 20: 
                            case 22: {
                                break;
                            }
                            case 23: {
                                break;
                            }
                            case 21: {
                                this.processAlert();
                                if (this.socket_was_closed) {
                                    return;
                                }
                                break block14;
                            }
                            default: {
                                this.reportFatalAlert((byte)10, new SSLException("Unexpected message of type " + type + " has been got"));
                                break;
                            }
                        }
                        break block14;
                    }
                    this.reportFatalAlert((byte)80, new SSLException("Handshake passed unexpected status: " + (Object)((Object)status)));
                }
                if (!this.alertProtocol.hasAlert()) continue;
                this.output.write(this.alertProtocol.wrap());
                this.alertProtocol.setProcessed();
            }
        }
        catch (EndOfSourceException e) {
            this.appDataIS.setEnd();
            throw new IOException("Connection was closed");
        }
        catch (AlertException e) {
            this.reportFatalAlert(e.getDescriptionCode(), e.getReason());
        }
        this.session = this.recordProtocol.getSession();
        if (this.listeners != null) {
            HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.session);
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                this.listeners.get(i).handshakeCompleted(event);
            }
        }
    }

    private void processAlert() throws IOException {
        if (!this.alertProtocol.hasAlert()) {
            return;
        }
        if (this.alertProtocol.isFatalAlert()) {
            this.alertProtocol.setProcessed();
            String description = "Fatal alert received " + this.alertProtocol.getAlertDescription();
            this.shutdown();
            throw new SSLException(description);
        }
        if (this.logger != null) {
            this.logger.println("Warning alert received: " + this.alertProtocol.getAlertDescription());
        }
        switch (this.alertProtocol.getDescriptionCode()) {
            case 0: {
                this.alertProtocol.setProcessed();
                this.appDataIS.setEnd();
                this.close();
                return;
            }
        }
        this.alertProtocol.setProcessed();
    }

    private void reportFatalAlert(byte description_code, SSLException reason) throws IOException {
        this.alertProtocol.alert((byte)2, description_code);
        try {
            this.output.write(this.alertProtocol.wrap());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.alertProtocol.setProcessed();
        this.shutdown();
        throw reason;
    }
}

