/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Comparator;
import libcore.reflect.GenericSignatureParser;
import libcore.reflect.ListOfTypes;
import libcore.reflect.Types;
import libcore.util.EmptyArray;
import org.robovm.rt.VM;

public final class Method
extends AccessibleObject
implements GenericDeclaration,
Member {
    public static final Comparator<Method> ORDER_BY_SIGNATURE = new Comparator<Method>(){

        @Override
        public int compare(Method a, Method b) {
            int comparison = a.name.compareTo(b.name);
            if (comparison != 0) {
                return comparison;
            }
            Class[] aParameters = a.parameterTypes;
            Class[] bParameters = b.parameterTypes;
            int length = Math.min(aParameters.length, bParameters.length);
            for (int i = 0; i < length; ++i) {
                comparison = aParameters[i].getName().compareTo(bParameters[i].getName());
                if (comparison == 0) continue;
                return comparison;
            }
            if (aParameters.length != bParameters.length) {
                return aParameters.length - bParameters.length;
            }
            return a.getReturnType().getName().compareTo(b.getReturnType().getName());
        }
    };
    private final long method;
    private int modifiers = -1;
    private Class<?> declaringClass;
    private String name;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private Class<?> returnType;
    private Object defaultValue;
    private Annotation[] declaredAnnotations;
    private Annotation[][] parameterAnnotations;
    private ListOfTypes genericExceptionTypes;
    private ListOfTypes genericParameterTypes;
    private Type genericReturnType;
    private TypeVariable<Method>[] formalTypeParameters;
    private volatile boolean genericTypesAreInitialized = false;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];

    private synchronized void initGenericTypes() {
        if (!this.genericTypesAreInitialized) {
            String signatureAttribute = this.getSignatureAttribute();
            GenericSignatureParser parser = new GenericSignatureParser(this.getDeclaringClass().getClassLoader());
            parser.parseForMethod(this, signatureAttribute, this.getExceptionTypes());
            this.formalTypeParameters = parser.formalTypeParameters;
            this.genericParameterTypes = parser.parameterTypes;
            this.genericExceptionTypes = parser.exceptionTypes;
            this.genericReturnType = parser.returnType;
            this.genericTypesAreInitialized = true;
        }
    }

    Method(long method) {
        this.method = method;
    }

    Method(Method orig) {
        this.method = orig.method;
        this.modifiers = orig.modifiers;
        this.declaringClass = orig.declaringClass;
        this.name = orig.name;
        this.parameterTypes = orig.parameterTypes;
        this.exceptionTypes = orig.exceptionTypes;
        this.returnType = orig.returnType;
        this.defaultValue = orig.defaultValue;
        this.genericExceptionTypes = orig.genericExceptionTypes;
        this.genericParameterTypes = orig.genericParameterTypes;
        this.genericReturnType = orig.genericReturnType;
        this.formalTypeParameters = orig.formalTypeParameters;
        this.genericTypesAreInitialized = orig.genericTypesAreInitialized;
        this.declaredAnnotations = orig.declaredAnnotations;
        this.parameterAnnotations = orig.parameterAnnotations;
        if (orig.flag) {
            this.flag = true;
        }
    }

    public TypeVariable<Method>[] getTypeParameters() {
        this.initGenericTypes();
        return (TypeVariable[])this.formalTypeParameters.clone();
    }

    @Override
    protected String getSignatureAttribute() {
        return Method.getSignatureAttribute(this.method);
    }

    static final native String getSignatureAttribute(long var0);

    public String toGenericString() {
        StringBuilder sb = new StringBuilder(80);
        this.initGenericTypes();
        int modifier = this.getModifiers();
        if (modifier != 0) {
            sb.append(Modifier.toString(modifier & 0xFFFFFF3F)).append(' ');
        }
        if (this.formalTypeParameters != null && this.formalTypeParameters.length > 0) {
            sb.append('<');
            for (int i = 0; i < this.formalTypeParameters.length; ++i) {
                this.appendGenericType(sb, this.formalTypeParameters[i]);
                if (i >= this.formalTypeParameters.length - 1) continue;
                sb.append(",");
            }
            sb.append("> ");
        }
        this.appendGenericType(sb, Types.getType(this.genericReturnType));
        sb.append(' ');
        this.appendTypeName(sb, this.getDeclaringClass());
        sb.append(".").append(this.getName());
        sb.append('(');
        this.appendArrayGenericType(sb, Types.getTypeArray(this.genericParameterTypes, false));
        sb.append(')');
        Type[] genericExceptionTypeArray = Types.getTypeArray(this.genericExceptionTypes, false);
        if (genericExceptionTypeArray.length > 0) {
            sb.append(" throws ");
            this.appendArrayGenericType(sb, genericExceptionTypeArray);
        }
        return sb.toString();
    }

    public Type[] getGenericParameterTypes() {
        this.initGenericTypes();
        return Types.getTypeArray(this.genericParameterTypes, true);
    }

    public Type[] getGenericExceptionTypes() {
        this.initGenericTypes();
        return Types.getTypeArray(this.genericExceptionTypes, true);
    }

    public Type getGenericReturnType() {
        this.initGenericTypes();
        return Types.getType(this.genericReturnType);
    }

    @Override
    protected Annotation[] getDeclaredAnnotations(boolean copy) {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = Method.getDeclaredAnnotations(this.method);
        }
        return copy ? (Annotation[])this.declaredAnnotations.clone() : this.declaredAnnotations;
    }

    static final native Annotation[] getDeclaredAnnotations(long var0);

    static Annotation[][] noAnnotations(int size) {
        Annotation[][] annotations = new Annotation[size][];
        for (int i = 0; i < size; ++i) {
            annotations[i] = NO_ANNOTATIONS;
        }
        return annotations;
    }

    public Annotation[][] getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            Annotation[][] pa = Method.getParameterAnnotations(this.method);
            if (pa.length == 0) {
                pa = Method.noAnnotations(this.getParameterTypes(false).length);
            }
            this.parameterAnnotations = pa;
        }
        return (Annotation[][])this.parameterAnnotations.clone();
    }

    static final native Annotation[][] getParameterAnnotations(long var0);

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            this.defaultValue = Method.getDefaultValue(this.method);
        }
        return this.defaultValue;
    }

    static final native Object getDefaultValue(long var0);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Method)) {
            return false;
        }
        Method rhs = (Method)object;
        return this.getDeclaringClass().equals(rhs.getDeclaringClass()) && this.getName().equals(rhs.getName()) && this.getReturnType().equals(rhs.getReturnType()) && Arrays.equals(this.getParameterTypes(false), rhs.getParameterTypes(false));
    }

    @Override
    public Class<?> getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = Method.getDeclaringClass(this.method);
        }
        return this.declaringClass;
    }

    static final native <T> Class<T> getDeclaringClass(long var0);

    public Class<?>[] getExceptionTypes() {
        return this.getExceptionTypes(true);
    }

    private Class<?>[] getExceptionTypes(boolean copy) {
        if (this.exceptionTypes == null) {
            this.exceptionTypes = Method.getExceptionTypes(this.method);
        }
        return copy ? (Class[])this.exceptionTypes.clone() : this.exceptionTypes;
    }

    static final native Class<?>[] getExceptionTypes(long var0);

    @Override
    public int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = Method.getModifiers(this.method);
        }
        return this.modifiers;
    }

    static final native int getModifiers(long var0);

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = Method.getName(this.method);
        }
        return this.name;
    }

    private static native String getName(long var0);

    public Class<?>[] getParameterTypes() {
        return this.getParameterTypes(true);
    }

    final Class<?>[] getParameterTypes(boolean copy) {
        if (this.parameterTypes == null) {
            this.parameterTypes = Method.getParameterTypes(this.method);
        }
        return copy ? (Class[])this.parameterTypes.clone() : this.parameterTypes;
    }

    static final native Class<?>[] getParameterTypes(long var0);

    public Class<?> getReturnType() {
        if (this.returnType == null) {
            this.returnType = Method.getReturnType(this.method);
        }
        return this.returnType;
    }

    private static native Class<?> getReturnType(long var0);

    public int hashCode() {
        return this.getName().hashCode();
    }

    public Object invoke(Object receiver, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> caller;
        Class<?>[] pTypes;
        if (!Modifier.isStatic(this.getModifiers())) {
            Class<?> expectedClass = this.getDeclaringClass();
            if (receiver == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("expected receiver of type ");
                this.appendTypeName(sb, expectedClass);
                sb.append(", but got null");
                throw new NullPointerException(sb.toString());
            }
            if (!this.getDeclaringClass().isInstance(receiver)) {
                StringBuilder sb = new StringBuilder();
                sb.append("expected receiver of type ");
                this.appendTypeName(sb, expectedClass);
                sb.append(", but got ");
                this.appendTypeName(sb, receiver.getClass());
                throw new IllegalArgumentException(sb.toString());
            }
        }
        if (args == null) {
            args = EmptyArray.OBJECT;
        }
        if (args.length != (pTypes = this.getParameterTypes(false)).length) {
            throw new IllegalArgumentException("wrong number of arguments; expected " + pTypes.length + ", got " + args.length);
        }
        if (!(this.flag || Method.checkAccessibleFast(this) || Method.checkAccessible(caller = VM.getStackClasses(0, 1)[0], this))) {
            throw new IllegalAccessException(String.format("Attempt to access method %s.%s(%s) from class %s", this.getDeclaringClass().getName(), this.getName(), this.toString(pTypes), caller.getName()));
        }
        return Method.internalInvoke(this.method, pTypes, receiver, args);
    }

    private static native Object internalInvoke(long var0, Class<?>[] var2, Object var3, Object[] var4) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public String toString() {
        Class<?> returnType = this.getReturnType();
        Class<?> declaringClass = this.getDeclaringClass();
        String name = this.getName();
        Class<?>[] parameterTypes = this.getParameterTypes(false);
        Class<?>[] exceptionTypes = this.getExceptionTypes(false);
        StringBuilder result = new StringBuilder(Modifier.toString(this.getModifiers()));
        if (result.length() != 0) {
            result.append(' ');
        }
        this.appendTypeName(result, returnType);
        result.append(' ');
        result.append(declaringClass.getName());
        result.append('.');
        result.append(name);
        result.append("(");
        result.append(this.toString(parameterTypes));
        result.append(")");
        if (exceptionTypes != null && exceptionTypes.length != 0) {
            result.append(" throws ");
            result.append(this.toString(exceptionTypes));
        }
        return result.toString();
    }

    private String getSignature() {
        Class<?> returnType = this.getReturnType();
        Class<?>[] parameterTypes = this.getParameterTypes(false);
        StringBuilder result = new StringBuilder();
        result.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            result.append(this.getSignature(parameterTypes[i]));
        }
        result.append(')');
        result.append(this.getSignature(returnType));
        return result.toString();
    }
}

