/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

public final class ByteOrder {
    private static final ByteOrder NATIVE_ORDER;
    public static final ByteOrder BIG_ENDIAN;
    public static final ByteOrder LITTLE_ENDIAN;
    private final String name;
    public final boolean needsSwap;

    private static native boolean isLittleEndian();

    private ByteOrder(String name, boolean needsSwap) {
        this.name = name;
        this.needsSwap = needsSwap;
    }

    public static ByteOrder nativeOrder() {
        return NATIVE_ORDER;
    }

    public String toString() {
        return this.name;
    }

    static {
        boolean isLittleEndian = ByteOrder.isLittleEndian();
        BIG_ENDIAN = new ByteOrder("BIG_ENDIAN", isLittleEndian);
        LITTLE_ENDIAN = new ByteOrder("LITTLE_ENDIAN", !isLittleEndian);
        NATIVE_ORDER = isLittleEndian ? LITTLE_ENDIAN : BIG_ENDIAN;
    }
}

