/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.IOException;
import org.apache.harmony.security.asn1.ObjectIdentifier;
import org.apache.harmony.security.utils.Array;

public class PolicyQualifierInfo {
    private final byte[] encoded;
    private final String policyQualifierId;
    private final byte[] policyQualifier;

    public PolicyQualifierInfo(byte[] encoded) throws IOException {
        if (encoded == null) {
            throw new NullPointerException("encoded == null");
        }
        if (encoded.length == 0) {
            throw new IOException("encoded.length == 0");
        }
        this.encoded = new byte[encoded.length];
        System.arraycopy((Object)encoded, 0, (Object)this.encoded, 0, this.encoded.length);
        Object[] decoded = (Object[])org.apache.harmony.security.x509.PolicyQualifierInfo.ASN1.decode(this.encoded);
        this.policyQualifierId = ObjectIdentifier.toString((int[])decoded[0]);
        this.policyQualifier = (byte[])decoded[1];
    }

    public final byte[] getEncoded() {
        byte[] ret = new byte[this.encoded.length];
        System.arraycopy((Object)this.encoded, 0, (Object)ret, 0, this.encoded.length);
        return ret;
    }

    public final String getPolicyQualifierId() {
        return this.policyQualifierId;
    }

    public final byte[] getPolicyQualifier() {
        if (this.policyQualifier == null) {
            return null;
        }
        byte[] ret = new byte[this.policyQualifier.length];
        System.arraycopy((Object)this.policyQualifier, 0, (Object)ret, 0, this.policyQualifier.length);
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PolicyQualifierInfo: [\npolicyQualifierId: ");
        sb.append(this.policyQualifierId);
        sb.append("\npolicyQualifier: \n");
        sb.append(Array.toString(this.policyQualifier, " "));
        sb.append("]");
        return sb.toString();
    }
}

