/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import sun.misc.Unsafe;

public class Exchanger<V> {
    private static final int ASHIFT = 7;
    private static final int MMASK = 255;
    private static final int SEQ = 256;
    private static final int NCPU;
    static final int FULL;
    private static final int SPINS = 1024;
    private static final Object NULL_ITEM;
    private static final Object TIMED_OUT;
    private final Participant participant = new Participant();
    private volatile Node[] arena;
    private volatile Node slot;
    private volatile int bound;
    private static final Unsafe U;
    private static final long BOUND;
    private static final long SLOT;
    private static final long MATCH;
    private static final long BLOCKER;
    private static final int ABASE;

    private final Object arenaExchange(Object item, boolean timed, long ns) {
        Node[] a = this.arena;
        Node p = (Node)this.participant.get();
        int i = p.index;
        while (true) {
            long j;
            Node q;
            if ((q = (Node)U.getObjectVolatile(a, j = (long)((i << 7) + ABASE))) != null && U.compareAndSwapObject(a, j, q, null)) {
                Object v = q.item;
                q.match = item;
                Thread w = q.parked;
                if (w != null) {
                    U.unpark(w);
                }
                return v;
            }
            int b = this.bound;
            int m = b & 0xFF;
            if (i <= m && q == null) {
                p.item = item;
                if (U.compareAndSwapObject(a, j, null, p)) {
                    long end = timed && m == 0 ? System.nanoTime() + ns : 0L;
                    Thread t = Thread.currentThread();
                    int h = p.hash;
                    int spins = 1024;
                    while (true) {
                        Object v;
                        if ((v = p.match) != null) {
                            U.putOrderedObject(p, MATCH, null);
                            p.item = null;
                            p.hash = h;
                            return v;
                        }
                        if (spins > 0) {
                            h ^= h << 1;
                            h ^= h >>> 3;
                            if ((h ^= h << 10) == 0) {
                                h = 0x400 | (int)t.getId();
                                continue;
                            }
                            if (h >= 0 || (--spins & 0x1FF) != 0) continue;
                            Thread.yield();
                            continue;
                        }
                        if (U.getObjectVolatile(a, j) != p) {
                            spins = 1024;
                            continue;
                        }
                        if (!(t.isInterrupted() || m != 0 || timed && (ns = end - System.nanoTime()) <= 0L)) {
                            U.putObject(t, BLOCKER, this);
                            p.parked = t;
                            if (U.getObjectVolatile(a, j) == p) {
                                U.park(false, ns);
                            }
                            p.parked = null;
                            U.putObject(t, BLOCKER, null);
                            continue;
                        }
                        if (U.getObjectVolatile(a, j) == p && U.compareAndSwapObject(a, j, p, null)) break;
                    }
                    if (m != 0) {
                        U.compareAndSwapInt(this, BOUND, b, b + 256 - 1);
                    }
                    p.item = null;
                    p.hash = h;
                    i = p.index >>>= 1;
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (!timed || m != 0 || ns > 0L) continue;
                    return TIMED_OUT;
                }
                p.item = null;
                continue;
            }
            if (p.bound != b) {
                p.bound = b;
                p.collides = 0;
                i = i != m || m == 0 ? m : m - 1;
            } else {
                int c = p.collides;
                if (c < m || m == FULL || !U.compareAndSwapInt(this, BOUND, b, b + 256 + 1)) {
                    p.collides = c + 1;
                    i = i == 0 ? m : i - 1;
                } else {
                    i = m + 1;
                }
            }
            p.index = i;
        }
    }

    private final Object slotExchange(Object item, boolean timed, long ns) {
        Object v;
        int spins;
        Node p = (Node)this.participant.get();
        Thread t = Thread.currentThread();
        if (t.isInterrupted()) {
            return null;
        }
        while (true) {
            Node q;
            if ((q = this.slot) != null) {
                if (U.compareAndSwapObject(this, SLOT, q, null)) {
                    Object v2 = q.item;
                    q.match = item;
                    Thread w = q.parked;
                    if (w != null) {
                        U.unpark(w);
                    }
                    return v2;
                }
                if (NCPU <= 1 || this.bound != 0 || !U.compareAndSwapInt(this, BOUND, 0, 256)) continue;
                this.arena = new Node[FULL + 2 << 7];
                continue;
            }
            if (this.arena != null) {
                return null;
            }
            p.item = item;
            if (U.compareAndSwapObject(this, SLOT, null, p)) break;
            p.item = null;
        }
        int h = p.hash;
        long end = timed ? System.nanoTime() + ns : 0L;
        int n = spins = NCPU > 1 ? 1024 : 1;
        while ((v = p.match) == null) {
            if (spins > 0) {
                h ^= h << 1;
                h ^= h >>> 3;
                if ((h ^= h << 10) == 0) {
                    h = 0x400 | (int)t.getId();
                    continue;
                }
                if (h >= 0 || (--spins & 0x1FF) != 0) continue;
                Thread.yield();
                continue;
            }
            if (this.slot != p) {
                spins = 1024;
                continue;
            }
            if (!(t.isInterrupted() || this.arena != null || timed && (ns = end - System.nanoTime()) <= 0L)) {
                U.putObject(t, BLOCKER, this);
                p.parked = t;
                if (this.slot == p) {
                    U.park(false, ns);
                }
                p.parked = null;
                U.putObject(t, BLOCKER, null);
                continue;
            }
            if (!U.compareAndSwapObject(this, SLOT, p, null)) continue;
            v = timed && ns <= 0L && !t.isInterrupted() ? TIMED_OUT : null;
            break;
        }
        U.putOrderedObject(p, MATCH, null);
        p.item = null;
        p.hash = h;
        return v;
    }

    public V exchange(V x) throws InterruptedException {
        Object v;
        Object item;
        Object object = item = x == null ? NULL_ITEM : x;
        if (!(this.arena == null && (v = this.slotExchange(item, false, 0L)) != null || !Thread.interrupted() && (v = this.arenaExchange(item, false, 0L)) != null)) {
            throw new InterruptedException();
        }
        return (V)(v == NULL_ITEM ? null : v);
    }

    public V exchange(V x, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Object v;
        Object item = x == null ? NULL_ITEM : x;
        long ns = unit.toNanos(timeout);
        if (!(this.arena == null && (v = this.slotExchange(item, true, ns)) != null || !Thread.interrupted() && (v = this.arenaExchange(item, true, ns)) != null)) {
            throw new InterruptedException();
        }
        if (v == TIMED_OUT) {
            throw new TimeoutException();
        }
        return (V)(v == NULL_ITEM ? null : v);
    }

    static {
        int s;
        NCPU = Runtime.getRuntime().availableProcessors();
        FULL = NCPU >= 510 ? 255 : NCPU >>> 1;
        NULL_ITEM = new Object();
        TIMED_OUT = new Object();
        try {
            U = Unsafe.getUnsafe();
            Class<Exchanger> ek = Exchanger.class;
            Class<Node> nk = Node.class;
            Class<Node[]> ak = Node[].class;
            Class<Thread> tk = Thread.class;
            BOUND = U.objectFieldOffset(ek.getDeclaredField("bound"));
            SLOT = U.objectFieldOffset(ek.getDeclaredField("slot"));
            MATCH = U.objectFieldOffset(nk.getDeclaredField("match"));
            BLOCKER = U.objectFieldOffset(tk.getDeclaredField("parkBlocker"));
            s = U.arrayIndexScale(ak);
            ABASE = U.arrayBaseOffset(ak) + 128;
        }
        catch (Exception e) {
            throw new Error(e);
        }
        if ((s & s - 1) != 0 || s > 128) {
            throw new Error("Unsupported array scale");
        }
    }

    static final class Node {
        int index;
        int bound;
        int collides;
        int hash;
        Object item;
        volatile Object match;
        volatile Thread parked;
        Object p0;
        Object p1;
        Object p2;
        Object p3;
        Object p4;
        Object p5;
        Object p6;
        Object p7;
        Object p8;
        Object p9;
        Object pa;
        Object pb;
        Object pc;
        Object pd;
        Object pe;
        Object pf;
        Object q0;
        Object q1;
        Object q2;
        Object q3;
        Object q4;
        Object q5;
        Object q6;
        Object q7;
        Object q8;
        Object q9;
        Object qa;
        Object qb;
        Object qc;
        Object qd;
        Object qe;
        Object qf;

        Node() {
        }
    }

    static final class Participant
    extends ThreadLocal<Node> {
        Participant() {
        }

        @Override
        public Node initialValue() {
            return new Node();
        }
    }
}

