/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.rt.bro;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.robovm.rt.bro.GlobalValueSupplier;
import org.robovm.rt.bro.annotation.GlobalValue;

public class LazyGlobalValue<T>
extends GlobalValueSupplier<T> {
    private static final Object NO_VALUE = new Object();
    private static final Object NOT_LINKED = new Object();
    private final Method getter;
    private final boolean constant;
    private T cachedValue = NO_VALUE;

    public LazyGlobalValue(Class<?> owner, String getterName) {
        this(owner, getterName, true);
    }

    public LazyGlobalValue(Class<?> owner, String getterName, boolean constant) {
        if (owner == null) {
            throw new NullPointerException("owner");
        }
        if (getterName == null) {
            throw new NullPointerException("getterName");
        }
        this.constant = constant;
        try {
            this.getter = owner.getDeclaredMethod(getterName, new Class[0]);
            this.getter.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("@GlobalValue getter method named " + getterName + " not found in class " + owner.getName(), e);
        }
        if (this.getter.getAnnotation(GlobalValue.class) == null) {
            throw new IllegalArgumentException("Method " + this.getter + " is not a @GlobalValue method");
        }
    }

    @Override
    public boolean isAvailable() {
        if (this.cachedValue != NOT_LINKED) {
            try {
                this.value();
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public T value() {
        try {
            if (!this.constant) {
                return (T)this.getter.invoke(null, new Object[0]);
            }
            if (this.cachedValue == NO_VALUE || this.cachedValue == NOT_LINKED) {
                this.cachedValue = this.getter.invoke(null, new Object[0]);
            }
            return this.cachedValue;
        }
        catch (UnsatisfiedLinkError e) {
            this.cachedValue = NOT_LINKED;
            throw e;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new Error(e);
        }
    }
}

