/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.Logger;
import javax.crypto.Cipher;

public abstract class ConnectionState {
    protected Cipher encCipher;
    protected Cipher decCipher;
    protected int block_size;
    protected int hash_size;
    protected final byte[] write_seq_num = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected final byte[] read_seq_num = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected Logger.Stream logger = Logger.getStream("conn_state");

    protected int getMinFragmentSize() {
        return this.encCipher.getOutputSize(1 + this.hash_size);
    }

    protected int getFragmentSize(int content_size) {
        return this.encCipher.getOutputSize(content_size + this.hash_size);
    }

    protected int getContentSize(int generic_cipher_size) {
        return this.decCipher.getOutputSize(generic_cipher_size) - this.hash_size;
    }

    protected int getPaddingSize(int content_size) {
        int mask = this.block_size - 1;
        return this.block_size - (content_size & mask);
    }

    protected byte[] encrypt(byte type, byte[] fragment) {
        return this.encrypt(type, fragment, 0, fragment.length);
    }

    protected abstract byte[] encrypt(byte var1, byte[] var2, int var3, int var4);

    protected byte[] decrypt(byte type, byte[] fragment) {
        return this.decrypt(type, fragment, 0, fragment.length);
    }

    protected abstract byte[] decrypt(byte var1, byte[] var2, int var3, int var4);

    protected static void incSequenceNumber(byte[] seq_num) {
        for (int octet = 7; octet >= 0; --octet) {
            int n = octet;
            seq_num[n] = (byte)(seq_num[n] + 1);
            if (seq_num[octet] == 0) {
                continue;
            }
            return;
        }
    }

    protected void shutdown() {
        this.encCipher = null;
        this.decCipher = null;
        for (int i = 0; i < this.write_seq_num.length; ++i) {
            this.write_seq_num[i] = 0;
            this.read_seq_num[i] = 0;
        }
    }
}

