/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AbstractSessionContext;
import com.android.org.conscrypt.CipherSuite;
import com.android.org.conscrypt.ClientSessionContext;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLKey;
import com.android.org.conscrypt.OpenSSLSessionImpl;
import com.android.org.conscrypt.OpenSSLX509Certificate;
import com.android.org.conscrypt.SSLParametersImpl;
import com.android.org.conscrypt.SSLSessionImpl;
import com.android.org.conscrypt.TrustManagerImpl;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.InvalidKeyException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.io.Streams;
import libcore.io.StructTimeval;

public class OpenSSLSocketImpl
extends SSLSocket
implements NativeCrypto.SSLHandshakeCallbacks {
    private static final boolean DBG_STATE = false;
    private final Object stateLock = new Object();
    private static final int STATE_NEW = 0;
    private static final int STATE_HANDSHAKE_STARTED = 1;
    private static final int STATE_HANDSHAKE_COMPLETED = 2;
    private static final int STATE_READY_HANDSHAKE_CUT_THROUGH = 3;
    private static final int STATE_READY = 4;
    private static final int STATE_CLOSED = 5;
    private int state = 0;
    private long sslNativePointer;
    private SSLInputStream is;
    private SSLOutputStream os;
    private final Socket socket;
    private final boolean autoClose;
    private final String wrappedHost;
    private final int wrappedPort;
    private final SSLParametersImpl sslParameters;
    private final CloseGuard guard = CloseGuard.get();
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;
    private byte[] npnProtocols;
    private byte[] alpnProtocols;
    private boolean useSessionTickets;
    private String hostname;
    private boolean channelIdEnabled;
    private OpenSSLKey channelIdPrivateKey;
    private OpenSSLSessionImpl sslSession;
    private ArrayList<HandshakeCompletedListener> listeners;
    private int readTimeoutMilliseconds = 0;
    private int writeTimeoutMilliseconds = 0;
    private int handshakeTimeoutMilliseconds = -1;

    protected OpenSSLSocketImpl(SSLParametersImpl sslParameters) throws IOException {
        this.socket = this;
        this.wrappedHost = null;
        this.wrappedPort = -1;
        this.autoClose = false;
        this.sslParameters = sslParameters;
        this.enabledProtocols = NativeCrypto.getDefaultProtocols();
        this.enabledCipherSuites = NativeCrypto.getDefaultCipherSuites();
    }

    protected OpenSSLSocketImpl(SSLParametersImpl sslParameters, String[] enabledProtocols, String[] enabledCipherSuites) throws IOException {
        this.socket = this;
        this.wrappedHost = null;
        this.wrappedPort = -1;
        this.autoClose = false;
        this.sslParameters = sslParameters;
        this.enabledProtocols = enabledProtocols;
        this.enabledCipherSuites = enabledCipherSuites;
    }

    protected OpenSSLSocketImpl(String host, int port, SSLParametersImpl sslParameters) throws IOException {
        super(host, port);
        this.socket = this;
        this.wrappedHost = null;
        this.wrappedPort = -1;
        this.autoClose = false;
        this.sslParameters = sslParameters;
        this.enabledProtocols = NativeCrypto.getDefaultProtocols();
        this.enabledCipherSuites = NativeCrypto.getDefaultCipherSuites();
    }

    protected OpenSSLSocketImpl(InetAddress address, int port, SSLParametersImpl sslParameters) throws IOException {
        super(address, port);
        this.socket = this;
        this.wrappedHost = null;
        this.wrappedPort = -1;
        this.autoClose = false;
        this.sslParameters = sslParameters;
        this.enabledProtocols = NativeCrypto.getDefaultProtocols();
        this.enabledCipherSuites = NativeCrypto.getDefaultCipherSuites();
    }

    protected OpenSSLSocketImpl(String host, int port, InetAddress clientAddress, int clientPort, SSLParametersImpl sslParameters) throws IOException {
        super(host, port, clientAddress, clientPort);
        this.socket = this;
        this.wrappedHost = null;
        this.wrappedPort = -1;
        this.autoClose = false;
        this.sslParameters = sslParameters;
        this.enabledProtocols = NativeCrypto.getDefaultProtocols();
        this.enabledCipherSuites = NativeCrypto.getDefaultCipherSuites();
    }

    protected OpenSSLSocketImpl(InetAddress address, int port, InetAddress clientAddress, int clientPort, SSLParametersImpl sslParameters) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.socket = this;
        this.wrappedHost = null;
        this.wrappedPort = -1;
        this.autoClose = false;
        this.sslParameters = sslParameters;
        this.enabledProtocols = NativeCrypto.getDefaultProtocols();
        this.enabledCipherSuites = NativeCrypto.getDefaultCipherSuites();
    }

    protected OpenSSLSocketImpl(Socket socket, String host, int port, boolean autoClose, SSLParametersImpl sslParameters) throws IOException {
        this.socket = socket;
        this.wrappedHost = host;
        this.wrappedPort = port;
        this.autoClose = autoClose;
        this.sslParameters = sslParameters;
        this.enabledProtocols = NativeCrypto.getDefaultProtocols();
        this.enabledCipherSuites = NativeCrypto.getDefaultCipherSuites();
    }

    private OpenSSLSessionImpl getCachedClientSession(ClientSessionContext sessionContext) {
        String hostName = this.getPeerHostName();
        int port = this.getPeerPort();
        if (hostName == null) {
            return null;
        }
        OpenSSLSessionImpl session = (OpenSSLSessionImpl)sessionContext.getSession(hostName, port);
        if (session == null) {
            return null;
        }
        String protocol = session.getProtocol();
        boolean protocolFound = false;
        for (String enabledProtocol : this.enabledProtocols) {
            if (!protocol.equals(enabledProtocol)) continue;
            protocolFound = true;
            break;
        }
        if (!protocolFound) {
            return null;
        }
        String cipherSuite = session.getCipherSuite();
        boolean cipherSuiteFound = false;
        for (String enabledCipherSuite : this.enabledCipherSuites) {
            if (!cipherSuite.equals(enabledCipherSuite)) continue;
            cipherSuiteFound = true;
            break;
        }
        if (!cipherSuiteFound) {
            return null;
        }
        return session;
    }

    private void checkOpen() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startHandshake() throws IOException {
        boolean handshakeCompleted;
        long sslSessionNativePointer;
        int savedWriteTimeoutMilliseconds;
        int savedReadTimeoutMilliseconds;
        OpenSSLSessionImpl sessionToReuse;
        AbstractSessionContext sessionContext;
        boolean enableSessionCreation;
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) return;
            this.state = 1;
        }
        int seedLengthInBytes = 1024;
        SecureRandom secureRandom = this.sslParameters.getSecureRandomMember();
        if (secureRandom == null) {
            NativeCrypto.RAND_load_file("/dev/urandom", 1024L);
        } else {
            NativeCrypto.RAND_seed(secureRandom.generateSeed(1024));
        }
        boolean client = this.sslParameters.getUseClientMode();
        long sslCtxNativePointer = client ? this.sslParameters.getClientSessionContext().sslCtxNativePointer : this.sslParameters.getServerSessionContext().sslCtxNativePointer;
        this.sslNativePointer = 0L;
        boolean releaseResources = true;
        try {
            X509Certificate[] issuers;
            this.sslNativePointer = NativeCrypto.SSL_new(sslCtxNativePointer);
            this.guard.open("close");
            if (this.npnProtocols != null) {
                NativeCrypto.SSL_CTX_enable_npn(sslCtxNativePointer);
            }
            if (client && this.alpnProtocols != null) {
                NativeCrypto.SSL_set_alpn_protos(this.sslNativePointer, this.alpnProtocols);
            }
            if (!client) {
                HashSet<String> keyTypes = new HashSet<String>();
                for (String enabledCipherSuite : this.enabledCipherSuites) {
                    String keyType;
                    if (enabledCipherSuite.equals("TLS_EMPTY_RENEGOTIATION_INFO_SCSV") || (keyType = CipherSuite.getByName(enabledCipherSuite).getServerKeyType()) == null) continue;
                    keyTypes.add(keyType);
                }
                for (String keyType : keyTypes) {
                    try {
                        this.setCertificate(this.sslParameters.getKeyManager().chooseServerAlias(keyType, null, this));
                    }
                    catch (CertificateEncodingException e) {
                        throw new IOException(e);
                    }
                }
            }
            NativeCrypto.setEnabledProtocols(this.sslNativePointer, this.enabledProtocols);
            NativeCrypto.setEnabledCipherSuites(this.sslNativePointer, this.enabledCipherSuites);
            if (this.useSessionTickets) {
                NativeCrypto.SSL_clear_options(this.sslNativePointer, 16384L);
            }
            if (this.hostname != null) {
                NativeCrypto.SSL_set_tlsext_host_name(this.sslNativePointer, this.hostname);
            }
            if (!(enableSessionCreation = this.sslParameters.getEnableSessionCreation())) {
                NativeCrypto.SSL_set_session_creation_enabled(this.sslNativePointer, enableSessionCreation);
            }
            if (client) {
                ClientSessionContext clientSessionContext = this.sslParameters.getClientSessionContext();
                sessionContext = clientSessionContext;
                sessionToReuse = this.getCachedClientSession(clientSessionContext);
                if (sessionToReuse != null) {
                    NativeCrypto.SSL_set_session(this.sslNativePointer, sessionToReuse.sslSessionNativePointer);
                }
            } else {
                sessionContext = this.sslParameters.getServerSessionContext();
                sessionToReuse = null;
            }
            if (!client) {
                X509TrustManager trustManager;
                boolean certRequested;
                if (this.sslParameters.getNeedClientAuth()) {
                    NativeCrypto.SSL_set_verify(this.sslNativePointer, 3);
                    certRequested = true;
                } else if (this.sslParameters.getWantClientAuth()) {
                    NativeCrypto.SSL_set_verify(this.sslNativePointer, 1);
                    certRequested = true;
                } else {
                    certRequested = false;
                }
                if (certRequested && (issuers = (trustManager = this.sslParameters.getTrustManager()).getAcceptedIssuers()) != null && issuers.length != 0) {
                    byte[][] issuersBytes;
                    try {
                        issuersBytes = OpenSSLSocketImpl.encodeIssuerX509Principals(issuers);
                    }
                    catch (CertificateEncodingException e) {
                        throw new IOException("Problem encoding principals", e);
                    }
                    NativeCrypto.SSL_set_client_CA_list(this.sslNativePointer, issuersBytes);
                }
            }
            savedReadTimeoutMilliseconds = this.getSoTimeout();
            savedWriteTimeoutMilliseconds = this.getSoWriteTimeout();
            if (this.handshakeTimeoutMilliseconds >= 0) {
                this.setSoTimeout(this.handshakeTimeoutMilliseconds);
                this.setSoWriteTimeout(this.handshakeTimeoutMilliseconds);
            }
            if (this.channelIdEnabled) {
                if (client) {
                    if (this.channelIdPrivateKey == null) {
                        throw new SSLHandshakeException("Invalid TLS channel ID key specified");
                    }
                    NativeCrypto.SSL_set1_tls_channel_id(this.sslNativePointer, this.channelIdPrivateKey.getPkeyContext());
                } else {
                    NativeCrypto.SSL_enable_tls_channel_id(this.sslNativePointer);
                }
            }
            issuers = this.stateLock;
            synchronized (this.stateLock) {
                if (this.state == 5) {
                    // ** MonitorExit[issuers] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[issuers] (shouldn't be in output)
                try {
                    sslSessionNativePointer = NativeCrypto.SSL_do_handshake(this.sslNativePointer, this.socket.getFileDescriptor$(), this, this.getSoTimeout(), client, this.npnProtocols, client ? null : this.alpnProtocols);
                }
                catch (CertificateException e) {
                    SSLHandshakeException wrapper = new SSLHandshakeException(e.getMessage());
                    wrapper.initCause(e);
                    throw wrapper;
                }
                catch (SSLException e) {
                    Object wrapper = this.stateLock;
                    synchronized (wrapper) {
                        if (this.state != 5) throw e;
                    }
                    if (!releaseResources) return;
                    Object object2 = this.stateLock;
                    synchronized (object2) {
                        this.state = 5;
                        this.stateLock.notifyAll();
                    }
                    try {
                        this.shutdownAndFreeSslNative();
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                handshakeCompleted = false;
            }
        }
        catch (SSLProtocolException e) {
            throw new SSLHandshakeException(e);
        }
        {
            Object wrapper = this.stateLock;
            synchronized (wrapper) {
                if (this.state == 2) {
                    handshakeCompleted = true;
                } else if (this.state == 5) {
                    return;
                }
            }
            byte[] sessionId = NativeCrypto.SSL_SESSION_session_id(sslSessionNativePointer);
            if (sessionToReuse != null && Arrays.equals(sessionToReuse.getId(), sessionId)) {
                this.sslSession = sessionToReuse;
                this.sslSession.lastAccessedTime = System.currentTimeMillis();
                NativeCrypto.SSL_SESSION_free(sslSessionNativePointer);
            } else {
                if (!enableSessionCreation) {
                    throw new IllegalStateException("SSL Session may not be created");
                }
                X509Certificate[] localCertificates = OpenSSLSocketImpl.createCertChain(NativeCrypto.SSL_get_certificate(this.sslNativePointer));
                X509Certificate[] peerCertificates = OpenSSLSocketImpl.createCertChain(NativeCrypto.SSL_get_peer_cert_chain(this.sslNativePointer));
                this.sslSession = new OpenSSLSessionImpl(sslSessionNativePointer, localCertificates, peerCertificates, this.getPeerHostName(), this.getPeerPort(), sessionContext);
                if (handshakeCompleted) {
                    sessionContext.putSession(this.sslSession);
                }
            }
            if (this.handshakeTimeoutMilliseconds >= 0) {
                this.setSoTimeout(savedReadTimeoutMilliseconds);
                this.setSoWriteTimeout(savedWriteTimeoutMilliseconds);
            }
            if (handshakeCompleted) {
                this.notifyHandshakeCompletedListeners();
            }
            Object object3 = this.stateLock;
            synchronized (object3) {
                boolean bl = releaseResources = this.state == 5;
                if (this.state == 1) {
                    this.state = 3;
                } else if (this.state == 2) {
                    this.state = 4;
                }
                if (releaseResources) return;
                this.stateLock.notifyAll();
                return;
            }
        }
        finally {
            if (releaseResources) {
                Object object4 = this.stateLock;
                synchronized (object4) {
                    this.state = 5;
                    this.stateLock.notifyAll();
                }
                try {
                    this.shutdownAndFreeSslNative();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static byte[][] encodeIssuerX509Principals(X509Certificate[] certificates) throws CertificateEncodingException {
        byte[][] principalBytes = new byte[certificates.length][];
        for (int i = 0; i < certificates.length; ++i) {
            principalBytes[i] = certificates[i].getIssuerX500Principal().getEncoded();
        }
        return principalBytes;
    }

    String getPeerHostName() {
        if (this.wrappedHost != null) {
            return this.wrappedHost;
        }
        InetAddress inetAddress = super.getInetAddress();
        if (inetAddress != null) {
            return inetAddress.getHostName();
        }
        return null;
    }

    int getPeerPort() {
        return this.wrappedHost == null ? super.getPort() : this.wrappedPort;
    }

    private static X509Certificate[] createCertChain(byte[][] certificatesBytes) throws IOException {
        if (certificatesBytes == null) {
            return null;
        }
        X509Certificate[] certificates = new X509Certificate[certificatesBytes.length];
        for (int i = 0; i < certificatesBytes.length; ++i) {
            certificates[i] = OpenSSLX509Certificate.fromX509Der(certificatesBytes[i]);
        }
        return certificates;
    }

    private void setCertificate(String alias) throws CertificateEncodingException, SSLException {
        if (alias == null) {
            return;
        }
        PrivateKey privateKey = this.sslParameters.getKeyManager().getPrivateKey(alias);
        if (privateKey == null) {
            return;
        }
        Certificate[] certificates = this.sslParameters.getKeyManager().getCertificateChain(alias);
        if (certificates == null) {
            return;
        }
        byte[][] certificateBytes = NativeCrypto.encodeCertificates(certificates);
        NativeCrypto.SSL_use_certificate(this.sslNativePointer, certificateBytes);
        try {
            OpenSSLKey key = OpenSSLKey.fromPrivateKey(privateKey);
            NativeCrypto.SSL_use_PrivateKey(this.sslNativePointer, key.getPkeyContext());
        }
        catch (InvalidKeyException e) {
            throw new SSLException(e);
        }
        NativeCrypto.SSL_check_private_key(this.sslNativePointer);
    }

    @Override
    public void clientCertificateRequested(byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) throws CertificateEncodingException, SSLException {
        Principal[] issuers;
        String[] keyTypes = new String[keyTypeBytes.length];
        for (int i = 0; i < keyTypeBytes.length; ++i) {
            keyTypes[i] = CipherSuite.getClientKeyType(keyTypeBytes[i]);
        }
        if (asn1DerEncodedPrincipals == null) {
            issuers = null;
        } else {
            issuers = new X500Principal[asn1DerEncodedPrincipals.length];
            for (int i = 0; i < asn1DerEncodedPrincipals.length; ++i) {
                issuers[i] = new X500Principal(asn1DerEncodedPrincipals[i]);
            }
        }
        this.setCertificate(this.sslParameters.getKeyManager().chooseClientAlias(keyTypes, issuers, this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handshakeCompleted() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 1) {
                this.state = 2;
                return;
            }
            if (this.state != 3 && this.state == 5) {
                return;
            }
        }
        this.sslSession.resetId();
        AbstractSessionContext sessionContext = this.sslParameters.getUseClientMode() ? this.sslParameters.getClientSessionContext() : this.sslParameters.getServerSessionContext();
        sessionContext.putSession(this.sslSession);
        this.notifyHandshakeCompletedListeners();
        Object object2 = this.stateLock;
        synchronized (object2) {
            this.state = 4;
            this.stateLock.notifyAll();
        }
    }

    private void notifyHandshakeCompletedListeners() {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.sslSession);
            for (HandshakeCompletedListener listener : this.listeners) {
                try {
                    listener.handshakeCompleted(event);
                }
                catch (RuntimeException e) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                }
            }
        }
    }

    @Override
    public void verifyCertificateChain(byte[][] bytes, String authMethod) throws CertificateException {
        try {
            if (bytes == null || bytes.length == 0) {
                throw new SSLException("Peer sent no certificate");
            }
            X509Certificate[] peerCertificateChain = new X509Certificate[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                peerCertificateChain[i] = OpenSSLX509Certificate.fromX509Der(bytes[i]);
            }
            boolean client = this.sslParameters.getUseClientMode();
            if (client) {
                X509TrustManager x509tm = this.sslParameters.getTrustManager();
                if (x509tm instanceof TrustManagerImpl) {
                    TrustManagerImpl tm = (TrustManagerImpl)x509tm;
                    tm.checkServerTrusted(peerCertificateChain, authMethod, this.wrappedHost);
                } else {
                    x509tm.checkServerTrusted(peerCertificateChain, authMethod);
                }
            } else {
                String authType = peerCertificateChain[0].getPublicKey().getAlgorithm();
                this.sslParameters.getTrustManager().checkClientTrusted(peerCertificateChain, authType);
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream() throws IOException {
        SSLInputStream returnVal;
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 5) {
                throw new SocketException("Socket is closed.");
            }
            if (this.is == null) {
                this.is = new SSLInputStream();
            }
            returnVal = this.is;
        }
        this.waitForHandshake();
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        SSLOutputStream returnVal;
        this.checkOpen();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 5) {
                throw new SocketException("Socket is closed.");
            }
            if (this.os == null) {
                this.os = new SSLOutputStream();
            }
            returnVal = this.os;
        }
        this.waitForHandshake();
        return returnVal;
    }

    private void assertReadableOrWriteableState() {
        if (this.state == 4 || this.state == 3) {
            return;
        }
        throw new AssertionError((Object)("Invalid state: " + this.state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForHandshake() throws IOException {
        this.startHandshake();
        Object object = this.stateLock;
        synchronized (object) {
            while (this.state != 4 && this.state != 3 && this.state != 5) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    IOException ioe = new IOException("Interrupted waiting for handshake");
                    ioe.initCause(e);
                    throw ioe;
                }
            }
            if (this.state == 5) {
                throw new SocketException("Socket is closed");
            }
        }
    }

    @Override
    public SSLSession getSession() {
        if (this.sslSession == null) {
            try {
                this.waitForHandshake();
            }
            catch (IOException e) {
                return SSLSessionImpl.getNullSession();
            }
        }
        return this.sslSession;
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Provided listener is null");
        }
        if (this.listeners == null) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
        if (!this.listeners.remove(listener)) {
            throw new IllegalArgumentException("Provided listener is not registered");
        }
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return (String[])this.enabledCipherSuites.clone();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.enabledCipherSuites = NativeCrypto.checkEnabledCipherSuites(suites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return (String[])this.enabledProtocols.clone();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.enabledProtocols = NativeCrypto.checkEnabledProtocols(protocols);
    }

    public void setUseSessionTickets(boolean useSessionTickets) {
        this.useSessionTickets = useSessionTickets;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelIdEnabled(boolean enabled) {
        if (this.getUseClientMode()) {
            throw new IllegalStateException("Client mode");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException("Could not enable/disable Channel ID after the initial handshake has begun.");
            }
        }
        this.channelIdEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getChannelId() throws SSLException {
        if (this.getUseClientMode()) {
            throw new IllegalStateException("Client mode");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 4) {
                throw new IllegalStateException("Channel ID is only available after handshake completes");
            }
        }
        return NativeCrypto.SSL_get_tls_channel_id(this.sslNativePointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannelIdPrivateKey(PrivateKey privateKey) {
        if (!this.getUseClientMode()) {
            throw new IllegalStateException("Server mode");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException("Could not change Channel ID private key after the initial handshake has begun.");
            }
        }
        if (privateKey == null) {
            this.channelIdEnabled = false;
            this.channelIdPrivateKey = null;
        } else {
            this.channelIdEnabled = true;
            try {
                this.channelIdPrivateKey = OpenSSLKey.fromPrivateKey(privateKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseClientMode(boolean mode) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalArgumentException("Could not change the mode after the initial handshake has begun.");
            }
        }
        this.sslParameters.setUseClientMode(mode);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Method sendUrgentData() is not supported.");
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        throw new SocketException("Methods sendUrgentData, setOOBInline are not supported.");
    }

    @Override
    public void setSoTimeout(int readTimeoutMilliseconds) throws SocketException {
        super.setSoTimeout(readTimeoutMilliseconds);
        this.readTimeoutMilliseconds = readTimeoutMilliseconds;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.readTimeoutMilliseconds;
    }

    public void setSoWriteTimeout(int writeTimeoutMilliseconds) throws SocketException {
        this.writeTimeoutMilliseconds = writeTimeoutMilliseconds;
        StructTimeval tv = StructTimeval.fromMillis(writeTimeoutMilliseconds);
        try {
            Libcore.os.setsockoptTimeval(this.getFileDescriptor$(), OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, tv);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    public int getSoWriteTimeout() throws SocketException {
        return this.writeTimeoutMilliseconds;
    }

    public void setHandshakeTimeout(int handshakeTimeoutMilliseconds) throws SocketException {
        this.handshakeTimeoutMilliseconds = handshakeTimeoutMilliseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        SSLInputStream sslInputStream = null;
        SSLOutputStream sslOutputStream = null;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 5) {
                return;
            }
            int oldState = this.state;
            this.state = 5;
            if (oldState == 0) {
                this.closeUnderlyingSocket();
                this.stateLock.notifyAll();
                return;
            }
            if (oldState != 4 && oldState != 3) {
                NativeCrypto.SSL_interrupt(this.sslNativePointer);
                this.stateLock.notifyAll();
                return;
            }
            this.stateLock.notifyAll();
            sslInputStream = this.is;
            sslOutputStream = this.os;
        }
        if (sslInputStream != null || sslOutputStream != null) {
            NativeCrypto.SSL_interrupt(this.sslNativePointer);
        }
        if (sslInputStream != null) {
            sslInputStream.awaitPendingOps();
        }
        if (sslOutputStream != null) {
            sslOutputStream.awaitPendingOps();
        }
        this.shutdownAndFreeSslNative();
    }

    private void shutdownAndFreeSslNative() throws IOException {
        try {
            BlockGuard.getThreadPolicy().onNetwork();
            NativeCrypto.SSL_shutdown(this.sslNativePointer, this.socket.getFileDescriptor$(), this);
        }
        catch (IOException iOException) {
        }
        finally {
            this.free();
            this.closeUnderlyingSocket();
        }
    }

    private void closeUnderlyingSocket() throws IOException {
        if (this.socket != this) {
            if (this.autoClose && !this.socket.isClosed()) {
                this.socket.close();
            }
        } else if (!super.isClosed()) {
            super.close();
        }
    }

    private void free() {
        if (this.sslNativePointer == 0L) {
            return;
        }
        NativeCrypto.SSL_free(this.sslNativePointer);
        this.sslNativePointer = 0L;
        this.guard.close();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public FileDescriptor getFileDescriptor$() {
        if (this.socket == this) {
            return super.getFileDescriptor$();
        }
        return this.socket.getFileDescriptor$();
    }

    public byte[] getNpnSelectedProtocol() {
        return NativeCrypto.SSL_get_npn_negotiated_protocol(this.sslNativePointer);
    }

    public byte[] getAlpnSelectedProtocol() {
        return NativeCrypto.SSL_get0_alpn_selected(this.sslNativePointer);
    }

    public void setNpnProtocols(byte[] npnProtocols) {
        if (npnProtocols != null && npnProtocols.length == 0) {
            throw new IllegalArgumentException("npnProtocols.length == 0");
        }
        this.npnProtocols = npnProtocols;
    }

    public void setAlpnProtocols(byte[] alpnProtocols) {
        if (alpnProtocols != null && alpnProtocols.length == 0) {
            throw new IllegalArgumentException("alpnProtocols.length == 0");
        }
        this.alpnProtocols = alpnProtocols;
    }

    private class SSLInputStream
    extends InputStream {
        private final Object readLock = new Object();

        SSLInputStream() {
        }

        @Override
        public int read() throws IOException {
            return Streams.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] buf, int offset, int byteCount) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            OpenSSLSocketImpl.this.checkOpen();
            Arrays.checkOffsetAndCount(buf.length, offset, byteCount);
            if (byteCount == 0) {
                return 0;
            }
            Object object = this.readLock;
            synchronized (object) {
                Object object2 = OpenSSLSocketImpl.this.stateLock;
                synchronized (object2) {
                    if (OpenSSLSocketImpl.this.state == 5) {
                        throw new SocketException("socket is closed");
                    }
                }
                return NativeCrypto.SSL_read(OpenSSLSocketImpl.this.sslNativePointer, OpenSSLSocketImpl.this.socket.getFileDescriptor$(), OpenSSLSocketImpl.this, buf, offset, byteCount, OpenSSLSocketImpl.this.getSoTimeout());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitPendingOps() {
            Object object = this.readLock;
            synchronized (object) {
            }
        }
    }

    private class SSLOutputStream
    extends OutputStream {
        private final Object writeLock = new Object();

        SSLOutputStream() {
        }

        @Override
        public void write(int oneByte) throws IOException {
            Streams.writeSingleByte(this, oneByte);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf, int offset, int byteCount) throws IOException {
            BlockGuard.getThreadPolicy().onNetwork();
            OpenSSLSocketImpl.this.checkOpen();
            Arrays.checkOffsetAndCount(buf.length, offset, byteCount);
            if (byteCount == 0) {
                return;
            }
            Object object = this.writeLock;
            synchronized (object) {
                Object object2 = OpenSSLSocketImpl.this.stateLock;
                synchronized (object2) {
                    if (OpenSSLSocketImpl.this.state == 5) {
                        throw new SocketException("socket is closed");
                    }
                }
                NativeCrypto.SSL_write(OpenSSLSocketImpl.this.sslNativePointer, OpenSSLSocketImpl.this.socket.getFileDescriptor$(), OpenSSLSocketImpl.this, buf, offset, byteCount, OpenSSLSocketImpl.this.writeTimeoutMilliseconds);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void awaitPendingOps() {
            Object object = this.writeLock;
            synchronized (object) {
            }
        }
    }
}

