/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AlertException;
import com.android.org.conscrypt.Appendable;
import com.android.org.conscrypt.SSLSocketImpl;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLException;

public final class SSLSocketInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 16384;
    private byte[] buffer = new byte[16384];
    private int pos;
    private int end;
    private final SSLSocketImpl owner;
    private boolean end_reached = false;
    protected Adapter dataPoint = new Adapter();

    protected SSLSocketInputStream(SSLSocketImpl owner) {
        this.owner = owner;
    }

    protected void setEnd() {
        this.end_reached = true;
    }

    @Override
    public int available() throws IOException {
        return this.end - this.pos;
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new IOException("Stream was closed.");
        }
        while (this.pos == this.end) {
            if (this.end_reached) {
                return -1;
            }
            this.owner.needAppData();
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i = 0;
        do {
            int read_b;
            if ((read_b = this.read()) == -1) {
                return i == 0 ? -1 : i;
            }
            b[off + i] = (byte)read_b;
        } while (this.available() != 0 && ++i < len);
        return i;
    }

    private class Adapter
    implements Appendable {
        private Adapter() {
        }

        @Override
        public void append(byte[] src) {
            int length = src.length;
            if (16384 - (SSLSocketInputStream.this.end - SSLSocketInputStream.this.pos) < length) {
                throw new AlertException(80, new SSLException("Could not accept income app data."));
            }
            if (SSLSocketInputStream.this.end + length > 16384) {
                System.arraycopy((Object)SSLSocketInputStream.this.buffer, SSLSocketInputStream.this.pos, (Object)SSLSocketInputStream.this.buffer, 0, SSLSocketInputStream.this.end - SSLSocketInputStream.this.pos);
                SSLSocketInputStream.this.end -= SSLSocketInputStream.this.pos;
                SSLSocketInputStream.this.pos = 0;
            }
            System.arraycopy((Object)src, 0, (Object)SSLSocketInputStream.this.buffer, SSLSocketInputStream.this.end, length);
            SSLSocketInputStream.this.end = SSLSocketInputStream.this.end + length;
        }
    }
}

