/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import libcore.util.EmptyArray;

public class Thread
implements Runnable {
    private static final int NANOS_PER_MILLI = 1000000;
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    private static long count = 0L;
    private static UncaughtExceptionHandler defaultUncaughtHandler = null;
    private volatile long threadPtr = 0L;
    private ThreadGroup group = null;
    private long id = 0L;
    private String name = null;
    private long stackSize;
    private boolean daemon = false;
    private int priority = 5;
    private Runnable target = null;
    private final List<Runnable> interruptActions = new ArrayList<Runnable>();
    private ClassLoader contextClassLoader = null;
    private UncaughtExceptionHandler uncaughtHandler = null;
    boolean started = false;
    ThreadLocal.Values localValues;
    ThreadLocal.Values inheritableValues;
    private int parkState = 1;
    private Object parkBlocker;
    private Object lock = new Object();

    public Thread() {
        this.create(null, null, null, 0L);
    }

    public Thread(Runnable runnable) {
        this.create(null, runnable, null, 0L);
    }

    public Thread(Runnable runnable, String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(null, runnable, threadName, 0L);
    }

    public Thread(String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(null, null, threadName, 0L);
    }

    public Thread(ThreadGroup group, Runnable runnable) {
        this.create(group, runnable, null, 0L);
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(group, runnable, threadName, 0L);
    }

    public Thread(ThreadGroup group, String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(group, null, threadName, 0L);
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName, long stackSize) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(group, runnable, threadName, stackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Thread(long threadPtr, String name, ThreadGroup group, boolean daemon) {
        this.threadPtr = threadPtr;
        this.daemon = daemon;
        this.group = group == null ? ThreadGroup.mMain : group;
        Class<Thread> clazz = Thread.class;
        synchronized (Thread.class) {
            this.id = ++count;
            // ** MonitorExit[var6_5] (shouldn't be in output)
            this.name = name == null ? "Thread-" + this.id : name;
            this.priority = 5;
            this.started = true;
            this.group.addThread(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(ThreadGroup group, Runnable runnable, String threadName, long stackSize) {
        Thread currentThread = Thread.currentThread();
        if (group == null) {
            group = currentThread.getThreadGroup();
        }
        if (group.isDestroyed()) {
            throw new IllegalThreadStateException("Group already destroyed");
        }
        this.group = group;
        Class<Thread> clazz = Thread.class;
        synchronized (Thread.class) {
            this.id = ++count;
            // ** MonitorExit[var7_6] (shouldn't be in output)
            this.name = threadName == null ? "Thread-" + this.id : threadName;
            this.target = runnable;
            this.stackSize = stackSize;
            this.priority = currentThread.getPriority();
            this.contextClassLoader = currentThread.contextClassLoader;
            if (currentThread.inheritableValues != null) {
                this.inheritableValues = new ThreadLocal.Values(currentThread.inheritableValues);
            }
            this.group.addThread(this);
            Thread.hookThreadCreated(this);
            return;
        }
    }

    private static native void hookThreadCreated(Thread var0);

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
    }

    @Deprecated
    public int countStackFrames() {
        return this.getStackTrace().length;
    }

    public static native Thread currentThread();

    @Deprecated
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    public static void dumpStack() {
        new Throwable("stack dump").printStackTrace();
    }

    final void printStackTrace(Throwable t) {
        System.err.print("Exception in thread \"");
        System.err.print(this.name);
        System.err.print("\" ");
        t.printStackTrace(System.err);
        System.err.flush();
    }

    public static int enumerate(Thread[] threads) {
        Thread thread = Thread.currentThread();
        return thread.getThreadGroup().enumerate(threads);
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        HashMap<Thread, StackTraceElement[]> map = new HashMap<Thread, StackTraceElement[]>();
        int count = ThreadGroup.mMain.activeCount();
        Thread[] threads = new Thread[count + count / 2];
        count = ThreadGroup.mMain.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            map.put(threads[i], threads[i].getStackTrace());
        }
        return map;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtHandler;
    }

    public long getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final int getPriority() {
        return this.priority;
    }

    public StackTraceElement[] getStackTrace() {
        if (this.threadPtr == 0L) {
            return EmptyArray.STACK_TRACE_ELEMENT;
        }
        return Thread.internalGetStackTrace(this);
    }

    private static native StackTraceElement[] internalGetStackTrace(Thread var0);

    public State getState() {
        if (this.threadPtr != 0L) {
            int s = Thread.internalGetState(this);
            switch (s) {
                case 0: {
                    return State.TERMINATED;
                }
                case 1: {
                    return State.RUNNABLE;
                }
                case 2: {
                    return State.TIMED_WAITING;
                }
                case 3: {
                    return State.BLOCKED;
                }
                case 4: {
                    return State.WAITING;
                }
                case 5: {
                    return State.NEW;
                }
                case 6: {
                    return State.NEW;
                }
                case 7: {
                    return State.RUNNABLE;
                }
                case 8: {
                    return State.WAITING;
                }
                case 9: {
                    return State.RUNNABLE;
                }
            }
        }
        return this.started ? State.TERMINATED : State.NEW;
    }

    private static native int internalGetState(Thread var0);

    public final ThreadGroup getThreadGroup() {
        if (this.getState() == State.TERMINATED) {
            return null;
        }
        return this.group;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (this.uncaughtHandler != null) {
            return this.uncaughtHandler;
        }
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        if (this.threadPtr != 0L) {
            Thread.internalInterrupt(this);
        }
        List<Runnable> list = this.interruptActions;
        synchronized (list) {
            for (int i = this.interruptActions.size() - 1; i >= 0; --i) {
                this.interruptActions.get(i).run();
            }
        }
    }

    private static native void internalInterrupt(Thread var0);

    public static boolean interrupted() {
        return Thread.internalInterrupted();
    }

    private static native boolean internalInterrupted();

    public final boolean isAlive() {
        return this.threadPtr != 0L;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public boolean isInterrupted() {
        if (this.threadPtr != 0L) {
            return Thread.internalIsInterrupted(this);
        }
        return false;
    }

    private static native boolean internalIsInterrupted(Thread var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join() throws InterruptedException {
        if (this.threadPtr == 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            while (this.isAlive()) {
                this.lock.wait();
            }
        }
    }

    public final void join(long millis) throws InterruptedException {
        this.join(millis, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join(long millis, int nanos) throws InterruptedException {
        boolean forever;
        if (millis < 0L || nanos < 0 || nanos >= 1000000) {
            throw new IllegalArgumentException("bad timeout: millis=" + millis + ",nanos=" + nanos);
        }
        boolean overflow = millis >= (Long.MAX_VALUE - (long)nanos) / 1000000L;
        boolean bl = forever = (millis | (long)nanos) == 0L;
        if (forever | overflow) {
            this.join();
            return;
        }
        if (this.threadPtr == 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isAlive()) {
                return;
            }
            long nanosToWait = millis * 1000000L + (long)nanos;
            long start = System.nanoTime();
            while (true) {
                long nanosElapsed;
                long nanosRemaining;
                this.lock.wait(millis, nanos);
                if (!this.isAlive() || (nanosRemaining = nanosToWait - (nanosElapsed = System.nanoTime() - start)) <= 0L) break;
                millis = nanosRemaining / 1000000L;
                nanos = (int)(nanosRemaining - millis * 1000000L);
            }
        }
    }

    @Deprecated
    public final void resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public void setContextClassLoader(ClassLoader cl) {
        this.contextClassLoader = cl;
    }

    public final void setDaemon(boolean isDaemon) {
        this.checkNotStarted();
        if (this.threadPtr == 0L) {
            this.daemon = isDaemon;
        }
    }

    private void checkNotStarted() {
        if (this.started) {
            throw new IllegalThreadStateException("Thread already started");
        }
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        defaultUncaughtHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushInterruptAction$(Runnable interruptAction) {
        List<Runnable> list = this.interruptActions;
        synchronized (list) {
            this.interruptActions.add(interruptAction);
        }
        if (interruptAction != null && this.isInterrupted()) {
            interruptAction.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void popInterruptAction$(Runnable interruptAction) {
        List<Runnable> list = this.interruptActions;
        synchronized (list) {
            Runnable removed = this.interruptActions.remove(this.interruptActions.size() - 1);
            if (interruptAction != removed) {
                throw new IllegalArgumentException("Expected " + interruptAction + " but was " + removed);
            }
        }
    }

    public final void setName(String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.name = threadName;
        if (this.threadPtr != 0L) {
            Thread.internalSetName(this, threadName);
        }
    }

    private static native void internalSetName(Thread var0, String var1);

    public final void setPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Priority out of range: " + priority);
        }
        if (priority > this.group.getMaxPriority()) {
            priority = this.group.getMaxPriority();
        }
        this.priority = priority;
        if (this.threadPtr != 0L) {
            Thread.internalSetPriority(this, priority);
        }
    }

    private static native void internalSetPriority(Thread var0, int var1);

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        this.uncaughtHandler = handler;
    }

    public static void sleep(long time) throws InterruptedException {
        Thread.sleep(time, 0);
    }

    public static void sleep(long millis, int nanos) throws InterruptedException {
        Thread.internalSleep(millis, nanos);
    }

    private static native void internalSleep(long var0, int var2) throws InterruptedException;

    public synchronized void start() {
        this.checkNotStarted();
        this.started = true;
        Thread.internalStart(this);
    }

    private static native void internalStart(Thread var0);

    @Deprecated
    public final void stop() {
        this.stop(new ThreadDeath());
    }

    @Deprecated
    public final synchronized void stop(Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void suspend() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Thread[" + this.name + "," + this.priority + "," + this.group.getName() + "]";
    }

    public static void yield() {
        Thread.internalYield();
    }

    private static native void internalYield();

    public static boolean holdsLock(Object object) {
        return Thread.internalHoldsLock(object);
    }

    private static native boolean internalHoldsLock(Object var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpark() {
        if (this.threadPtr == 0L) {
            this.parkState = 2;
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            switch (this.parkState) {
                case 2: {
                    break;
                }
                case 1: {
                    this.parkState = 2;
                    break;
                }
                default: {
                    this.parkState = 1;
                    this.lock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parkFor(long nanos) {
        if (this.threadPtr == 0L) {
            throw new AssertionError();
        }
        Object object = this.lock;
        synchronized (object) {
            switch (this.parkState) {
                case 2: {
                    this.parkState = 1;
                    break;
                }
                case 1: {
                    long millis = nanos / 1000000L;
                    nanos %= 1000000L;
                    this.parkState = 3;
                    try {
                        this.lock.wait(millis, (int)nanos);
                        break;
                    }
                    catch (InterruptedException ex) {
                        this.interrupt();
                        break;
                    }
                    finally {
                        if (this.parkState == 3) {
                            this.parkState = 1;
                        }
                    }
                }
                default: {
                    throw new AssertionError((Object)"shouldn't happen: attempt to repark");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parkUntil(long time) {
        if (this.threadPtr == 0L) {
            throw new AssertionError();
        }
        Object object = this.lock;
        synchronized (object) {
            long delayMillis = time - System.currentTimeMillis();
            if (delayMillis <= 0L) {
                this.parkState = 1;
            } else {
                this.parkFor(delayMillis * 1000000L);
            }
        }
    }

    private static class ParkState {
        private static final int UNPARKED = 1;
        private static final int PREEMPTIVELY_UNPARKED = 2;
        private static final int PARKED = 3;

        private ParkState() {
        }
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }
}

