/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import libcore.reflect.GenericSignatureParser;
import libcore.reflect.ListOfTypes;
import libcore.reflect.Types;
import libcore.util.EmptyArray;
import org.robovm.rt.VM;

public final class Constructor<T>
extends AccessibleObject
implements GenericDeclaration,
Member {
    private final long method;
    private int modifiers = -1;
    private Class<T> declaringClass;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private Annotation[] declaredAnnotations;
    private Annotation[][] parameterAnnotations;
    ListOfTypes genericExceptionTypes;
    ListOfTypes genericParameterTypes;
    TypeVariable<Constructor<T>>[] formalTypeParameters;
    private volatile boolean genericTypesAreInitialized = false;

    Constructor(long method) {
        this.method = method;
    }

    Constructor(Constructor<T> orig) {
        this.method = orig.method;
        this.modifiers = orig.modifiers;
        this.declaringClass = orig.declaringClass;
        this.parameterTypes = orig.parameterTypes;
        this.exceptionTypes = orig.exceptionTypes;
        this.genericExceptionTypes = orig.genericExceptionTypes;
        this.genericParameterTypes = orig.genericParameterTypes;
        this.formalTypeParameters = orig.formalTypeParameters;
        this.genericTypesAreInitialized = orig.genericTypesAreInitialized;
        this.declaredAnnotations = orig.declaredAnnotations;
        this.parameterAnnotations = orig.parameterAnnotations;
        if (orig.flag) {
            this.flag = true;
        }
    }

    private synchronized void initGenericTypes() {
        if (!this.genericTypesAreInitialized) {
            String signatureAttribute = this.getSignatureAttribute();
            GenericSignatureParser parser = new GenericSignatureParser(this.getDeclaringClass().getClassLoader());
            parser.parseForConstructor(this, signatureAttribute, this.getExceptionTypes());
            this.formalTypeParameters = parser.formalTypeParameters;
            this.genericParameterTypes = parser.parameterTypes;
            this.genericExceptionTypes = parser.exceptionTypes;
            this.genericTypesAreInitialized = true;
        }
    }

    @Override
    protected String getSignatureAttribute() {
        return Method.getSignatureAttribute(this.method);
    }

    public TypeVariable<Constructor<T>>[] getTypeParameters() {
        this.initGenericTypes();
        return (TypeVariable[])this.formalTypeParameters.clone();
    }

    public String toGenericString() {
        StringBuilder sb = new StringBuilder(80);
        this.initGenericTypes();
        int modifier = this.getModifiers();
        if (modifier != 0) {
            sb.append(Modifier.toString(modifier & 0xFFFFFF7F)).append(' ');
        }
        if (this.formalTypeParameters != null && this.formalTypeParameters.length > 0) {
            sb.append('<');
            for (int i = 0; i < this.formalTypeParameters.length; ++i) {
                this.appendGenericType(sb, this.formalTypeParameters[i]);
                if (i >= this.formalTypeParameters.length - 1) continue;
                sb.append(",");
            }
            sb.append("> ");
        }
        this.appendTypeName(sb, this.getDeclaringClass());
        sb.append('(');
        this.appendArrayGenericType(sb, Types.getTypeArray(this.genericParameterTypes, false));
        sb.append(')');
        Type[] genericExceptionTypeArray = Types.getTypeArray(this.genericExceptionTypes, false);
        if (genericExceptionTypeArray.length > 0) {
            sb.append(" throws ");
            this.appendArrayGenericType(sb, genericExceptionTypeArray);
        }
        return sb.toString();
    }

    public Type[] getGenericParameterTypes() {
        this.initGenericTypes();
        return Types.getTypeArray(this.genericParameterTypes, true);
    }

    public Type[] getGenericExceptionTypes() {
        this.initGenericTypes();
        return Types.getTypeArray(this.genericExceptionTypes, true);
    }

    @Override
    protected Annotation[] getDeclaredAnnotations(boolean copy) {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = Method.getDeclaredAnnotations(this.method);
        }
        return copy ? (Annotation[])this.declaredAnnotations.clone() : this.declaredAnnotations;
    }

    public Annotation[][] getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            Annotation[][] pa = Method.getParameterAnnotations(this.method);
            if (pa.length == 0) {
                pa = Method.noAnnotations(this.getParameterTypes(false).length);
            }
            this.parameterAnnotations = pa;
        }
        return (Annotation[][])this.parameterAnnotations.clone();
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Constructor)) {
            return false;
        }
        Constructor rhs = (Constructor)object;
        return this.getDeclaringClass().equals(rhs.getDeclaringClass()) && Arrays.equals(this.getParameterTypes(false), rhs.getParameterTypes(false));
    }

    public Class<T> getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = Method.getDeclaringClass(this.method);
        }
        return this.declaringClass;
    }

    public Class<?>[] getExceptionTypes() {
        return this.getExceptionTypes(true);
    }

    Class<?>[] getExceptionTypes(boolean copy) {
        if (this.exceptionTypes == null) {
            this.exceptionTypes = Method.getExceptionTypes(this.method);
        }
        return copy ? (Class[])this.exceptionTypes.clone() : this.exceptionTypes;
    }

    @Override
    public int getModifiers() {
        if (this.modifiers == -1) {
            this.modifiers = Method.getModifiers(this.method);
        }
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.getDeclaringClass().getName();
    }

    public Class<?>[] getParameterTypes() {
        return this.getParameterTypes(true);
    }

    Class<?>[] getParameterTypes(boolean copy) {
        if (this.parameterTypes == null) {
            this.parameterTypes = Method.getParameterTypes(this.method);
        }
        return copy ? (Class[])this.parameterTypes.clone() : this.parameterTypes;
    }

    private String getSignature() {
        Class<?>[] parameterTypes = this.getParameterTypes(false);
        StringBuilder result = new StringBuilder();
        result.append('(');
        for (int i = 0; i < parameterTypes.length; ++i) {
            result.append(this.getSignature(parameterTypes[i]));
        }
        result.append(")V");
        return result.toString();
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public T newInstance(Object ... args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?>[] pTypes;
        Class<T> clazz = this.getDeclaringClass();
        int clazzModifiers = clazz.getModifiers();
        if (clazz.isArray() || Modifier.isAbstract(clazzModifiers) || Modifier.isInterface(clazzModifiers) || clazz.isPrimitive()) {
            throw new InstantiationException("class " + clazz.getName() + " cannot be instantiated");
        }
        if (args == null) {
            args = EmptyArray.OBJECT;
        }
        if (args.length != (pTypes = this.getParameterTypes(false)).length) {
            throw new IllegalArgumentException("wrong number of arguments; expected " + pTypes.length + ", got " + args.length);
        }
        if (!this.flag && !Constructor.checkAccessibleFast(this)) {
            Class<?> caller;
            Class<?>[] callers = VM.getStackClasses(0, 2);
            Class<?> clazz2 = caller = callers[0] == Class.class ? callers[1] : callers[0];
            if (!Constructor.checkAccessible(caller, this)) {
                throw new IllegalAccessException(String.format("Attempt to access constructor %s(%s) from class %s", clazz.getName(), this.toString(this.parameterTypes), caller.getName()));
            }
        }
        return (T)Constructor.internalNewInstance(this.method, pTypes, args);
    }

    private static native Object internalNewInstance(long var0, Class<?>[] var2, Object[] var3) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public String toString() {
        Class<T> declaringClass = this.getDeclaringClass();
        Class<?>[] parameterTypes = this.getParameterTypes(false);
        Class<?>[] exceptionTypes = this.getExceptionTypes(false);
        StringBuilder result = new StringBuilder(Modifier.toString(this.getModifiers()));
        if (result.length() != 0) {
            result.append(' ');
        }
        result.append(declaringClass.getName());
        result.append("(");
        result.append(this.toString(parameterTypes));
        result.append(")");
        if (exceptionTypes != null && exceptionTypes.length != 0) {
            result.append(" throws ");
            result.append(this.toString(exceptionTypes));
        }
        return result.toString();
    }
}

