/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

final class ShortArrayBuffer
extends ShortBuffer {
    private final short[] backingArray;
    private final int arrayOffset;
    private final boolean isReadOnly;

    ShortArrayBuffer(short[] array) {
        this(array.length, array, 0, false);
    }

    private ShortArrayBuffer(int capacity, short[] backingArray, int arrayOffset, boolean isReadOnly) {
        super(capacity);
        this.backingArray = backingArray;
        this.arrayOffset = arrayOffset;
        this.isReadOnly = isReadOnly;
    }

    private static ShortArrayBuffer copy(ShortArrayBuffer other, int markOfOther, boolean isReadOnly) {
        ShortArrayBuffer buf = new ShortArrayBuffer(other.capacity(), other.backingArray, other.arrayOffset, isReadOnly);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return ShortArrayBuffer.copy(this, this.mark, true);
    }

    @Override
    public ShortBuffer compact() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        System.arraycopy((Object)this.backingArray, this.position + this.arrayOffset, (Object)this.backingArray, this.arrayOffset, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    @Override
    public ShortBuffer duplicate() {
        return ShortArrayBuffer.copy(this, this.mark, this.isReadOnly);
    }

    @Override
    public ShortBuffer slice() {
        return new ShortArrayBuffer(this.remaining(), this.backingArray, this.arrayOffset + this.position, this.isReadOnly);
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    short[] protectedArray() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.backingArray;
    }

    @Override
    int protectedArrayOffset() {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        return this.arrayOffset;
    }

    @Override
    boolean protectedHasArray() {
        return !this.isReadOnly;
    }

    @Override
    public final short get() {
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.backingArray[this.arrayOffset + this.position++];
    }

    @Override
    public final short get(int index) {
        this.checkIndex(index);
        return this.backingArray[this.arrayOffset + index];
    }

    @Override
    public final ShortBuffer get(short[] dst, int dstOffset, int shortCount) {
        if (shortCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        System.arraycopy((Object)this.backingArray, this.arrayOffset + this.position, (Object)dst, dstOffset, shortCount);
        this.position += shortCount;
        return this;
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public ShortBuffer put(short c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.backingArray[this.arrayOffset + this.position++] = c;
        return this;
    }

    @Override
    public ShortBuffer put(int index, short c) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index);
        this.backingArray[this.arrayOffset + index] = c;
        return this;
    }

    @Override
    public ShortBuffer put(short[] src, int srcOffset, int shortCount) {
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (shortCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        System.arraycopy((Object)src, srcOffset, (Object)this.backingArray, this.arrayOffset + this.position, shortCount);
        this.position += shortCount;
        return this;
    }
}

