/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import dalvik.system.VMStack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import libcore.io.IoUtils;

public abstract class ResourceBundle {
    private static final String UNDER_SCORE = "_";
    private static final String EMPTY_STRING = "";
    protected ResourceBundle parent;
    private Locale locale;
    private long lastLoadTime = 0L;
    private static final ResourceBundle MISSING = new MissingBundle();
    private static final ResourceBundle MISSINGBASE = new MissingBundle();
    private static final WeakHashMap<Object, Hashtable<String, ResourceBundle>> cache = new WeakHashMap();
    private static Locale cacheLocale = Locale.getDefault();

    public static ResourceBundle getBundle(String bundleName) throws MissingResourceException {
        ClassLoader classLoader = VMStack.getCallingClassLoader();
        if (classLoader == null) {
            classLoader = ResourceBundle.getLoader();
        }
        return ResourceBundle.getBundle(bundleName, Locale.getDefault(), classLoader);
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale) {
        ClassLoader classLoader = VMStack.getCallingClassLoader();
        if (classLoader == null) {
            classLoader = ResourceBundle.getLoader();
        }
        return ResourceBundle.getBundle(bundleName, locale, classLoader);
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader loader) throws MissingResourceException {
        if (loader == null) {
            throw new NullPointerException("loader == null");
        }
        if (bundleName == null) {
            throw new NullPointerException("bundleName == null");
        }
        Locale defaultLocale = Locale.getDefault();
        if (!cacheLocale.equals(defaultLocale)) {
            cache.clear();
            cacheLocale = defaultLocale;
        }
        ResourceBundle bundle = null;
        if (!locale.equals(defaultLocale)) {
            bundle = ResourceBundle.handleGetBundle(false, bundleName, locale, loader);
        }
        if (bundle == null && (bundle = ResourceBundle.handleGetBundle(true, bundleName, defaultLocale, loader)) == null) {
            throw ResourceBundle.missingResourceException(bundleName + '_' + locale, EMPTY_STRING);
        }
        return bundle;
    }

    private static MissingResourceException missingResourceException(String className, String key) {
        String detail = "Can't find resource for bundle '" + className + "', key '" + key + "'";
        throw new MissingResourceException(detail, className, key);
    }

    public static ResourceBundle getBundle(String baseName, Control control) {
        return ResourceBundle.getBundle(baseName, Locale.getDefault(), ResourceBundle.getLoader(), control);
    }

    public static ResourceBundle getBundle(String baseName, Locale targetLocale, Control control) {
        return ResourceBundle.getBundle(baseName, targetLocale, ResourceBundle.getLoader(), control);
    }

    private static ClassLoader getLoader() {
        ClassLoader cl = ResourceBundle.class.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static ResourceBundle getBundle(String baseName, Locale targetLocale, ClassLoader loader, Control control) {
        ResourceBundle ret;
        boolean expired = false;
        String bundleName = control.toBundleName(baseName, targetLocale);
        Object cacheKey = loader != null ? loader : "null";
        Hashtable<String, ResourceBundle> loaderCache = ResourceBundle.getLoaderCache(cacheKey);
        ResourceBundle result = loaderCache.get(bundleName);
        if (result != null) {
            long time = control.getTimeToLive(baseName, targetLocale);
            if (time == 0L || time == -2L || time + result.lastLoadTime < System.currentTimeMillis()) {
                if (MISSING == result) {
                    throw new MissingResourceException(null, bundleName + '_' + targetLocale, EMPTY_STRING);
                }
                return result;
            }
            expired = true;
        }
        if ((ret = ResourceBundle.processGetBundle(baseName, targetLocale, loader, control, expired, result)) != null) {
            loaderCache.put(bundleName, ret);
            ret.lastLoadTime = System.currentTimeMillis();
            return ret;
        }
        loaderCache.put(bundleName, MISSING);
        throw new MissingResourceException(null, bundleName + '_' + targetLocale, EMPTY_STRING);
    }

    private static ResourceBundle processGetBundle(String baseName, Locale targetLocale, ClassLoader loader, Control control, boolean expired, ResourceBundle result) {
        Locale nextLocale;
        List<Locale> locales = control.getCandidateLocales(baseName, targetLocale);
        if (locales == null) {
            throw new IllegalArgumentException();
        }
        List<String> formats = control.getFormats(baseName);
        if (Control.FORMAT_CLASS == formats || Control.FORMAT_PROPERTIES == formats || Control.FORMAT_DEFAULT == formats) {
            throw new IllegalArgumentException();
        }
        ResourceBundle ret = null;
        ResourceBundle currentBundle = null;
        ResourceBundle bundle = null;
        block6: for (Locale locale : locales) {
            for (String format : formats) {
                try {
                    if (expired) {
                        bundle = control.newBundle(baseName, locale, format, loader, control.needsReload(baseName, locale, format, loader, result, System.currentTimeMillis()));
                    } else {
                        try {
                            bundle = control.newBundle(baseName, locale, format, loader, false);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (bundle != null) {
                    if (currentBundle != null) {
                        currentBundle.setParent(bundle);
                        currentBundle = bundle;
                    } else if (ret == null) {
                        currentBundle = ret = bundle;
                    }
                }
                if (bundle == null) continue;
                continue block6;
            }
        }
        if ((ret == null || Locale.ROOT.equals(ret.getLocale()) && (locales.size() != 1 || !locales.contains(Locale.ROOT))) && (nextLocale = control.getFallbackLocale(baseName, targetLocale)) != null) {
            ret = ResourceBundle.processGetBundle(baseName, nextLocale, loader, control, expired, result);
        }
        return ret;
    }

    public abstract Enumeration<String> getKeys();

    public Locale getLocale() {
        return this.locale;
    }

    public final Object getObject(String key) {
        ResourceBundle last;
        ResourceBundle theParent = this;
        do {
            Object result;
            if ((result = theParent.handleGetObject(key)) != null) {
                return result;
            }
            last = theParent;
        } while ((theParent = theParent.parent) != null);
        throw ResourceBundle.missingResourceException(last.getClass().getName(), key);
    }

    public final String getString(String key) {
        return (String)this.getObject(key);
    }

    public final String[] getStringArray(String key) {
        return (String[])this.getObject(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle handleGetBundle(boolean loadBase, String base, Locale locale, ClassLoader loader) {
        String localeName = locale.toString();
        String bundleName = localeName.isEmpty() ? base : base + UNDER_SCORE + localeName;
        Object cacheKey = loader != null ? loader : "null";
        Hashtable<String, ResourceBundle> loaderCache = ResourceBundle.getLoaderCache(cacheKey);
        ResourceBundle cached = loaderCache.get(bundleName);
        if (cached != null) {
            if (cached == MISSINGBASE) {
                return null;
            }
            if (cached == MISSING) {
                if (!loadBase) {
                    return null;
                }
                Locale newLocale = ResourceBundle.strip(locale);
                if (newLocale == null) {
                    return null;
                }
                return ResourceBundle.handleGetBundle(loadBase, base, newLocale, loader);
            }
            return cached;
        }
        ResourceBundle bundle = null;
        try {
            Class<?> bundleClass = Class.forName(bundleName, true, loader);
            if (ResourceBundle.class.isAssignableFrom(bundleClass)) {
                bundle = (ResourceBundle)bundleClass.newInstance();
            }
        }
        catch (LinkageError bundleClass) {
        }
        catch (Exception bundleClass) {
            // empty catch block
        }
        if (bundle != null) {
            super.setLocale(locale);
        } else {
            InputStream stream;
            String fileName = bundleName.replace('.', '/') + ".properties";
            InputStream inputStream = stream = loader != null ? loader.getResourceAsStream(fileName) : ClassLoader.getSystemResourceAsStream(fileName);
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    bundle.setLocale(locale);
                }
                catch (IOException iOException) {
                }
                finally {
                    IoUtils.closeQuietly(stream);
                }
            }
        }
        Locale strippedLocale = ResourceBundle.strip(locale);
        if (bundle != null) {
            ResourceBundle parent;
            if (strippedLocale != null && (parent = ResourceBundle.handleGetBundle(loadBase, base, strippedLocale, loader)) != null) {
                bundle.setParent(parent);
            }
            loaderCache.put(bundleName, bundle);
            return bundle;
        }
        if (strippedLocale != null && (loadBase || !strippedLocale.toString().isEmpty()) && (bundle = ResourceBundle.handleGetBundle(loadBase, base, strippedLocale, loader)) != null) {
            loaderCache.put(bundleName, bundle);
            return bundle;
        }
        loaderCache.put(bundleName, loadBase ? MISSINGBASE : MISSING);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Hashtable<String, ResourceBundle> getLoaderCache(Object cacheKey) {
        WeakHashMap<Object, Hashtable<String, ResourceBundle>> weakHashMap = cache;
        synchronized (weakHashMap) {
            Hashtable<String, ResourceBundle> loaderCache = cache.get(cacheKey);
            if (loaderCache == null) {
                loaderCache = new Hashtable();
                cache.put(cacheKey, loaderCache);
            }
            return loaderCache;
        }
    }

    protected abstract Object handleGetObject(String var1);

    protected void setParent(ResourceBundle bundle) {
        this.parent = bundle;
    }

    private static Locale strip(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (!variant.isEmpty()) {
            variant = EMPTY_STRING;
        } else if (!country.isEmpty()) {
            country = EMPTY_STRING;
        } else if (!language.isEmpty()) {
            language = EMPTY_STRING;
        } else {
            return null;
        }
        return new Locale(language, country, variant);
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
    }

    public static void clearCache() {
        cache.remove(ClassLoader.getSystemClassLoader());
    }

    public static void clearCache(ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException("loader == null");
        }
        cache.remove(loader);
    }

    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return this.keySet().contains(key);
    }

    public Set<String> keySet() {
        HashSet<String> ret = new HashSet<String>();
        Enumeration<String> keys = this.getKeys();
        while (keys.hasMoreElements()) {
            ret.add(keys.nextElement());
        }
        return ret;
    }

    protected Set<String> handleKeySet() {
        Set<String> set = this.keySet();
        HashSet<String> ret = new HashSet<String>();
        for (String key : set) {
            if (this.handleGetObject(key) == null) continue;
            ret.add(key);
        }
        return ret;
    }

    public static class Control {
        static List<String> listDefault = new ArrayList<String>();
        static List<String> listClass = new ArrayList<String>();
        static List<String> listProperties = new ArrayList<String>();
        static String JAVACLASS = "java.class";
        static String JAVAPROPERTIES = "java.properties";
        public static final List<String> FORMAT_DEFAULT;
        public static final List<String> FORMAT_CLASS;
        public static final List<String> FORMAT_PROPERTIES;
        public static final long TTL_DONT_CACHE = -1L;
        public static final long TTL_NO_EXPIRATION_CONTROL = -2L;
        private static final Control FORMAT_PROPERTIES_CONTROL;
        private static final Control FORMAT_CLASS_CONTROL;
        private static final Control FORMAT_DEFAULT_CONTROL;
        List<String> format;

        protected Control() {
            listClass = new ArrayList<String>();
            listClass.add(JAVACLASS);
            listClass.add(JAVAPROPERTIES);
            this.format = Collections.unmodifiableList(listClass);
        }

        public static Control getControl(List<String> formats) {
            switch (formats.size()) {
                case 1: {
                    if (formats.contains(JAVACLASS)) {
                        return FORMAT_CLASS_CONTROL;
                    }
                    if (!formats.contains(JAVAPROPERTIES)) break;
                    return FORMAT_PROPERTIES_CONTROL;
                }
                case 2: {
                    if (!formats.equals(FORMAT_DEFAULT)) break;
                    return FORMAT_DEFAULT_CONTROL;
                }
            }
            throw new IllegalArgumentException();
        }

        public static Control getNoFallbackControl(List<String> formats) {
            switch (formats.size()) {
                case 1: {
                    if (formats.contains(JAVACLASS)) {
                        return NoFallbackControl.NOFALLBACK_FORMAT_CLASS_CONTROL;
                    }
                    if (!formats.contains(JAVAPROPERTIES)) break;
                    return NoFallbackControl.NOFALLBACK_FORMAT_PROPERTIES_CONTROL;
                }
                case 2: {
                    if (!formats.equals(FORMAT_DEFAULT)) break;
                    return NoFallbackControl.NOFALLBACK_FORMAT_DEFAULT_CONTROL;
                }
            }
            throw new IllegalArgumentException();
        }

        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException("baseName == null");
            }
            if (locale == null) {
                throw new NullPointerException("locale == null");
            }
            ArrayList<Locale> retList = new ArrayList<Locale>();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (!ResourceBundle.EMPTY_STRING.equals(variant)) {
                retList.add(new Locale(language, country, variant));
            }
            if (!ResourceBundle.EMPTY_STRING.equals(country)) {
                retList.add(new Locale(language, country));
            }
            if (!ResourceBundle.EMPTY_STRING.equals(language)) {
                retList.add(new Locale(language));
            }
            retList.add(Locale.ROOT);
            return retList;
        }

        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException("baseName == null");
            }
            return this.format;
        }

        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException("baseName == null");
            }
            if (locale == null) {
                throw new NullPointerException("locale == null");
            }
            if (Locale.getDefault() != locale) {
                return Locale.getDefault();
            }
            return null;
        }

        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            if (format == null) {
                throw new NullPointerException("format == null");
            }
            if (loader == null) {
                throw new NullPointerException("loader == null");
            }
            String bundleName = this.toBundleName(baseName, locale);
            ClassLoader clsloader = loader;
            if (format.equals(JAVACLASS)) {
                Class<?> cls = null;
                try {
                    cls = clsloader.loadClass(bundleName);
                }
                catch (Exception exception) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                if (cls == null) {
                    return null;
                }
                try {
                    ResourceBundle bundle = (ResourceBundle)cls.newInstance();
                    bundle.setLocale(locale);
                    return bundle;
                }
                catch (NullPointerException e) {
                    return null;
                }
            }
            if (format.equals(JAVAPROPERTIES)) {
                InputStream streams = null;
                String resourceName = this.toResourceName(bundleName, "properties");
                if (reload) {
                    URL url = null;
                    try {
                        url = loader.getResource(resourceName);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (url != null) {
                        URLConnection con = url.openConnection();
                        con.setUseCaches(false);
                        streams = con.getInputStream();
                    }
                } else {
                    try {
                        streams = clsloader.getResourceAsStream(resourceName);
                    }
                    catch (NullPointerException url) {
                        // empty catch block
                    }
                }
                if (streams != null) {
                    PropertyResourceBundle ret;
                    try {
                        ret = new PropertyResourceBundle(new InputStreamReader(streams));
                        ((ResourceBundle)ret).setLocale(locale);
                        streams.close();
                    }
                    catch (IOException e) {
                        return null;
                    }
                    return ret;
                }
                return null;
            }
            throw new IllegalArgumentException();
        }

        public long getTimeToLive(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException("baseName == null");
            }
            if (locale == null) {
                throw new NullPointerException("locale == null");
            }
            return -2L;
        }

        public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
            String fileName;
            long lastModified;
            String urlname;
            URL url;
            if (bundle == null) {
                throw new NullPointerException("bundle == null");
            }
            String bundleName = this.toBundleName(baseName, locale);
            String suffix = format;
            if (format.equals(JAVACLASS)) {
                suffix = "class";
            }
            if (format.equals(JAVAPROPERTIES)) {
                suffix = "properties";
            }
            return (url = loader.getResource(urlname = this.toResourceName(bundleName, suffix))) != null && (lastModified = new File(fileName = url.getFile()).lastModified()) > loadTime;
        }

        public String toBundleName(String baseName, Locale locale) {
            String emptyString = ResourceBundle.EMPTY_STRING;
            String preString = ResourceBundle.UNDER_SCORE;
            String underline = ResourceBundle.UNDER_SCORE;
            if (baseName == null) {
                throw new NullPointerException("baseName == null");
            }
            StringBuilder ret = new StringBuilder();
            StringBuilder prefix = new StringBuilder();
            ret.append(baseName);
            if (!locale.getLanguage().equals(ResourceBundle.EMPTY_STRING)) {
                ret.append(ResourceBundle.UNDER_SCORE);
                ret.append(locale.getLanguage());
            } else {
                prefix.append(ResourceBundle.UNDER_SCORE);
            }
            if (!locale.getCountry().equals(ResourceBundle.EMPTY_STRING)) {
                ret.append(prefix);
                ret.append(ResourceBundle.UNDER_SCORE);
                ret.append(locale.getCountry());
                prefix = new StringBuilder();
            } else {
                prefix.append(ResourceBundle.UNDER_SCORE);
            }
            if (!locale.getVariant().equals(ResourceBundle.EMPTY_STRING)) {
                ret.append(prefix);
                ret.append(ResourceBundle.UNDER_SCORE);
                ret.append(locale.getVariant());
            }
            return ret.toString();
        }

        public final String toResourceName(String bundleName, String suffix) {
            if (suffix == null) {
                throw new NullPointerException("suffix == null");
            }
            StringBuilder ret = new StringBuilder(bundleName.replace('.', '/'));
            ret.append('.');
            ret.append(suffix);
            return ret.toString();
        }

        static {
            listDefault.add(JAVACLASS);
            listDefault.add(JAVAPROPERTIES);
            listClass.add(JAVACLASS);
            listProperties.add(JAVAPROPERTIES);
            FORMAT_DEFAULT = Collections.unmodifiableList(listDefault);
            FORMAT_CLASS = Collections.unmodifiableList(listClass);
            FORMAT_PROPERTIES = Collections.unmodifiableList(listProperties);
            FORMAT_PROPERTIES_CONTROL = new SimpleControl(JAVAPROPERTIES);
            FORMAT_CLASS_CONTROL = new SimpleControl(JAVACLASS);
            FORMAT_DEFAULT_CONTROL = new Control();
        }
    }

    static class MissingBundle
    extends ResourceBundle {
        MissingBundle() {
        }

        @Override
        public Enumeration<String> getKeys() {
            return null;
        }

        @Override
        public Object handleGetObject(String name) {
            return null;
        }
    }

    private static class SimpleControl
    extends Control {
        public SimpleControl(String format) {
            listClass = new ArrayList();
            listClass.add(format);
            this.format = Collections.unmodifiableList(listClass);
        }
    }

    private static class NoFallbackControl
    extends Control {
        static final Control NOFALLBACK_FORMAT_PROPERTIES_CONTROL = new NoFallbackControl(JAVAPROPERTIES);
        static final Control NOFALLBACK_FORMAT_CLASS_CONTROL = new NoFallbackControl(JAVACLASS);
        static final Control NOFALLBACK_FORMAT_DEFAULT_CONTROL = new NoFallbackControl(listDefault);

        public NoFallbackControl(String format) {
            listClass = new ArrayList();
            listClass.add(format);
            this.format = Collections.unmodifiableList(listClass);
        }

        public NoFallbackControl(List<String> list) {
            this.format = list;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null) {
                throw new NullPointerException("baseName == null");
            }
            if (locale == null) {
                throw new NullPointerException("locale == null");
            }
            return null;
        }
    }
}

