/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class DESKeySpec
implements KeySpec {
    public static final int DES_KEY_LEN = 8;
    private final byte[] key;
    private static final byte[][] SEMIWEAKS = new byte[][]{{-32, 1, -32, 1, -15, 1, -15, 1}, {1, -32, 1, -32, 1, -15, 1, -15}, {-2, 31, -2, 31, -2, 14, -2, 14}, {31, -2, 31, -2, 14, -2, 14, -2}, {-32, 31, -32, 31, -15, 14, -15, 14}, {31, -32, 31, -32, 14, -15, 14, -15}, {1, -2, 1, -2, 1, -2, 1, -2}, {-2, 1, -2, 1, -2, 1, -2, 1}, {1, 31, 1, 31, 1, 14, 1, 14}, {31, 1, 31, 1, 14, 1, 14, 1}, {-32, -2, -32, -2, -15, -2, -15, -2}, {-2, -32, -2, -32, -2, -15, -2, -15}, {1, 1, 1, 1, 1, 1, 1, 1}, {-2, -2, -2, -2, -2, -2, -2, -2}, {-32, -32, -32, -32, -15, -15, -15, -15}, {31, 31, 31, 31, 14, 14, 14, 14}};

    public DESKeySpec(byte[] key) throws InvalidKeyException {
        this(key, 0);
    }

    public DESKeySpec(byte[] key, int offset) throws InvalidKeyException {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (key.length - offset < 8) {
            throw new InvalidKeyException("key too short");
        }
        this.key = new byte[8];
        System.arraycopy((Object)key, offset, (Object)this.key, 0, 8);
    }

    public byte[] getKey() {
        byte[] result = new byte[8];
        System.arraycopy((Object)this.key, 0, (Object)result, 0, 8);
        return result;
    }

    public static boolean isParityAdjusted(byte[] key, int offset) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (key.length - offset < 8) {
            throw new InvalidKeyException("key too short");
        }
        int byteKey = 0;
        for (int i = offset; i < 8; ++i) {
            byteKey = key[i];
            byteKey ^= byteKey >> 1;
            byteKey ^= byteKey >> 2;
            if (((byteKey ^= byteKey >> 4) & 1) != 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isWeak(byte[] key, int offset) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("key == null");
        }
        if (key.length - offset < 8) {
            throw new InvalidKeyException("key too short");
        }
        block0: for (int i = 0; i < SEMIWEAKS.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (SEMIWEAKS[i][j] != key[offset + j]) continue block0;
            }
            return true;
        }
        return false;
    }
}

